/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.checks.fight;

import fr.neatmonster.nocheatplus.checks.Check;
import fr.neatmonster.nocheatplus.checks.CheckType;
import fr.neatmonster.nocheatplus.checks.fight.FightConfig;
import fr.neatmonster.nocheatplus.checks.fight.FightData;
import fr.neatmonster.nocheatplus.permissions.Permissions;
import fr.neatmonster.nocheatplus.players.IPlayerData;
import fr.neatmonster.nocheatplus.utilities.TickTask;
import org.bukkit.entity.Player;

public class FastHeal
extends Check {
    public FastHeal() {
        super(CheckType.FIGHT_FASTHEAL);
    }

    public boolean check(Player player, IPlayerData pData) {
        long time = System.currentTimeMillis();
        FightConfig cc = pData.getGenericInstance(FightConfig.class);
        FightData data = pData.getGenericInstance(FightData.class);
        boolean cancel = false;
        if (time < data.fastHealRefTime || time - data.fastHealRefTime >= cc.fastHealInterval) {
            data.fastHealVL *= 0.96;
            data.fastHealBuffer = Math.min(cc.fastHealBuffer, data.fastHealBuffer + 50L);
        } else {
            double correctedDiff = ((double)time - (double)data.fastHealRefTime) * (double)TickTask.getLag(cc.fastHealInterval, true);
            if (correctedDiff < (double)cc.fastHealInterval) {
                data.fastHealBuffer = (long)((double)data.fastHealBuffer - ((double)cc.fastHealInterval - correctedDiff));
                if (data.fastHealBuffer <= 0L) {
                    double violation = ((double)cc.fastHealInterval - correctedDiff) / 1000.0;
                    data.fastHealVL += violation;
                    if (this.executeActions(player, data.fastHealVL, violation, cc.fastHealActions).willCancel()) {
                        cancel = true;
                    }
                }
            }
        }
        if (pData.isDebugActive(this.type) && pData.hasPermission(Permissions.ADMINISTRATION_DEBUG, player)) {
            player.sendMessage("Regain health(SATIATED): " + (time - data.fastHealRefTime) + " ms (buffer=" + data.fastHealBuffer + ") , cancel=" + cancel);
        }
        data.fastHealRefTime = time;
        return cancel;
    }
}

