/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.checks.combined;

import fr.neatmonster.nocheatplus.actions.ActionList;
import fr.neatmonster.nocheatplus.checks.access.ACheckConfig;
import fr.neatmonster.nocheatplus.config.ConfigFile;
import fr.neatmonster.nocheatplus.logging.StaticLog;
import fr.neatmonster.nocheatplus.permissions.Permissions;
import fr.neatmonster.nocheatplus.utilities.StringUtil;
import fr.neatmonster.nocheatplus.worlds.IWorldData;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.event.entity.EntityDamageEvent;

public class CombinedConfig
extends ACheckConfig {
    public final ActionList bedLeaveActions;
    public final boolean enderPearlCheck;
    public final boolean enderPearlPreventClickBlock;
    public final float improbableLevel;
    public final ActionList improbableActions;
    public final boolean invulnerableCheck;
    public final int invulnerableInitialTicksJoin;
    public final Set<EntityDamageEvent.DamageCause> invulnerableIgnore = new HashSet<EntityDamageEvent.DamageCause>();
    public final Map<EntityDamageEvent.DamageCause, Integer> invulnerableModifiers = new HashMap<EntityDamageEvent.DamageCause, Integer>();
    public final int invulnerableModifierDefault;
    public final boolean invulnerableTriggerAlways;
    public final boolean invulnerableTriggerFallDistance;
    public final ActionList munchHausenActions;
    public final float yawRate;
    public final boolean yawRateImprobable;
    public final float yawRatePenaltyFactor;
    public final int yawRatePenaltyMin;
    public final int yawRatePenaltyMax;

    public CombinedConfig(IWorldData worldData) {
        super(worldData);
        ConfigFile config = worldData.getRawConfiguration();
        this.bedLeaveActions = (ActionList)config.getOptimizedActionList("checks.combined.bedleave.actions", Permissions.COMBINED_BEDLEAVE);
        this.enderPearlCheck = config.getBoolean("checks.combined.enderpearl.active");
        this.enderPearlPreventClickBlock = config.getBoolean("checks.combined.enderpearl.preventclickblock");
        this.improbableLevel = (float)config.getDouble("checks.combined.improbable.level");
        this.improbableActions = (ActionList)config.getOptimizedActionList("checks.combined.improbable.actions", Permissions.COMBINED_IMPROBABLE);
        this.invulnerableCheck = config.getBoolean("checks.combined.invulnerable.active");
        this.invulnerableInitialTicksJoin = config.getInt("checks.combined.invulnerable.initialticks.join");
        boolean error = false;
        for (String input : config.getStringList("checks.combined.invulnerable.ignore")) {
            String normInput = input.trim().toUpperCase();
            try {
                this.invulnerableIgnore.add(EntityDamageEvent.DamageCause.valueOf((String)normInput.replace(' ', '_').replace('-', '_')));
            }
            catch (Exception e) {
                error = true;
                StaticLog.logWarning("Bad damage cause (combined.invulnerable.ignore): " + input);
            }
        }
        Integer defaultMod = 0;
        ConfigurationSection sec = config.getConfigurationSection("checks.combined.invulnerable.modifiers");
        for (String input : sec.getKeys(false)) {
            int modifier = sec.getInt(input, 0);
            String normInput = input.trim().toUpperCase();
            if (normInput.equals("ALL")) {
                defaultMod = modifier;
                continue;
            }
            try {
                this.invulnerableModifiers.put(EntityDamageEvent.DamageCause.valueOf((String)normInput.replace(' ', '_').replace('-', '_')), modifier);
            }
            catch (Exception e) {
                error = true;
                StaticLog.logWarning("Bad damage cause (combined.invulnerable.modifiers): " + input);
            }
        }
        this.invulnerableModifierDefault = defaultMod;
        if (error) {
            StaticLog.logInfo("Damage causes can be: " + StringUtil.join(Arrays.asList(EntityDamageEvent.DamageCause.values()), ", "));
        }
        this.invulnerableTriggerAlways = config.getBoolean("checks.combined.invulnerable.triggers.always");
        this.invulnerableTriggerFallDistance = config.getBoolean("checks.combined.invulnerable.triggers.falldistance");
        this.munchHausenActions = (ActionList)config.getOptimizedActionList("checks.combined.munchhausen.actions", Permissions.COMBINED_MUNCHHAUSEN);
        this.yawRate = config.getInt("checks.combined.yawrate.rate");
        this.yawRateImprobable = config.getBoolean("checks.combined.yawrate.improbable");
        this.yawRatePenaltyFactor = (float)config.getDouble("checks.combined.yawrate.penalty.factor");
        this.yawRatePenaltyMin = config.getInt("checks.combined.yawrate.penalty.minimum");
        this.yawRatePenaltyMax = config.getInt("checks.combined.yawrate.penalty.maximum");
    }
}

