/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.checks.chat;

import fr.neatmonster.nocheatplus.checks.Check;
import fr.neatmonster.nocheatplus.checks.CheckType;
import fr.neatmonster.nocheatplus.checks.chat.ChatConfig;
import fr.neatmonster.nocheatplus.checks.chat.ChatData;
import fr.neatmonster.nocheatplus.checks.chat.ICaptcha;
import fr.neatmonster.nocheatplus.players.DataManager;
import fr.neatmonster.nocheatplus.players.IPlayerData;
import fr.neatmonster.nocheatplus.utilities.CheckUtils;
import fr.neatmonster.nocheatplus.utilities.ColorUtil;
import java.util.Random;
import org.bukkit.entity.Player;

public class Captcha
extends Check
implements ICaptcha {
    private final Random random = CheckUtils.getRandom();

    public Captcha() {
        super(CheckType.CHAT_CAPTCHA);
        if (this.random == null) {
            throw new IllegalStateException("No Random instance registered.");
        }
    }

    @Override
    public void checkCaptcha(Player player, String message, ChatConfig cc, ChatData data, boolean isMainThread) {
        if (message.equals(data.captchaGenerated)) {
            data.reset();
            data.captchaStarted = false;
            player.sendMessage(ColorUtil.replaceColors(cc.captchaSuccess));
        } else {
            ++data.captchTries;
            data.captchaVL += 1.0;
            if (data.captchTries > cc.captchaTries) {
                this.executeActions(player, data.captchaVL, 1.0, cc.captchaActions);
            }
            if (player.isOnline()) {
                this.sendCaptcha(player, cc, data);
            }
        }
    }

    @Override
    public void sendNewCaptcha(Player player, ChatConfig cc, ChatData data) {
        this.generateCaptcha(cc, data, true);
        this.sendCaptcha(player, cc, data);
        data.captchaStarted = true;
    }

    @Override
    public void generateCaptcha(ChatConfig cc, ChatData data, boolean reset) {
        if (reset) {
            data.captchTries = 0;
        }
        char[] chars = new char[cc.captchaLength];
        for (int i = 0; i < cc.captchaLength; ++i) {
            chars[i] = cc.captchaCharacters.charAt(this.random.nextInt(cc.captchaCharacters.length()));
        }
        data.captchaGenerated = new String(chars);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resetCaptcha(Player player) {
        ChatData data;
        IPlayerData pData = DataManager.getPlayerData(player);
        ChatData chatData = data = pData.getGenericInstance(ChatData.class);
        synchronized (chatData) {
            this.resetCaptcha(player, pData.getGenericInstance(ChatConfig.class), data, pData);
        }
    }

    @Override
    public void resetCaptcha(Player player, ChatConfig cc, ChatData data, IPlayerData pData) {
        data.captchTries = 0;
        if (this.shouldCheckCaptcha(player, cc, data, pData) || this.shouldStartCaptcha(player, cc, data, pData)) {
            this.generateCaptcha(cc, data, true);
        }
    }

    @Override
    public void sendCaptcha(Player player, ChatConfig cc, ChatData data) {
        player.sendMessage(ColorUtil.replaceColors(cc.captchaQuestion.replace("[captcha]", data.captchaGenerated)));
    }

    @Override
    public boolean shouldStartCaptcha(Player player, ChatConfig cc, ChatData data, IPlayerData pData) {
        return !data.captchaStarted && pData.isCheckActive(CheckType.CHAT_CAPTCHA, player);
    }

    @Override
    public boolean shouldCheckCaptcha(Player player, ChatConfig cc, ChatData data, IPlayerData pData) {
        return data.captchaStarted && pData.isCheckActive(CheckType.CHAT_CAPTCHA, player);
    }
}

