/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.checks.blockplace;

import fr.neatmonster.nocheatplus.NCPAPIProvider;
import fr.neatmonster.nocheatplus.checks.CheckListener;
import fr.neatmonster.nocheatplus.checks.CheckType;
import fr.neatmonster.nocheatplus.checks.blockinteract.BlockInteractData;
import fr.neatmonster.nocheatplus.checks.blockinteract.BlockInteractListener;
import fr.neatmonster.nocheatplus.checks.blockplace.Against;
import fr.neatmonster.nocheatplus.checks.blockplace.AutoSign;
import fr.neatmonster.nocheatplus.checks.blockplace.BlockPlaceConfig;
import fr.neatmonster.nocheatplus.checks.blockplace.BlockPlaceData;
import fr.neatmonster.nocheatplus.checks.blockplace.Direction;
import fr.neatmonster.nocheatplus.checks.blockplace.FastPlace;
import fr.neatmonster.nocheatplus.checks.blockplace.NoSwing;
import fr.neatmonster.nocheatplus.checks.blockplace.Reach;
import fr.neatmonster.nocheatplus.checks.blockplace.Speed;
import fr.neatmonster.nocheatplus.checks.combined.Combined;
import fr.neatmonster.nocheatplus.checks.combined.CombinedConfig;
import fr.neatmonster.nocheatplus.checks.combined.Improbable;
import fr.neatmonster.nocheatplus.checks.moving.MovingConfig;
import fr.neatmonster.nocheatplus.checks.moving.util.MovingUtil;
import fr.neatmonster.nocheatplus.checks.net.FlyingQueueHandle;
import fr.neatmonster.nocheatplus.checks.net.model.DataPacketFlying;
import fr.neatmonster.nocheatplus.compat.Bridge1_9;
import fr.neatmonster.nocheatplus.compat.BridgeMisc;
import fr.neatmonster.nocheatplus.compat.MCAccess;
import fr.neatmonster.nocheatplus.components.NoCheatPlusAPI;
import fr.neatmonster.nocheatplus.components.data.ICheckData;
import fr.neatmonster.nocheatplus.components.data.IData;
import fr.neatmonster.nocheatplus.components.registry.factory.IFactoryOne;
import fr.neatmonster.nocheatplus.components.registry.setup.config.RegisterConfigWorld;
import fr.neatmonster.nocheatplus.components.registry.setup.data.RegisterDataPlayer;
import fr.neatmonster.nocheatplus.permissions.Permissions;
import fr.neatmonster.nocheatplus.players.DataManager;
import fr.neatmonster.nocheatplus.players.IPlayerData;
import fr.neatmonster.nocheatplus.players.PlayerFactoryArgument;
import fr.neatmonster.nocheatplus.stats.Counters;
import fr.neatmonster.nocheatplus.utilities.ReflectionUtil;
import fr.neatmonster.nocheatplus.utilities.TickTask;
import fr.neatmonster.nocheatplus.utilities.map.BlockProperties;
import fr.neatmonster.nocheatplus.utilities.map.MaterialUtil;
import fr.neatmonster.nocheatplus.worlds.WorldFactoryArgument;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.block.SignChangeEvent;
import org.bukkit.event.entity.ProjectileLaunchEvent;
import org.bukkit.event.player.PlayerAnimationEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;

public class BlockPlaceListener
extends CheckListener {
    private static final int p1 = 73856093;
    private static final int p2 = 19349663;
    private static final int p3 = 83492791;
    private final Against against = this.addCheck(new Against());
    private final AutoSign autoSign = this.addCheck(new AutoSign());
    private final Direction direction = this.addCheck(new Direction());
    private final FastPlace fastPlace = this.addCheck(new FastPlace());
    private final NoSwing noSwing = this.addCheck(new NoSwing());
    private final Reach reach = this.addCheck(new Reach());
    private final Speed speed = this.addCheck(new Speed());
    private final Location useLoc = new Location(null, 0.0, 0.0, 0.0);
    private final Counters counters = NCPAPIProvider.getNoCheatPlusAPI().getGenericInstance(Counters.class);
    private final int idBoatsAnywhere = this.counters.registerKey("boatsanywhere");
    private final int idEnderPearl = this.counters.registerKey("throwenderpearl");
    private final Class<?> blockMultiPlaceEvent = ReflectionUtil.getClass("org.bukkit.event.block.BlockMultiPlaceEvent");
    private final boolean hasGetReplacedState = ReflectionUtil.getMethodNoArgs(BlockPlaceEvent.class, "getReplacedState", BlockState.class) != null;

    private static final int getHash(int x, int y, int z) {
        return 73856093 * x ^ 19349663 * y ^ 83492791 * z;
    }

    public static int getCoordHash(Block block) {
        return BlockPlaceListener.getHash(block.getX(), block.getY(), block.getZ());
    }

    public static int getBlockPlaceHash(Block block, Material mat) {
        int hash = BlockPlaceListener.getCoordHash(block);
        if (mat != null) {
            hash |= mat.name().hashCode();
        }
        return hash |= block.getWorld().getName().hashCode();
    }

    public BlockPlaceListener() {
        super(CheckType.BLOCKPLACE);
        NoCheatPlusAPI api = NCPAPIProvider.getNoCheatPlusAPI();
        api.register(((RegisterDataPlayer)((RegisterConfigWorld)api.newRegistrationContext().registerConfigWorld(BlockPlaceConfig.class).factory((IFactoryOne)new IFactoryOne<WorldFactoryArgument, BlockPlaceConfig>(){

            @Override
            public BlockPlaceConfig getNewInstance(WorldFactoryArgument arg) {
                return new BlockPlaceConfig(arg.worldData);
            }
        })).registerConfigTypesPlayer().context().registerDataPlayer(BlockPlaceData.class).factory((IFactoryOne)new IFactoryOne<PlayerFactoryArgument, BlockPlaceData>(){

            @Override
            public BlockPlaceData getNewInstance(PlayerFactoryArgument arg) {
                return new BlockPlaceData();
            }
        })).addToGroups(CheckType.BLOCKPLACE, true, new Class[]{IData.class, ICheckData.class}).context());
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOWEST)
    public void onBlockPlace(BlockPlaceEvent event) {
        FlyingQueueHandle flyingHandle;
        boolean shouldSkipSome;
        ItemStack stack;
        Block block = event.getBlockPlaced();
        Block blockAgainst = event.getBlockAgainst();
        if (block == null || blockAgainst == null) {
            return;
        }
        Player player = event.getPlayer();
        Material placedMat = this.hasGetReplacedState ? event.getBlockPlaced().getType() : (Bridge1_9.hasGetItemInOffHand() ? (BlockProperties.isAir(stack = event.getItemInHand()) ? Material.AIR : stack.getType()) : Bridge1_9.getItemInMainHand(player).getType());
        boolean cancelled = false;
        IPlayerData pData = DataManager.getPlayerData(player);
        BlockPlaceData data = pData.getGenericInstance(BlockPlaceData.class);
        BlockPlaceConfig cc = pData.getGenericInstance(BlockPlaceConfig.class);
        BlockInteractData bdata = pData.getGenericInstance(BlockInteractData.class);
        int tick = TickTask.getTick();
        boolean isInteractBlock = !bdata.getLastIsCancelled() && bdata.matchesLastBlock(tick, blockAgainst);
        int skippedRedundantChecks = 0;
        boolean debug = pData.isDebugActive(CheckType.BLOCKPLACE);
        if (this.blockMultiPlaceEvent != null && event.getClass() == this.blockMultiPlaceEvent) {
            if (placedMat == Material.BEDROCK || Bridge1_9.hasEndCrystalItem() && placedMat == Bridge1_9.END_CRYSTAL_ITEM) {
                shouldSkipSome = true;
            } else {
                if (debug) {
                    this.debug(player, "Block place " + event.getClass().getName() + " " + placedMat);
                }
                shouldSkipSome = false;
            }
        } else {
            shouldSkipSome = false;
        }
        if (placedMat == Material.SIGN) {
            data.autoSignPlacedTime = System.currentTimeMillis();
            data.autoSignPlacedHash = BlockPlaceListener.getBlockPlaceHash(block, Material.SIGN);
        }
        if (!cancelled && pData.isPlayerSetBackScheduled()) {
            cancelled = true;
        }
        if (!cancelled && this.fastPlace.isEnabled(player, pData)) {
            if (this.fastPlace.check(player, block, tick, data, cc, pData)) {
                cancelled = true;
            } else {
                Improbable.feed(player, 0.5f, System.currentTimeMillis(), pData);
            }
        }
        if (!cancelled && !cc.noSwingExceptions.contains(placedMat) && this.noSwing.isEnabled(player, pData) && this.noSwing.check(player, data, cc)) {
            cancelled = true;
        }
        boolean reachCheck = pData.isCheckActive(CheckType.BLOCKPLACE_REACH, player);
        boolean directionCheck = pData.isCheckActive(CheckType.BLOCKPLACE_DIRECTION, player);
        if (reachCheck || directionCheck) {
            flyingHandle = new FlyingQueueHandle(pData);
            Location loc = player.getLocation(this.useLoc);
            double eyeHeight = MovingUtil.getEyeHeight(player);
            if (!cancelled && !shouldSkipSome) {
                if (isInteractBlock && bdata.isPassedCheck(CheckType.BLOCKINTERACT_REACH)) {
                    ++skippedRedundantChecks;
                } else if (reachCheck && this.reach.check(player, eyeHeight, block, data, cc)) {
                    cancelled = true;
                }
            }
            if (!cancelled && !shouldSkipSome) {
                if (isInteractBlock && bdata.isPassedCheck(CheckType.BLOCKINTERACT_DIRECTION)) {
                    ++skippedRedundantChecks;
                } else if (directionCheck && this.direction.check(player, loc, eyeHeight, block, flyingHandle, data, cc, pData)) {
                    cancelled = true;
                }
            }
            this.useLoc.setWorld(null);
        } else {
            flyingHandle = null;
        }
        if (!cancelled && this.against.isEnabled(player, pData) && this.against.check(player, block, placedMat, blockAgainst, isInteractBlock, data, cc, pData)) {
            cancelled = true;
        }
        if (cancelled) {
            event.setCancelled(cancelled);
        } else if (debug) {
            this.debugBlockPlace(player, placedMat, block, blockAgainst, skippedRedundantChecks, flyingHandle, pData);
        }
    }

    private void debugBlockPlace(Player player, Material placedMat, Block block, Block blockAgainst, int skippedRedundantChecks, FlyingQueueHandle flyingHandle, IPlayerData pData) {
        int flyingIndex;
        DataPacketFlying packet;
        this.debug(player, "Block place(" + placedMat + "): " + block.getX() + ", " + block.getY() + ", " + block.getZ());
        BlockInteractListener.debugBlockVSBlockInteract(player, this.checkType, blockAgainst, "onBlockPlace(blockAgainst)", Action.RIGHT_CLICK_BLOCK, pData);
        if (skippedRedundantChecks > 0) {
            this.debug(player, "Skipped redundant checks: " + skippedRedundantChecks);
        }
        if (flyingHandle != null && flyingHandle.isFlyingQueueFetched() && (packet = flyingHandle.getIfFetched(flyingIndex = flyingHandle.getFirstIndexWithContentIfFetched())) != null) {
            this.debug(player, "Flying packet queue used at index " + flyingIndex + ": pitch=" + packet.getPitch() + ",yaw=" + packet.getYaw());
            return;
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onSignChange(SignChangeEvent event) {
        if (event.getClass() != SignChangeEvent.class) {
            return;
        }
        Player player = event.getPlayer();
        Block block = event.getBlock();
        String[] lines = event.getLines();
        if (block == null || lines == null || player == null) {
            return;
        }
        IPlayerData pData = DataManager.getPlayerData(player);
        if (this.autoSign.isEnabled(player, pData) && this.autoSign.check(player, block, lines, pData)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerAnimation(PlayerAnimationEvent event) {
        DataManager.getPlayerData((Player)event.getPlayer()).getGenericInstance(BlockPlaceData.class).noSwingArmSwung = true;
    }

    @EventHandler(ignoreCancelled=false, priority=EventPriority.LOWEST)
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        Player player = event.getPlayer();
        ItemStack stack = Bridge1_9.getUsedItem(player, event);
        if (stack == null) {
            return;
        }
        IPlayerData pData = DataManager.getPlayerData(player);
        BlockPlaceConfig cc = pData.getGenericInstance(BlockPlaceConfig.class);
        Material type = stack.getType();
        if (MaterialUtil.isBoat(type)) {
            if (cc.preventBoatsAnywhere) {
                this.checkBoatsAnywhere(player, event, cc, pData);
            }
        } else if (MaterialUtil.isSpawnEgg(type) && this.speed.isEnabled(player, pData) && this.speed.check(player, cc, pData)) {
            event.setCancelled(true);
        }
    }

    private void checkBoatsAnywhere(Player player, PlayerInteractEvent event, BlockPlaceConfig cc, IPlayerData pData) {
        Block block = event.getClickedBlock();
        Material mat = block.getType();
        if (BlockProperties.isWater(mat)) {
            return;
        }
        BlockFace blockFace = event.getBlockFace();
        Block relBlock = block.getRelative(blockFace);
        Material relMat = relBlock.getType();
        if (BlockProperties.isWater(relMat)) {
            return;
        }
        if (!pData.hasPermission(Permissions.BLOCKPLACE_BOATSANYWHERE, player)) {
            Event.Result previousUseBlock = event.useInteractedBlock();
            event.setCancelled(true);
            event.setUseItemInHand(Event.Result.DENY);
            event.setUseInteractedBlock(previousUseBlock == Event.Result.DEFAULT ? Event.Result.ALLOW : previousUseBlock);
            this.counters.addPrimaryThread(this.idBoatsAnywhere, 1);
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOWEST)
    public void onProjectileLaunch(ProjectileLaunchEvent event) {
        Projectile projectile = event.getEntity();
        Player player = BridgeMisc.getShooterPlayer(projectile);
        if (player == null) {
            return;
        }
        if (MovingUtil.hasScheduledPlayerSetBack(player)) {
            event.setCancelled(true);
            return;
        }
        EntityType type = event.getEntityType();
        switch (type) {
            case ENDER_PEARL: {
                break;
            }
            case ENDER_SIGNAL: {
                break;
            }
            case EGG: {
                break;
            }
            case SNOWBALL: {
                break;
            }
            case THROWN_EXP_BOTTLE: {
                break;
            }
            case SPLASH_POTION: {
                break;
            }
            default: {
                return;
            }
        }
        IPlayerData pData = DataManager.getPlayerData(player);
        BlockPlaceConfig cc = pData.getGenericInstance(BlockPlaceConfig.class);
        boolean cancel = false;
        if (this.speed.isEnabled(player, pData)) {
            long now = System.currentTimeMillis();
            Location loc = player.getLocation(this.useLoc);
            if (Combined.checkYawRate(player, loc.getYaw(), now, loc.getWorld().getName(), pData)) {
                cancel = true;
            }
            if (this.speed.check(player, cc, pData)) {
                cancel = true;
            } else if (Improbable.check(player, 0.6f, now, "blockplace.speed", pData)) {
                cancel = true;
            }
        }
        if (!cancel && type == EntityType.ENDER_PEARL) {
            if (pData.getGenericInstance(CombinedConfig.class).enderPearlCheck) {
                if (!BlockProperties.isPassable(projectile.getLocation(this.useLoc))) {
                    cancel = true;
                } else if (!BlockProperties.isPassable(player.getEyeLocation(), projectile.getLocation(this.useLoc))) {
                    cancel = true;
                } else {
                    Material mat = player.getLocation(this.useLoc).getBlock().getType();
                    long flags = BlockProperties.F_CLIMBABLE | BlockProperties.F_LIQUID | BlockProperties.F_IGN_PASSABLE;
                    if (!(BlockProperties.isAir(mat) || (BlockProperties.getBlockFlags(mat) & flags) != 0L || ((MCAccess)this.mcAccess.getHandle()).hasGravity(mat) || BlockProperties.isPassable(player.getLocation(), projectile.getLocation()) || BlockProperties.isOnGroundOrResetCond(player, player.getLocation(), pData.getGenericInstance(MovingConfig.class).yOnGround))) {
                        cancel = true;
                    }
                }
            }
            if (cancel) {
                this.counters.addPrimaryThread(this.idEnderPearl, 1);
            }
        }
        if (cancel) {
            event.setCancelled(true);
        }
        this.useLoc.setWorld(null);
    }
}

