/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.checks.blockplace;

import fr.neatmonster.nocheatplus.actions.ParameterName;
import fr.neatmonster.nocheatplus.checks.Check;
import fr.neatmonster.nocheatplus.checks.CheckType;
import fr.neatmonster.nocheatplus.checks.ViolationData;
import fr.neatmonster.nocheatplus.checks.blockplace.BlockPlaceConfig;
import fr.neatmonster.nocheatplus.checks.blockplace.BlockPlaceData;
import fr.neatmonster.nocheatplus.checks.blockplace.BlockPlaceListener;
import fr.neatmonster.nocheatplus.compat.BridgeMaterial;
import fr.neatmonster.nocheatplus.players.IPlayerData;
import fr.neatmonster.nocheatplus.utilities.StringUtil;
import fr.neatmonster.nocheatplus.utilities.TickTask;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;

public class AutoSign
extends Check {
    private static long maxEditTime = 1500L;
    private static long minEditTime = 150L;
    private static long minLineTime = 50L;
    private static long minCharTime = 50L;
    private final List<String> tags = new ArrayList<String>();
    final Set<Character> chars = new HashSet<Character>(60);

    public AutoSign() {
        super(CheckType.BLOCKPLACE_AUTOSIGN);
    }

    public boolean check(Player player, Block block, String[] lines, IPlayerData pData) {
        long time = System.currentTimeMillis();
        this.tags.clear();
        BlockPlaceData data = pData.getGenericInstance(BlockPlaceData.class);
        BlockPlaceConfig cc = pData.getGenericInstance(BlockPlaceConfig.class);
        Material mat = block.getType();
        if (mat == BridgeMaterial.SIGN || mat == Material.WALL_SIGN) {
            mat = Material.SIGN;
        }
        if (data.autoSignPlacedHash != (long)BlockPlaceListener.getBlockPlaceHash(block, mat)) {
            this.tags.add("block_mismatch");
            return this.handleViolation(player, maxEditTime, data, cc);
        }
        if (time < data.autoSignPlacedTime) {
            data.autoSignPlacedTime = 0L;
            return false;
        }
        long editTime = time - data.autoSignPlacedTime;
        long expected = this.getExpectedEditTime(lines, cc.autoSignSkipEmpty);
        if (expected == 0L) {
            return false;
        }
        if ((expected = (long)((float)expected / TickTask.getLag(expected, true))) > editTime) {
            this.tags.add("edit_time");
            return this.handleViolation(player, expected - editTime, data, cc);
        }
        return false;
    }

    private long getExpectedEditTime(String[] lines, boolean skipEmpty) {
        long expected = minEditTime;
        int n = 0;
        for (String line : lines) {
            if (line == null || (line = line.trim().toLowerCase()).isEmpty()) continue;
            this.chars.clear();
            ++n;
            for (char c : line.toCharArray()) {
                this.chars.add(Character.valueOf(c));
            }
            expected += minCharTime * (long)this.chars.size();
        }
        if (skipEmpty && n == 0) {
            return 0L;
        }
        if (n > 1) {
            expected += minLineTime * (long)n;
        }
        return expected;
    }

    private boolean handleViolation(Player player, long violationTime, BlockPlaceData data, BlockPlaceConfig cc) {
        double addedVL = 10.0 * (double)Math.min(maxEditTime, violationTime) / (double)maxEditTime;
        data.autoSignVL += addedVL;
        ViolationData vd = new ViolationData(this, player, data.autoSignVL, addedVL, cc.autoSignActions);
        if (vd.needsParameters()) {
            vd.setParameter(ParameterName.TAGS, StringUtil.join(this.tags, "+"));
        }
        return this.executeActions(vd).willCancel();
    }
}

