/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.checks.blockinteract;

import fr.neatmonster.nocheatplus.checks.CheckType;
import fr.neatmonster.nocheatplus.checks.access.ACheckData;
import fr.neatmonster.nocheatplus.utilities.TickTask;
import fr.neatmonster.nocheatplus.utilities.location.TrigUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.event.Event;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;

public class BlockInteractData
extends ACheckData {
    public double directionVL = 0.0;
    public double reachVL = 0.0;
    public double speedVL = 0.0;
    public double visibleVL = 0.0;
    private int lastX = Integer.MAX_VALUE;
    private int lastY;
    private int lastZ;
    private Material lastType = null;
    private int lastTick;
    private Action lastAction = null;
    private boolean lastAllowUseBlock = false;
    private boolean lastAllowUseItem = false;
    private boolean lastIsCancelled = true;
    public double reachDistance;
    public long speedTime = 0L;
    public int speedCount = 0;
    public int subsequentCancel = 0;
    public int rateLimitSkip = 0;
    private final Set<CheckType> passedChecks = new HashSet<CheckType>();
    private final Set<CheckType> consumedChecks = new HashSet<CheckType>();

    public void setLastBlock(Block block, Action action) {
        this.lastTick = TickTask.getTick();
        this.lastAction = action;
        this.lastX = block.getX();
        this.lastY = block.getY();
        this.lastZ = block.getZ();
        this.lastType = block.getType();
        if (this.lastType == Material.AIR) {
            this.lastType = null;
        }
        this.resetPassedChecks();
        this.resetConsumedChecks();
    }

    public void resetLastBlock() {
        this.lastTick = 0;
        this.lastAction = null;
        this.lastX = Integer.MAX_VALUE;
        this.lastType = null;
        this.lastAllowUseBlock = false;
        this.lastAllowUseItem = false;
        this.lastIsCancelled = true;
        this.resetPassedChecks();
        this.resetConsumedChecks();
    }

    public void resetPassedChecks() {
        this.passedChecks.clear();
    }

    public void resetConsumedChecks() {
        this.consumedChecks.clear();
    }

    public boolean matchesLastBlock(Material material, Action action, int tick, Block block) {
        return this.lastX != Integer.MAX_VALUE && (material == this.lastType || material == null && this.lastType == Material.AIR) && this.matchesLastBlock(action, tick, block);
    }

    public boolean matchesLastBlock(Action action, int tick, Block block) {
        return this.lastX != Integer.MAX_VALUE && tick == this.lastTick && this.matchesLastBlock(action, block);
    }

    public boolean matchesLastBlock(Action action, Block block) {
        return this.lastX != Integer.MAX_VALUE && action == this.lastAction && this.matchesLastBlock(block);
    }

    public boolean matchesLastBlock(int tick, Block block) {
        return this.lastX != Integer.MAX_VALUE && tick == this.lastTick && this.matchesLastBlock(block);
    }

    public boolean matchesLastBlock(Block block) {
        return this.lastX == block.getX() && this.lastY == block.getY() && this.lastZ == block.getZ();
    }

    public int manhattanLastBlock(Block block) {
        return this.lastX == Integer.MAX_VALUE ? Integer.MAX_VALUE : TrigUtil.manhattan(this.lastX, this.lastY, this.lastZ, block.getX(), block.getY(), block.getZ());
    }

    public boolean getLastAllowUseItem() {
        return this.lastAllowUseItem;
    }

    public boolean getLastAllowUseBlock() {
        return this.lastAllowUseBlock;
    }

    public boolean getLastIsCancelled() {
        return this.lastIsCancelled;
    }

    public Material getLastType() {
        return this.lastType;
    }

    public int getLastTick() {
        return this.lastTick;
    }

    public Action getLastAction() {
        return this.lastAction;
    }

    public void addPassedCheck(CheckType checkType) {
        this.passedChecks.add(checkType);
    }

    public boolean isPassedCheck(CheckType checkType) {
        return this.passedChecks.contains((Object)checkType);
    }

    public Collection<CheckType> getPassedChecks() {
        return Collections.unmodifiableCollection(this.passedChecks);
    }

    public boolean isConsumedCheck(CheckType checkType) {
        return this.consumedChecks.contains((Object)checkType);
    }

    public void addConsumedCheck(CheckType checkType) {
        this.consumedChecks.add(checkType);
    }

    public void setPlayerInteractEventResolution(PlayerInteractEvent event) {
        if (event.isCancelled()) {
            this.lastIsCancelled = true;
            this.lastAllowUseItem = event.useItemInHand() == Event.Result.ALLOW;
            this.lastAllowUseBlock = event.useInteractedBlock() == Event.Result.ALLOW;
            ++this.subsequentCancel;
        } else {
            this.lastIsCancelled = false;
            this.lastAllowUseItem = event.useItemInHand() != Event.Result.DENY;
            this.lastAllowUseBlock = event.useInteractedBlock() != Event.Result.DENY;
            this.subsequentCancel = 0;
        }
    }

    public void setLastIsCancelled(boolean isCancelled) {
        this.lastIsCancelled = isCancelled;
    }

    public void setLastAllowUseItem(boolean allowUseItem) {
        this.lastAllowUseItem = allowUseItem;
    }

    public void setLastAllowUseBlock(boolean allowUseBlock) {
        this.lastAllowUseBlock = allowUseBlock;
    }
}

