/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.actions;

import fr.neatmonster.nocheatplus.NCPAPIProvider;
import fr.neatmonster.nocheatplus.actions.AbstractActionList;
import fr.neatmonster.nocheatplus.actions.Action;
import fr.neatmonster.nocheatplus.actions.ActionData;
import fr.neatmonster.nocheatplus.actions.ParameterHolder;
import fr.neatmonster.nocheatplus.actions.types.CommandAction;
import fr.neatmonster.nocheatplus.actions.types.CommandActionWithColor;
import fr.neatmonster.nocheatplus.actions.types.DummyAction;
import fr.neatmonster.nocheatplus.logging.StaticLog;
import fr.neatmonster.nocheatplus.permissions.RegisteredPermission;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractActionFactory<D extends ActionData, L extends AbstractActionList<D, L>> {
    protected static final Map<String, Object> lib = new HashMap<String, Object>();
    protected final AbstractActionList.ActionListFactory<D, L> listFactory;

    public AbstractActionFactory(Map<String, Object> library, AbstractActionList.ActionListFactory<D, L> listFactory) {
        this.listFactory = listFactory;
        lib.putAll(library);
    }

    public abstract Action<D, L> createAction(String var1);

    public L createActionList(String definition, RegisteredPermission permission) {
        RegisteredPermission permissionSilent = permission == null ? null : NCPAPIProvider.getNoCheatPlusAPI().getPermissionRegistry().getOrRegisterPermission(permission.getStringRepresentation() + ".silent");
        L list = this.listFactory.getNewActionList(permissionSilent);
        if (definition == null) {
            return list;
        }
        boolean first = true;
        for (String s : definition.split("vl>")) {
            if ((s = s.trim()).length() == 0) {
                first = false;
                continue;
            }
            try {
                String def;
                Integer vl;
                if (first) {
                    first = false;
                    vl = 0;
                    def = s;
                } else {
                    String[] listEntry = s.split("\\s+", 2);
                    vl = Integer.parseInt(listEntry[0]);
                    def = listEntry[1];
                }
                ((AbstractActionList)list).setActions(vl, this.createActions(def.split("\\s+")));
            }
            catch (Exception e) {
                StaticLog.logWarning("Couldn't parse action definition 'vl:" + s + "'.");
            }
        }
        return list;
    }

    public Action<D, L>[] createActions(String ... definitions) {
        ArrayList<Action<D, L>> actions = new ArrayList<Action<D, L>>();
        for (String def : definitions) {
            if (def.length() == 0) continue;
            try {
                actions.add(this.createAction(def));
            }
            catch (IllegalArgumentException e) {
                StaticLog.logWarning("Failed to create action: " + e.getMessage());
                actions.add(new DummyAction(def));
            }
        }
        return actions.toArray(new Action[actions.size()]);
    }

    protected <PH extends ParameterHolder, LPH extends AbstractActionList<PH, LPH>> Action<PH, LPH> parseCmdAction(String definition) {
        return this.parseCmdAction(definition, false);
    }

    protected <PH extends ParameterHolder, LPH extends AbstractActionList<PH, LPH>> Action<PH, LPH> parseCmdAction(String definition, boolean replaceColor) {
        String[] parts = definition.split(":");
        String name = parts[0];
        Object command = lib.get(parts[0]);
        int delay = 0;
        int repeat = 0;
        if (command == null) {
            throw new IllegalArgumentException("NoCheatPlus doesn't know command '" + name + "'. Have you forgotten to define it?");
        }
        if (parts.length > 1) {
            try {
                delay = Integer.parseInt(parts[1]);
                repeat = Integer.parseInt(parts[2]);
            }
            catch (Exception e) {
                StaticLog.logWarning("Couldn't parse details of command '" + definition + "', will use default values instead.");
                delay = 0;
                repeat = 0;
            }
        }
        return replaceColor ? new CommandActionWithColor(name, delay, repeat, command.toString()) : new CommandAction(name, delay, repeat, command.toString());
    }
}

