/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus;

import fr.neatmonster.nocheatplus.NCPAPIProvider;
import fr.neatmonster.nocheatplus.actions.ActionFactory;
import fr.neatmonster.nocheatplus.actions.ActionFactoryFactory;
import fr.neatmonster.nocheatplus.checks.blockbreak.BlockBreakListener;
import fr.neatmonster.nocheatplus.checks.blockinteract.BlockInteractListener;
import fr.neatmonster.nocheatplus.checks.blockplace.BlockPlaceListener;
import fr.neatmonster.nocheatplus.checks.chat.ChatConfig;
import fr.neatmonster.nocheatplus.checks.chat.ChatListener;
import fr.neatmonster.nocheatplus.checks.combined.CombinedData;
import fr.neatmonster.nocheatplus.checks.combined.CombinedListener;
import fr.neatmonster.nocheatplus.checks.fight.FightListener;
import fr.neatmonster.nocheatplus.checks.inventory.InventoryListener;
import fr.neatmonster.nocheatplus.checks.moving.MovingListener;
import fr.neatmonster.nocheatplus.checks.moving.location.tracking.LocationTrace;
import fr.neatmonster.nocheatplus.checks.moving.util.AuxMoving;
import fr.neatmonster.nocheatplus.checks.net.NetConfig;
import fr.neatmonster.nocheatplus.checks.net.NetStatic;
import fr.neatmonster.nocheatplus.checks.workaround.WRPT;
import fr.neatmonster.nocheatplus.clients.ModUtil;
import fr.neatmonster.nocheatplus.command.NoCheatPlusCommand;
import fr.neatmonster.nocheatplus.command.admin.VersionCommand;
import fr.neatmonster.nocheatplus.compat.BridgeMisc;
import fr.neatmonster.nocheatplus.compat.MCAccess;
import fr.neatmonster.nocheatplus.compat.blocks.changetracker.BlockChangeListener;
import fr.neatmonster.nocheatplus.compat.blocks.changetracker.BlockChangeTracker;
import fr.neatmonster.nocheatplus.compat.meta.BridgeCrossPlugin;
import fr.neatmonster.nocheatplus.compat.registry.AttributeAccessFactory;
import fr.neatmonster.nocheatplus.compat.registry.DefaultComponentFactory;
import fr.neatmonster.nocheatplus.compat.registry.EntityAccessFactory;
import fr.neatmonster.nocheatplus.compat.registry.MCAccessConfig;
import fr.neatmonster.nocheatplus.compat.registry.MCAccessFactory;
import fr.neatmonster.nocheatplus.compat.versions.Bugs;
import fr.neatmonster.nocheatplus.compat.versions.BukkitVersion;
import fr.neatmonster.nocheatplus.compat.versions.ServerVersion;
import fr.neatmonster.nocheatplus.components.NoCheatPlusAPI;
import fr.neatmonster.nocheatplus.components.registry.ComponentRegistry;
import fr.neatmonster.nocheatplus.components.registry.DefaultGenericInstanceRegistry;
import fr.neatmonster.nocheatplus.components.registry.event.IGenericInstanceHandle;
import fr.neatmonster.nocheatplus.components.registry.feature.ConsistencyChecker;
import fr.neatmonster.nocheatplus.components.registry.feature.IDisableListener;
import fr.neatmonster.nocheatplus.components.registry.feature.IHoldSubComponents;
import fr.neatmonster.nocheatplus.components.registry.feature.INeedConfig;
import fr.neatmonster.nocheatplus.components.registry.feature.INotifyReload;
import fr.neatmonster.nocheatplus.components.registry.feature.IPostRegisterRunnable;
import fr.neatmonster.nocheatplus.components.registry.feature.IRegisterAsGenericInstance;
import fr.neatmonster.nocheatplus.components.registry.feature.JoinLeaveListener;
import fr.neatmonster.nocheatplus.components.registry.feature.NCPListener;
import fr.neatmonster.nocheatplus.components.registry.feature.TickListener;
import fr.neatmonster.nocheatplus.components.registry.lockable.BasicLockable;
import fr.neatmonster.nocheatplus.components.registry.lockable.ILockable;
import fr.neatmonster.nocheatplus.components.registry.order.SetupOrder;
import fr.neatmonster.nocheatplus.components.registry.setup.RegistrationContext;
import fr.neatmonster.nocheatplus.config.ConfigFile;
import fr.neatmonster.nocheatplus.config.ConfigManager;
import fr.neatmonster.nocheatplus.event.mini.EventRegistryBukkit;
import fr.neatmonster.nocheatplus.event.mini.MiniListener;
import fr.neatmonster.nocheatplus.hooks.ExemptionSettings;
import fr.neatmonster.nocheatplus.hooks.NCPExemptionManager;
import fr.neatmonster.nocheatplus.hooks.NCPHookManager;
import fr.neatmonster.nocheatplus.hooks.allviolations.AllViolationsConfig;
import fr.neatmonster.nocheatplus.hooks.allviolations.AllViolationsHook;
import fr.neatmonster.nocheatplus.logging.BukkitLogManager;
import fr.neatmonster.nocheatplus.logging.LogManager;
import fr.neatmonster.nocheatplus.logging.StaticLog;
import fr.neatmonster.nocheatplus.logging.StreamID;
import fr.neatmonster.nocheatplus.logging.Streams;
import fr.neatmonster.nocheatplus.logging.details.IGetStreamId;
import fr.neatmonster.nocheatplus.permissions.PermissionRegistry;
import fr.neatmonster.nocheatplus.permissions.PermissionUtil;
import fr.neatmonster.nocheatplus.permissions.Permissions;
import fr.neatmonster.nocheatplus.permissions.RegisteredPermission;
import fr.neatmonster.nocheatplus.players.DataManager;
import fr.neatmonster.nocheatplus.players.IPlayerData;
import fr.neatmonster.nocheatplus.players.IPlayerDataManager;
import fr.neatmonster.nocheatplus.players.PlayerDataManager;
import fr.neatmonster.nocheatplus.players.PlayerMessageSender;
import fr.neatmonster.nocheatplus.stats.Counters;
import fr.neatmonster.nocheatplus.utilities.ColorUtil;
import fr.neatmonster.nocheatplus.utilities.Misc;
import fr.neatmonster.nocheatplus.utilities.OnDemandTickListener;
import fr.neatmonster.nocheatplus.utilities.ReflectionUtil;
import fr.neatmonster.nocheatplus.utilities.StringUtil;
import fr.neatmonster.nocheatplus.utilities.TickTask;
import fr.neatmonster.nocheatplus.utilities.entity.PassengerUtil;
import fr.neatmonster.nocheatplus.utilities.map.BlockCache;
import fr.neatmonster.nocheatplus.utilities.map.BlockProperties;
import fr.neatmonster.nocheatplus.worlds.IWorldData;
import fr.neatmonster.nocheatplus.worlds.IWorldDataManager;
import fr.neatmonster.nocheatplus.worlds.WorldDataManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.World;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerKickEvent;
import org.bukkit.event.player.PlayerLoginEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.world.WorldLoadEvent;
import org.bukkit.permissions.Permissible;
import org.bukkit.permissions.Permission;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitScheduler;

public class NoCheatPlus
extends JavaPlugin
implements NoCheatPlusAPI {
    private static final Object lockableAPIsecret = new Object();
    private static final ILockable lockableAPI = new BasicLockable(lockableAPIsecret, true, true, true);
    private static final String MSG_NOTIFY_OFF = ChatColor.RED + "NCP: " + ChatColor.WHITE + "Notifications are turned " + ChatColor.RED + "OFF" + ChatColor.WHITE + ".";
    private BukkitLogManager logManager = null;
    private final Map<String, Long> denyLoginNames = Collections.synchronizedMap(new HashMap());
    private String configProblemsChat = null;
    private String configProblemsFile = null;
    private final PermissionRegistry permissionRegistry = new PermissionRegistry(10000);
    private final WorldDataManager worldDataManager = new WorldDataManager();
    private final PlayerDataManager pDataMan = new PlayerDataManager(this.worldDataManager, this.permissionRegistry);
    private int dataManTaskId = -1;
    final LinkedList<PermissionUtil.CommandProtectionEntry> changedCommands = new LinkedList();
    private final EventRegistryBukkit eventRegistry = new EventRegistryBukkit((Plugin)this);
    private final List<Object> listeners = new ArrayList<Object>();
    private final List<INotifyReload> notifyReload = new LinkedList<INotifyReload>();
    private final List<ConsistencyChecker> consistencyCheckers = new ArrayList<ConsistencyChecker>();
    private int consistencyCheckerIndex = 0;
    private int consistencyCheckerTaskId = -1;
    private final List<JoinLeaveListener> joinLeaveListeners = new ArrayList<JoinLeaveListener>();
    private final List<ComponentRegistry<?>> subRegistries = new ArrayList();
    private final List<IHoldSubComponents> subComponentholders = new ArrayList<IHoldSubComponents>(20);
    private final List<IDisableListener> disableListeners = new ArrayList<IDisableListener>();
    private Set<Object> allComponents = new LinkedHashSet<Object>(50);
    private final LinkedHashMap<String, LinkedHashSet<String>> featureTags = new LinkedHashMap();
    private final AllViolationsHook allViolationsHook = new AllViolationsHook();
    private final BlockChangeTracker blockChangeTracker = new BlockChangeTracker();
    private BlockChangeListener blockChangeListener = null;
    private final DefaultGenericInstanceRegistry genericInstanceRegistry = new DefaultGenericInstanceRegistry();
    private final IGenericInstanceHandle<MCAccess> mcAccess = this.genericInstanceRegistry.getGenericInstanceHandle(MCAccess.class);
    private final OnDemandTickListener onDemandTickListener = new OnDemandTickListener(){

        @Override
        public boolean delegateTick(int tick, long timeLast) {
            NoCheatPlus.this.processQueuedSubComponentHolders();
            return false;
        }
    };
    private INotifyReload reloadHook = new ReloadHook();
    private final PlayerMessageSender playerMessageSender = new PlayerMessageSender();
    private boolean clearExemptionsOnJoin = true;
    private boolean clearExemptionsOnLeave = true;

    public static NoCheatPlusAPI getAPI() {
        return NCPAPIProvider.getNoCheatPlusAPI();
    }

    private StreamID getRegistryStreamId() {
        return ConfigManager.getConfigFile().getBoolean("logging.extended.status") ? Streams.STATUS : Streams.DEFAULT_FILE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkDenyLoginsNames(String playerName) {
        long ts = System.currentTimeMillis();
        LinkedList<String> rem = new LinkedList<String>();
        boolean res = false;
        Map<String, Long> map = this.denyLoginNames;
        synchronized (map) {
            for (Map.Entry<String, Long> entry : this.denyLoginNames.entrySet()) {
                if (entry.getValue() >= ts) continue;
                rem.add(entry.getKey());
            }
            for (String name : rem) {
                this.denyLoginNames.remove(name);
            }
            if (playerName != null) {
                res = this.isLoginDenied(playerName);
            }
        }
        return res;
    }

    @Override
    public boolean allowLogin(String playerName) {
        Long time = this.denyLoginNames.remove(playerName = playerName.trim().toLowerCase());
        if (time == null) {
            return false;
        }
        return System.currentTimeMillis() <= time;
    }

    @Override
    public int allowLoginAll() {
        int denied = 0;
        long now = System.currentTimeMillis();
        for (String playerName : this.denyLoginNames.keySet()) {
            Long time = this.denyLoginNames.get(playerName);
            if (time == null || time <= now) continue;
            ++denied;
        }
        this.denyLoginNames.clear();
        return denied;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void denyLogin(String playerName, long duration) {
        long ts = System.currentTimeMillis() + duration;
        playerName = playerName.trim().toLowerCase();
        Map<String, Long> map = this.denyLoginNames;
        synchronized (map) {
            Long oldTs = this.denyLoginNames.get(playerName);
            if (oldTs != null && ts < oldTs) {
                return;
            }
            this.denyLoginNames.put(playerName, ts);
        }
        this.checkDenyLoginsNames(null);
    }

    @Override
    public boolean isLoginDenied(String playerName) {
        return this.isLoginDenied(playerName, System.currentTimeMillis());
    }

    @Override
    public String[] getLoginDeniedPlayers() {
        this.checkDenyLoginsNames(null);
        String[] kicked = new String[this.denyLoginNames.size()];
        this.denyLoginNames.keySet().toArray(kicked);
        return kicked;
    }

    @Override
    public boolean isLoginDenied(String playerName, long time) {
        Long oldTs = this.denyLoginNames.get(playerName = playerName.trim().toLowerCase());
        if (oldTs == null) {
            return false;
        }
        return time < oldTs;
    }

    @Override
    public int sendAdminNotifyMessage(String message) {
        return this.sendAdminNotifyMessageSubscriptions(message);
    }

    public int sendAdminNotifyMessageSubscriptions(String message) {
        String lcPerm = Permissions.NOTIFY.getLowerCaseStringRepresentation();
        Permission bukkitPerm = Permissions.NOTIFY.getBukkitPermission();
        Set permissibles = Bukkit.getPluginManager().getPermissionSubscriptions(lcPerm);
        HashSet<String> done = new HashSet<String>(permissibles.size());
        for (Permissible permissible : permissibles) {
            Player player;
            IPlayerData data;
            CommandSender sender;
            if (!(permissible instanceof CommandSender) || ((sender = (CommandSender)permissible) instanceof Player ? (data = DataManager.getPlayerData(player = (Player)sender)).getNotifyOff() || !data.hasPermission(Permissions.NOTIFY, player) : !sender.hasPermission(bukkitPerm))) continue;
            sender.sendMessage(message);
            done.add(sender.getName());
        }
        return done.size();
    }

    @Override
    public void sendMessageOnTick(String playerName, String message) {
        this.playerMessageSender.sendMessageThreadSafe(playerName, message);
    }

    @Override
    public <T> Collection<ComponentRegistry<T>> getComponentRegistries(Class<ComponentRegistry<T>> clazz) {
        LinkedList<ComponentRegistry<T>> result = new LinkedList<ComponentRegistry<T>>();
        for (ComponentRegistry<?> registry : this.subRegistries) {
            if (!clazz.isAssignableFrom(registry.getClass())) continue;
            try {
                result.add(registry);
            }
            catch (Throwable throwable) {}
        }
        return result;
    }

    @Override
    public boolean addComponent(Object obj) {
        return this.addComponent(obj, true);
    }

    @Override
    public boolean addComponent(Object obj, boolean allowComponentRegistry) {
        if (obj == this) {
            throw new IllegalArgumentException("Can not register NoCheatPlus with itself.");
        }
        if (this.allComponents.contains(obj)) {
            return false;
        }
        boolean added = false;
        if (obj instanceof IRegisterAsGenericInstance) {
            this.registerGenericInstance(obj);
        }
        if (obj instanceof Listener) {
            this.addListener((Listener)obj);
            added = true;
        }
        if (obj instanceof MiniListener) {
            this.addMiniListener((MiniListener)obj);
            added = true;
        }
        if (obj instanceof INotifyReload) {
            this.notifyReload.add((INotifyReload)obj);
            if (obj instanceof INeedConfig) {
                ((INeedConfig)obj).onReload();
            }
            added = true;
        }
        if (obj instanceof TickListener) {
            TickTask.addTickListener((TickListener)obj);
            added = true;
        }
        if (obj instanceof ConsistencyChecker) {
            this.consistencyCheckers.add((ConsistencyChecker)obj);
            added = true;
        }
        if (obj instanceof JoinLeaveListener) {
            this.joinLeaveListeners.add((JoinLeaveListener)obj);
            added = true;
        }
        if (obj instanceof IDisableListener) {
            this.disableListeners.add((IDisableListener)obj);
            added = true;
        }
        for (ComponentRegistry<?> registry : this.subRegistries) {
            Object res = ReflectionUtil.invokeGenericMethodOneArg(registry, "addComponent", obj);
            if (res == null || !(res instanceof Boolean) || !((Boolean)res).booleanValue()) continue;
            added = true;
        }
        if (allowComponentRegistry && obj instanceof ComponentRegistry) {
            this.subRegistries.add((ComponentRegistry)obj);
            added = true;
        }
        if (obj instanceof IHoldSubComponents) {
            this.subComponentholders.add((IHoldSubComponents)obj);
            this.onDemandTickListener.register();
            added = true;
        }
        if (added) {
            this.allComponents.add(obj);
        }
        if (obj instanceof IPostRegisterRunnable) {
            ((IPostRegisterRunnable)obj).runPostRegister();
        }
        return added;
    }

    private void addListener(Listener listener) {
        this.eventRegistry.register(listener);
        this.listeners.add(listener);
    }

    private <E extends Event> void addMiniListener(MiniListener<E> listener) {
        this.eventRegistry.register(listener);
        this.listeners.add(listener);
    }

    @Override
    public void removeComponent(Object obj) {
        if (obj instanceof Listener) {
            this.listeners.remove(obj);
            this.eventRegistry.unregisterAttached(obj);
        } else if (obj instanceof MiniListener) {
            this.listeners.remove(obj);
            this.eventRegistry.unregisterAttached(obj);
        }
        if (obj instanceof TickListener) {
            TickTask.removeTickListener((TickListener)obj);
        }
        if (obj instanceof INotifyReload) {
            this.notifyReload.remove((INotifyReload)obj);
        }
        if (obj instanceof ConsistencyChecker) {
            this.consistencyCheckers.remove((ConsistencyChecker)obj);
        }
        if (obj instanceof JoinLeaveListener) {
            this.joinLeaveListeners.remove((JoinLeaveListener)obj);
        }
        if (obj instanceof IDisableListener) {
            this.disableListeners.remove((IDisableListener)obj);
        }
        if (obj instanceof ComponentRegistry) {
            this.subRegistries.remove((ComponentRegistry)obj);
        }
        for (ComponentRegistry<?> registry : this.subRegistries) {
            ReflectionUtil.invokeGenericMethodOneArg(registry, "removeComponent", obj);
        }
        this.allComponents.remove(obj);
    }

    public void onDisable() {
        boolean verbose = ConfigManager.getConfigFile().getBoolean("logging.extended.status");
        if (verbose) {
            this.logManager.info(Streams.INIT, "Cleanup event registry (Bukkit)...");
        }
        this.eventRegistry.clear();
        BukkitScheduler sched = this.getServer().getScheduler();
        if (this.dataManTaskId != -1) {
            sched.cancelTask(this.dataManTaskId);
            this.dataManTaskId = -1;
        }
        if (verbose) {
            this.logManager.info(Streams.INIT, "Stop TickTask...");
        }
        TickTask.setLocked(true);
        TickTask.purge();
        TickTask.cancel();
        TickTask.removeAllTickListeners();
        if (this.consistencyCheckerTaskId != -1) {
            sched.cancelTask(this.consistencyCheckerTaskId);
            this.consistencyCheckerTaskId = -1;
        }
        if (verbose) {
            this.logManager.info(Streams.INIT, "Stop all remaining tasks...");
        }
        sched.cancelTasks((Plugin)this);
        if (verbose) {
            this.logManager.info(Streams.INIT, "onDisable calls (include DataManager cleanup)...");
        }
        ArrayList<IDisableListener> disableListeners = new ArrayList<IDisableListener>(this.disableListeners);
        Collections.reverse(disableListeners);
        for (IDisableListener dl : disableListeners) {
            try {
                dl.onDisable();
            }
            catch (Throwable t) {
                this.logManager.severe(Streams.INIT, "IDisableListener (" + dl.getClass().getName() + "): " + t.getClass().getSimpleName() + " / " + t.getMessage());
                this.logManager.severe(Streams.INIT, t);
            }
        }
        if (verbose) {
            this.logManager.info(Streams.INIT, "Reset ExemptionManager...");
        }
        NCPExemptionManager.clear();
        this.allViolationsHook.unregister();
        NCPHookManager.removeAllHooks();
        Counters counters = this.getGenericInstance(Counters.class);
        if (counters != null) {
            if (verbose) {
                this.logManager.info(Streams.INIT, counters.getMergedCountsString(true));
            } else {
                this.logManager.debug(Streams.TRACE_FILE, counters.getMergedCountsString(true));
            }
        }
        if (verbose) {
            this.logManager.info(Streams.INIT, "Unregister all registered components...");
        }
        ArrayList<Object> components = new ArrayList<Object>(this.allComponents);
        for (int i = components.size() - 1; i >= 0; --i) {
            this.removeComponent(components.get(i));
        }
        if (verbose) {
            this.logManager.info(Streams.INIT, "Cleanup BlockProperties...");
        }
        BlockProperties.cleanup();
        if (verbose) {
            this.logManager.info(Streams.INIT, "Cleanup some mappings...");
        }
        disableListeners.clear();
        this.listeners.clear();
        this.notifyReload.clear();
        this.subRegistries.clear();
        this.subComponentholders.clear();
        this.genericInstanceRegistry.clear();
        this.featureTags.clear();
        if (this.blockChangeListener != null) {
            this.blockChangeListener.setEnabled(false);
            this.blockChangeListener = null;
        }
        this.blockChangeTracker.clear();
        this.changedCommands.clear();
        if (verbose) {
            this.logManager.info(Streams.INIT, "Cleanup ConfigManager...");
        }
        ConfigManager.cleanup();
        if (verbose) {
            this.logManager.info(Streams.INIT, "Shutdown LogManager...");
        }
        StaticLog.setUseLogManager(false);
        StaticLog.setStreamID(Streams.INIT);
        this.logManager.shutdown();
        if (verbose) {
            Bukkit.getLogger().info("[NoCheatPlus] All cleanup done.");
        }
        PluginDescriptionFile pdfFile = this.getDescription();
        Bukkit.getLogger().info("[NoCheatPlus] Version " + pdfFile.getVersion() + " is disabled.");
    }

    public void undoCommandChanges() {
        if (!this.changedCommands.isEmpty()) {
            Iterator<PermissionUtil.CommandProtectionEntry> it = this.changedCommands.descendingIterator();
            while (it.hasNext()) {
                it.next().restore();
            }
            this.changedCommands.clear();
        }
    }

    private void setupCommandProtection() {
        List noCommand;
        ConfigFile config = ConfigManager.getConfigFile();
        List noPerm = config.getStringList("protection.plugins.hide.nopermission.commands");
        if (noPerm != null && !noPerm.isEmpty()) {
            String noPermMsg = ColorUtil.replaceColors(ConfigManager.getConfigFile().getString("protection.plugins.hide.nopermission.message"));
            this.changedCommands.addAll(PermissionUtil.protectCommands(Permissions.FILTER_COMMAND.getLowerCaseStringRepresentation(), noPerm, true, false, noPermMsg));
        }
        if ((noCommand = config.getStringList("protection.plugins.hide.unknowncommand.commands")) != null && !noCommand.isEmpty()) {
            String noCommandMsg = ColorUtil.replaceColors(ConfigManager.getConfigFile().getString("protection.plugins.hide.unknowncommand.message"));
            this.changedCommands.addAll(PermissionUtil.protectCommands(Permissions.FILTER_COMMAND.getLowerCaseStringRepresentation(), noCommand, true, false, noCommandMsg));
        }
    }

    public void onLoad() {
        Bukkit.getLogger().info("[NoCheatPlus] onLoad: Early set up of static API, configuration, logging.");
        this.setupBasics();
    }

    private void setupBasics() {
        for (RegisteredPermission rp : Permissions.getPermissions()) {
            if (this.permissionRegistry.getPermissionInfo(rp.getId()) != null) continue;
            this.permissionRegistry.addRegisteredPermission(rp);
        }
        this.updateNoCheatPlusAPI();
        if (ServerVersion.getMinecraftVersion() == "unknown") {
            BukkitVersion.init();
        }
        if (this.getGenericInstance(ActionFactoryFactory.class) == null) {
            this.setActionFactoryFactory(null);
        }
        if (!ConfigManager.isInitialized()) {
            ConfigManager.init((Plugin)this, this.worldDataManager);
            NCPExemptionManager.setExemptionSettings(new ExemptionSettings(ConfigManager.getConfigFile()));
        }
        if (this.logManager == null || this.logManager.getStreamID(Streams.STATUS.name) != Streams.STATUS) {
            this.logManager = new BukkitLogManager((Plugin)this);
            StaticLog.setStreamID(Streams.INIT);
            StaticLog.setUseLogManager(true);
            this.logManager.info(Streams.INIT, "Logging system initialized.");
            this.logManager.info(Streams.INIT, "Detected Minecraft version: " + ServerVersion.getMinecraftVersion());
            this.genericInstanceRegistry.setLogger(this.logManager, new IGetStreamId(){

                @Override
                public StreamID getStreamId() {
                    return NoCheatPlus.this.getRegistryStreamId();
                }
            }, "[GenericInstanceRegistry] ");
        }
    }

    private void updateNoCheatPlusAPI() {
        if (NCPAPIProvider.getNoCheatPlusAPI() == null) {
            lockableAPI.unlock(lockableAPIsecret);
            NCPAPIProvider.setNoCheatPlusAPI(this, lockableAPI);
            lockableAPI.lock(lockableAPIsecret);
        }
    }

    public void onEnable() {
        TickTask.setLocked(true);
        TickTask.purge();
        TickTask.cancel();
        TickTask.reset();
        TickTask.setLocked(false);
        this.setupBasics();
        if (Bugs.shouldEnforceLocation()) {
            this.addFeatureTags("defaults", Arrays.asList("enforceLocation"));
        }
        if (Bugs.shouldPvpKnockBackVelocity()) {
            this.addFeatureTags("defaults", Arrays.asList("pvpKnockBackVelocity"));
        }
        if (this.pDataMan.storesPlayerInstances()) {
            this.addFeatureTags("defaults", Arrays.asList("storePlayers"));
        }
        this.logManager.startTasks();
        ConfigFile config = ConfigManager.getConfigFile();
        this.setInstanceMembers(config);
        this.registerGenericInstance(new Counters());
        this.genericInstanceRegistry.denyChangeExistingRegistration(Counters.class);
        this.registerGenericInstance(new WRPT());
        this.genericInstanceRegistry.denyChangeExistingRegistration(WRPT.class);
        this.registerGenericInstance(new LocationTrace.TraceEntryPool(1000));
        this.genericInstanceRegistry.denyChangeExistingRegistration(LocationTrace.TraceEntryPool.class);
        this.registerGenericInstance(new PassengerUtil());
        this.genericInstanceRegistry.denyChangeExistingRegistration(PassengerUtil.class);
        this.registerGenericInstance(new Random(System.currentTimeMillis() ^ (long)this.hashCode() * (long)this.eventRegistry.hashCode() * (long)this.logManager.hashCode()));
        this.addComponent(new BridgeCrossPlugin());
        for (World world : Bukkit.getWorlds()) {
            this.onWorldPresent(world);
        }
        this.initMCAccess(config);
        this.initBlockProperties(config);
        this.worldDataManager.onEnable();
        this.pDataMan.onEnable();
        for (Object obj : new Object[]{this.getCoreListener(), this.reloadHook, this.pDataMan, new AuxMoving()}) {
            this.addComponent(obj);
            this.processQueuedSubComponentHolders();
        }
        this.updateBlockChangeTracker(config);
        for (Object obj : new Object[]{new BlockInteractListener(), new BlockBreakListener(), new BlockPlaceListener(), new ChatListener(), new CombinedListener(), new FightListener(), new InventoryListener(), new MovingListener()}) {
            this.addComponent(obj);
            this.processQueuedSubComponentHolders();
        }
        NetStatic.registerTypes();
        DefaultComponentFactory dcf = new DefaultComponentFactory();
        for (Object obj : dcf.getAvailableComponentsOnEnable(this)) {
            this.addComponent(obj);
            this.processQueuedSubComponentHolders();
        }
        PluginCommand command = this.getCommand("nocheatplus");
        NoCheatPlusCommand commandHandler = new NoCheatPlusCommand(this, this.notifyReload);
        command.setExecutor((CommandExecutor)commandHandler);
        this.permissionRegistry.preferKeepUpdated(NetConfig.getPreferKeepUpdatedPermissions());
        this.permissionRegistry.preferKeepUpdated(ChatConfig.getPreferKeepUpdatedPermissions());
        this.permissionRegistry.arrangePreferKeepUpdated();
        TickTask.start((Plugin)this);
        this.dataManTaskId = Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)this, new Runnable(){

            @Override
            public void run() {
                NoCheatPlus.this.pDataMan.checkExpiration();
            }
        }, 1207L, 1207L);
        Misc.putFirst(this.pDataMan, this.disableListeners);
        Misc.putFirst(this.pDataMan, this.notifyReload);
        Misc.putFirst(this.worldDataManager, this.notifyReload);
        Misc.putFirst(this.reloadHook, this.notifyReload);
        this.scheduleConsistencyCheckers();
        this.allViolationsHook.setConfig(new AllViolationsConfig(config));
        this.logOtherNotes(config);
        if (this.configProblemsFile != null && config.getBoolean("configversion.notify")) {
            this.logManager.warning(Streams.INIT, "" + this.configProblemsFile);
        }
        Player[] onlinePlayers = BridgeMisc.getOnlinePlayers();
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this, (Runnable)new PostEnableTask(onlinePlayers));
        Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)this, new Runnable(){

            @Override
            public void run() {
                NoCheatPlus.this.midTermCleanup();
            }
        }, 83L, 83L);
        StaticLog.setStreamID(Streams.STATUS);
        this.logManager.info(Streams.INIT, "Version " + this.getDescription().getVersion() + " is enabled.");
    }

    private void logOtherNotes(ConfigFile config) {
        if (ServerVersion.compareMinecraftVersion("1.9") >= 0) {
            this.logManager.info(Streams.INIT, "Force disable FastHeal on Minecraft 1.9 and later.");
        }
    }

    private void postEnable(Player[] onlinePlayers) {
        this.logManager.info(Streams.INIT, "Post-enable running...");
        this.permissionRegistry.arrangePreferKeepUpdated();
        ConfigFile config = ConfigManager.getConfigFile();
        try {
            if (config.getBoolean("protection.plugins.hide.active")) {
                this.setupCommandProtection();
            }
        }
        catch (Throwable t) {
            this.logManager.severe(Streams.INIT, "Failed to apply command protection: " + t.getClass().getSimpleName());
            this.logManager.severe(Streams.INIT, t);
        }
        for (Player player : onlinePlayers) {
            IPlayerData pData = DataManager.getPlayerData(player);
            if (!player.isSleeping()) continue;
            pData.getGenericInstance(CombinedData.class).wasInBed = true;
        }
        if (onlinePlayers.length > 0) {
            this.logManager.info(Streams.INIT, "Updated data for " + onlinePlayers.length + " players (post-enable).");
        }
        this.logManager.info(Streams.INIT, "Post-enable finished.");
        this.logManager.info(Streams.DEFAULT_FILE, StringUtil.join(VersionCommand.getVersionInfo(), "\n"));
    }

    private void processQueuedSubComponentHolders() {
        if (this.subComponentholders.isEmpty()) {
            return;
        }
        ArrayList<IHoldSubComponents> copied = new ArrayList<IHoldSubComponents>(this.subComponentholders);
        this.subComponentholders.clear();
        for (IHoldSubComponents holder : copied) {
            for (Object component : holder.getSubComponents()) {
                this.addComponent(component);
            }
        }
    }

    private void processReload() {
        ConfigFile config = ConfigManager.getConfigFile();
        this.setInstanceMembers(config);
        this.initMCAccess(config);
        this.initBlockProperties(config);
        this.undoCommandChanges();
        if (config.getBoolean("protection.plugins.hide.active")) {
            this.setupCommandProtection();
        }
        this.scheduleConsistencyCheckers();
        this.allViolationsHook.setConfig(new AllViolationsConfig(config));
        this.updateBlockChangeTracker(config);
    }

    private void setInstanceMembers(ConfigFile config) {
        this.configProblemsChat = ConfigManager.isConfigUpToDate(config, config.getInt("configversion.notifymaxpaths"));
        this.configProblemsFile = this.configProblemsChat == null ? null : ConfigManager.isConfigUpToDate(config, -1);
        this.clearExemptionsOnJoin = config.getBoolean("compatibility.exemptions.remove.join");
        this.clearExemptionsOnLeave = config.getBoolean("compatibility.exemptions.remove.leave");
        NCPExemptionManager.setExemptionSettings(new ExemptionSettings(config));
    }

    private void updateBlockChangeTracker(ConfigFile config) {
        if (config.getBoolean("compatibility.blocks.changetracker.active") && config.getBoolean("compatibility.blocks.changetracker.pistons")) {
            if (this.blockChangeListener == null) {
                this.blockChangeListener = new BlockChangeListener(this.blockChangeTracker);
                this.blockChangeListener.register();
            }
            this.blockChangeListener.setEnabled(true);
        } else if (this.blockChangeListener != null) {
            this.blockChangeListener.setEnabled(false);
            this.blockChangeTracker.clear();
        }
        this.blockChangeTracker.setExpirationAgeTicks(config.getInt("compatibility.blocks.changetracker.maxageticks"));
        this.blockChangeTracker.setWorldNodeSkipSize(config.getInt("compatibility.blocks.changetracker.perworld.maxentries"));
        this.blockChangeTracker.updateBlockCacheHandle();
    }

    @Override
    public LogManager getLogManager() {
        return this.logManager;
    }

    private MCAccess initMCAccess(ConfigFile config) {
        MCAccessConfig mcaC = new MCAccessConfig(config);
        MCAccess mcAccess = new MCAccessFactory().getMCAccess(mcaC);
        this.genericInstanceRegistry.registerGenericInstance(MCAccess.class, mcAccess);
        this.genericInstanceRegistry.registerGenericInstance(BlockCache.class, mcAccess.getBlockCache());
        new AttributeAccessFactory().setupAttributeAccess(mcAccess, mcaC);
        new EntityAccessFactory().setupEntityAccess(mcAccess, mcaC);
        this.logManager.info(Streams.INIT, "McAccess set to: " + mcAccess.getMCVersion() + " / " + mcAccess.getServerVersionTag());
        return mcAccess;
    }

    private void initBlockProperties(ConfigFile config) {
        BlockProperties.init(this.mcAccess, ConfigManager.getWorldConfigProvider());
        BlockProperties.applyConfig(config, "compatibility.blocks.");
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this, new Runnable(){

            @Override
            public void run() {
                ConfigFile config = ConfigManager.getConfigFile();
                BlockProperties.dumpBlocks(config.getBoolean("checks.blockbreak.debug", config.getBoolean("checks.debug", false)));
            }
        });
    }

    private Listener getCoreListener() {
        return new NCPListener(){

            @EventHandler(priority=EventPriority.NORMAL)
            public void onPlayerLogin(PlayerLoginEvent event) {
                if (event.getResult() != PlayerLoginEvent.Result.ALLOWED) {
                    return;
                }
                Player player = event.getPlayer();
                if (NoCheatPlus.this.checkDenyLoginsNames(player.getName())) {
                    if (DataManager.getPlayerData(player).hasPermission(Permissions.BYPASS_DENY_LOGIN, player)) {
                        return;
                    }
                    event.setResult(PlayerLoginEvent.Result.KICK_OTHER);
                    event.setKickMessage(ColorUtil.replaceColors(ConfigManager.getConfigFile(player.getWorld().getName()).getString("strings.msgtempdenylogin")));
                }
            }

            @EventHandler(priority=EventPriority.LOWEST)
            public void onPlayerJoinLowest(PlayerJoinEvent event) {
                if (NoCheatPlus.this.clearExemptionsOnJoin) {
                    Player player = event.getPlayer();
                    NCPExemptionManager.unexempt(player);
                }
            }

            @EventHandler(priority=EventPriority.LOW)
            public void onPlayerJoinLow(PlayerJoinEvent event) {
                NoCheatPlus.this.onJoinLow(event.getPlayer());
            }

            @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
            public void onPlayerKick(PlayerKickEvent event) {
                NoCheatPlus.this.onLeave(event.getPlayer());
            }

            @EventHandler(priority=EventPriority.MONITOR)
            public void onPlayerQuit(PlayerQuitEvent event) {
                NoCheatPlus.this.onLeave(event.getPlayer());
            }

            @EventHandler(priority=EventPriority.MONITOR)
            public void onWorldLoad(WorldLoadEvent event) {
                NoCheatPlus.this.onWorldLoad(event);
            }
        };
    }

    private void onWorldLoad(WorldLoadEvent event) {
        this.onWorldPresent(event.getWorld());
    }

    private void onWorldPresent(World world) {
        this.worldDataManager.updateWorldIdentifier(world);
    }

    private void onJoinLow(Player player) {
        String playerName = player.getName();
        IPlayerData data = DataManager.getPlayerData(player);
        if (data.hasPermission(Permissions.NOTIFY, player)) {
            if (this.configProblemsChat != null && ConfigManager.getConfigFile().getBoolean("configversion.notify")) {
                this.sendMessageOnTick(playerName, ChatColor.RED + "NCP: " + ChatColor.WHITE + this.configProblemsChat);
            }
            if (data.getNotifyOff()) {
                this.sendMessageOnTick(playerName, MSG_NOTIFY_OFF);
            }
        }
        for (JoinLeaveListener jlListener : this.joinLeaveListeners) {
            try {
                jlListener.playerJoins(player);
            }
            catch (Throwable t) {
                this.logManager.severe(Streams.INIT, "JoinLeaveListener(" + jlListener.getClass().getName() + ") generated an exception (join): " + t.getClass().getSimpleName());
                this.logManager.severe(Streams.INIT, t);
            }
        }
        ModUtil.motdOnJoin(player);
    }

    private void onLeave(Player player) {
        for (JoinLeaveListener jlListener : this.joinLeaveListeners) {
            try {
                jlListener.playerLeaves(player);
            }
            catch (Throwable t) {
                this.logManager.severe(Streams.INIT, "JoinLeaveListener(" + jlListener.getClass().getName() + ") generated an exception (leave): " + t.getClass().getSimpleName());
                this.logManager.severe(Streams.INIT, t);
            }
        }
        if (this.clearExemptionsOnLeave) {
            NCPExemptionManager.unexempt(player);
        }
    }

    private void scheduleConsistencyCheckers() {
        ConfigFile config;
        BukkitScheduler sched = this.getServer().getScheduler();
        if (this.consistencyCheckerTaskId != -1) {
            sched.cancelTask(this.consistencyCheckerTaskId);
        }
        if (!(config = ConfigManager.getConfigFile()).getBoolean("data.consistencychecks.active", true)) {
            return;
        }
        long delay = 20L * config.getInt("data.consistencychecks.interval", 1, 3600, 10);
        this.consistencyCheckerTaskId = sched.scheduleSyncRepeatingTask((Plugin)this, new Runnable(){

            @Override
            public void run() {
                NoCheatPlus.this.runConsistencyChecks();
            }
        }, delay, delay);
    }

    private void midTermCleanup() {
        if (this.blockChangeListener != null && this.blockChangeListener.isEnabled()) {
            this.blockChangeTracker.checkExpiration(TickTask.getTick());
        }
    }

    private void runConsistencyChecks() {
        long tStart = System.currentTimeMillis();
        ConfigFile config = ConfigManager.getConfigFile();
        if (!config.getBoolean("data.consistencychecks.active") || this.consistencyCheckers.isEmpty()) {
            this.consistencyCheckerIndex = 0;
            return;
        }
        long tEnd = tStart + config.getLong("data.consistencychecks.maxtime", 1L, 50L, 2L);
        if (this.consistencyCheckerIndex >= this.consistencyCheckers.size()) {
            this.consistencyCheckerIndex = 0;
        }
        Player[] onlinePlayers = BridgeMisc.getOnlinePlayers();
        while (this.consistencyCheckerIndex < this.consistencyCheckers.size()) {
            ConsistencyChecker checker = this.consistencyCheckers.get(this.consistencyCheckerIndex);
            try {
                checker.checkConsistency(onlinePlayers);
            }
            catch (Throwable t) {
                this.logManager.severe(Streams.INIT, "ConsistencyChecker(" + checker.getClass().getName() + ") encountered an exception:");
                this.logManager.severe(Streams.INIT, t);
            }
            ++this.consistencyCheckerIndex;
            long now = System.currentTimeMillis();
            if (now >= tStart && now < tEnd) continue;
            break;
        }
        if (this.consistencyCheckerIndex < this.consistencyCheckers.size()) {
            this.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this, new Runnable(){

                @Override
                public void run() {
                    NoCheatPlus.this.runConsistencyChecks();
                }
            });
            if (config.getBoolean("logging.extended.status")) {
                this.logManager.info(Streams.STATUS, "Interrupted consistency checking until next tick.");
            }
        }
    }

    @Override
    public <T> T getGenericInstance(Class<T> registeredFor) {
        return this.genericInstanceRegistry.getGenericInstance(registeredFor);
    }

    @Override
    public <T> T registerGenericInstance(T instance) {
        return this.genericInstanceRegistry.registerGenericInstance(instance);
    }

    @Override
    public <T, TI extends T> T registerGenericInstance(Class<T> registerFor, TI instance) {
        return this.genericInstanceRegistry.registerGenericInstance(registerFor, instance);
    }

    @Override
    public <T> T unregisterGenericInstance(Class<T> registeredFor) {
        return this.genericInstanceRegistry.unregisterGenericInstance(registeredFor);
    }

    @Override
    public <T> IGenericInstanceHandle<T> getGenericInstanceHandle(Class<T> registeredFor) {
        return this.genericInstanceRegistry.getGenericInstanceHandle(registeredFor);
    }

    @Override
    public void addFeatureTags(String key, Collection<String> featureTags) {
        LinkedHashSet<String> present = this.featureTags.get(key);
        if (present == null) {
            present = new LinkedHashSet();
            this.featureTags.put(key, present);
        }
        present.addAll(featureTags);
    }

    @Override
    public void setFeatureTags(String key, Collection<String> featureTags) {
        LinkedHashSet<String> present = new LinkedHashSet<String>();
        this.featureTags.put(key, present);
        present.addAll(featureTags);
    }

    @Override
    public boolean hasFeatureTag(String key, String feature) {
        Collection features = this.featureTags.get(key);
        return features == null ? false : features.contains(feature);
    }

    @Override
    public Map<String, Set<String>> getAllFeatureTags() {
        LinkedHashMap allTags = new LinkedHashMap();
        for (Map.Entry<String, LinkedHashSet<String>> entry : this.featureTags.entrySet()) {
            allTags.put(entry.getKey(), Collections.unmodifiableSet((Set)entry.getValue()));
        }
        return Collections.unmodifiableMap(allTags);
    }

    @Override
    public BlockChangeTracker getBlockChangeTracker() {
        return this.blockChangeTracker;
    }

    @Override
    public EventRegistryBukkit getEventRegistry() {
        return this.eventRegistry;
    }

    @Override
    public PermissionRegistry getPermissionRegistry() {
        return this.permissionRegistry;
    }

    @Override
    public IWorldDataManager getWorldDataManager() {
        return this.worldDataManager;
    }

    @Override
    public IPlayerDataManager getPlayerDataManager() {
        return this.pDataMan;
    }

    @Override
    public void register(RegistrationContext context) {
        context.doRegister();
    }

    @Override
    public RegistrationContext newRegistrationContext() {
        return new RegistrationContext();
    }

    @Override
    public ActionFactoryFactory getActionFactoryFactory() {
        ActionFactoryFactory factory = this.getGenericInstance(ActionFactoryFactory.class);
        if (factory == null) {
            this.setActionFactoryFactory(null);
            factory = this.getGenericInstance(ActionFactoryFactory.class);
        }
        return factory;
    }

    @Override
    public ActionFactoryFactory setActionFactoryFactory(ActionFactoryFactory actionFactoryFactory) {
        if (actionFactoryFactory == null) {
            actionFactoryFactory = new ActionFactoryFactory(){

                @Override
                public final ActionFactory newActionFactory(Map<String, Object> library) {
                    return new ActionFactory(library);
                }
            };
        }
        ActionFactoryFactory previous = this.registerGenericInstance(ActionFactoryFactory.class, actionFactoryFactory);
        IWorldDataManager worldMan = NCPAPIProvider.getNoCheatPlusAPI().getWorldDataManager();
        Iterator<Map.Entry<String, IWorldData>> it = worldMan.getWorldDataIterator();
        while (it.hasNext()) {
            ConfigFile config = it.next().getValue().getRawConfiguration();
            config.setActionFactory(actionFactoryFactory);
        }
        return previous;
    }

    @SetupOrder(priority=-100)
    private class ReloadHook
    implements INotifyReload {
        private ReloadHook() {
        }

        @Override
        public void onReload() {
            NoCheatPlus.this.processReload();
        }
    }

    private class PostEnableTask
    implements Runnable {
        private final Player[] onlinePlayers;

        private PostEnableTask(Player[] onlinePlayers) {
            this.onlinePlayers = onlinePlayers;
        }

        @Override
        public void run() {
            NoCheatPlus.this.postEnable(this.onlinePlayers);
        }
    }
}

