/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.worlds;

import fr.neatmonster.nocheatplus.NCPAPIProvider;
import fr.neatmonster.nocheatplus.checks.CheckType;
import fr.neatmonster.nocheatplus.compat.AlmostBoolean;
import fr.neatmonster.nocheatplus.components.NoCheatPlusAPI;
import fr.neatmonster.nocheatplus.components.config.ICheckConfig;
import fr.neatmonster.nocheatplus.components.config.IConfig;
import fr.neatmonster.nocheatplus.components.config.value.OverrideType;
import fr.neatmonster.nocheatplus.components.data.ICheckData;
import fr.neatmonster.nocheatplus.components.data.IData;
import fr.neatmonster.nocheatplus.components.data.IDataOnReload;
import fr.neatmonster.nocheatplus.components.data.IDataOnWorldUnload;
import fr.neatmonster.nocheatplus.components.registry.factory.IFactoryOne;
import fr.neatmonster.nocheatplus.components.registry.factory.RichFactoryRegistry;
import fr.neatmonster.nocheatplus.components.registry.feature.INotifyReload;
import fr.neatmonster.nocheatplus.components.registry.order.RegistrationOrder;
import fr.neatmonster.nocheatplus.config.ConfigFile;
import fr.neatmonster.nocheatplus.config.DefaultConfig;
import fr.neatmonster.nocheatplus.event.mini.MiniListener;
import fr.neatmonster.nocheatplus.utilities.ds.map.HashMapLOW;
import fr.neatmonster.nocheatplus.worlds.IWorldData;
import fr.neatmonster.nocheatplus.worlds.IWorldDataManager;
import fr.neatmonster.nocheatplus.worlds.WorldData;
import fr.neatmonster.nocheatplus.worlds.WorldFactoryArgument;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.world.WorldUnloadEvent;

public class WorldDataManager
implements IWorldDataManager,
INotifyReload {
    private final Lock lock = new ReentrantLock();
    private final HashMapLOW<String, WorldData> worldDataMap = new HashMapLOW(this.lock, 10);
    private Map<String, ConfigFile> rawConfigurations = new HashMap<String, ConfigFile>();
    private final RichFactoryRegistry<WorldFactoryArgument> factoryRegistry = new RichFactoryRegistry(this.lock);
    private final MiniListener<?>[] miniListeners = new MiniListener[]{new MiniListener<WorldUnloadEvent>(){

        @Override
        @EventHandler(priority=EventPriority.LOWEST)
        @RegistrationOrder.RegisterMethodWithOrder(tag="system.nocheatplus.worlddatamanager", beforeTag="(system\\.nocheatplus\\.playerdatamanager|feature.*)")
        public void onEvent(WorldUnloadEvent event) {
            WorldDataManager.this.onWorldUnload(event);
        }
    }};

    public WorldDataManager() {
        this.createDefaultWorldData();
        this.factoryRegistry.createAutoGroup(IDataOnReload.class);
        this.factoryRegistry.createAutoGroup(IDataOnWorldUnload.class);
        this.factoryRegistry.createAutoGroup(IData.class);
        this.factoryRegistry.createAutoGroup(IConfig.class);
        this.factoryRegistry.createAutoGroup(ICheckData.class);
        this.factoryRegistry.createAutoGroup(ICheckConfig.class);
    }

    @Override
    public IWorldData getDefaultWorldData() {
        return this.internalGetDefaultWorldData();
    }

    @Override
    public IWorldData getWorldData(String worldName) {
        return this.internalGetWorldData(worldName.toLowerCase());
    }

    @Override
    public IWorldData getWorldData(World world) {
        WorldData worldData = this.internalGetWorldData(world.getName().toLowerCase());
        if (worldData.getWorldIdentifier() == null) {
            worldData.updateWorldIdentifier(world);
        }
        return worldData;
    }

    private WorldData internalGetWorldData(String lowerCaseWorldName) {
        WorldData worldData = this.worldDataMap.get(lowerCaseWorldName);
        if (worldData != null) {
            return worldData;
        }
        return this.createWorldData(lowerCaseWorldName);
    }

    private WorldData internalGetDefaultWorldData() {
        return this.worldDataMap.get(null);
    }

    private void createDefaultWorldData() {
        this.lock.lock();
        if (this.worldDataMap.containsKey(null)) {
            this.lock.unlock();
            return;
        }
        ConfigFile config = this.rawConfigurations.get(null);
        if (config == null) {
            config = new DefaultConfig();
        }
        this.worldDataMap.put(null, new WorldData(null, this));
        this.updateWorldData(null, config);
        this.lock.unlock();
    }

    private WorldData createWorldData(String worldName) {
        return this.updateWorldData(worldName, this.getDefaultWorldData().getRawConfiguration());
    }

    @Override
    public Iterator<Map.Entry<String, IWorldData>> getWorldDataIterator() {
        return new IWorldDataIterator(this.worldDataMap.iterator());
    }

    @Override
    public Iterable<Map.Entry<String, IWorldData>> getWorldDataIterable() {
        final Iterator<Map.Entry<String, IWorldData>> iterator = this.getWorldDataIterator();
        return new Iterable<Map.Entry<String, IWorldData>>(){

            @Override
            public Iterator<Map.Entry<String, IWorldData>> iterator() {
                return iterator;
            }
        };
    }

    public void applyConfiguration(Map<String, ConfigFile> rawWorldConfigs) {
        String worldName;
        this.lock.lock();
        LinkedHashMap<String, ConfigFile> rawConfigurations = new LinkedHashMap<String, ConfigFile>(rawWorldConfigs.size());
        for (Map.Entry<String, ConfigFile> entry : rawWorldConfigs.entrySet()) {
            String worldName2 = entry.getKey();
            rawConfigurations.put(worldName2 == null ? null : worldName2.toLowerCase(), entry.getValue());
        }
        this.rawConfigurations = rawConfigurations;
        ConfigFile defaultConfig = this.rawConfigurations.get(null);
        WorldData defaultWorldData = this.internalGetDefaultWorldData();
        defaultWorldData.update(defaultConfig);
        this.lock.unlock();
        for (Map.Entry entry : rawConfigurations.entrySet()) {
            worldName = (String)entry.getKey();
            if (worldName == null) continue;
            this.updateWorldData(worldName, (ConfigFile)((Object)entry.getValue()));
        }
        for (Map.Entry<Object, Object> entry : this.worldDataMap.iterable()) {
            worldName = (String)entry.getKey();
            if (worldName == null || rawConfigurations.containsKey(worldName)) continue;
            WorldData ref = (WorldData)entry.getValue();
            this.lock.lock();
            defaultWorldData.addChild(ref);
            ref.adjustToParent(defaultWorldData);
            this.lock.unlock();
        }
    }

    public void removeOfflineInheritedWorldData() {
        HashSet<String> worldNames = new HashSet<String>();
        for (World world : Bukkit.getWorlds()) {
            worldNames.add(world.getName().toLowerCase());
        }
        LinkedList<String> remove = new LinkedList<String>();
        for (Map.Entry<String, WorldData> entry : this.worldDataMap.iterable()) {
            String lcName = entry.getKey();
            if (this.rawConfigurations.containsKey(lcName) || worldNames.contains(lcName)) continue;
            remove.add(lcName);
        }
        this.worldDataMap.remove(remove);
    }

    @Override
    public void updateAllWorldData() {
        this.lock.lock();
        WorldData defaultWorldData = this.internalGetDefaultWorldData();
        defaultWorldData.update();
        for (Map.Entry<String, WorldData> entry : this.worldDataMap.iterable()) {
            WorldData ref = entry.getValue();
            if (ref == defaultWorldData) continue;
            ref.update();
        }
        this.lock.unlock();
    }

    private WorldData updateWorldData(String worldName, ConfigFile rawConfiguration) {
        WorldData defaultWorldData = this.internalGetDefaultWorldData();
        this.lock.lock();
        String lcName = worldName == null ? null : worldName.toLowerCase();
        WorldData data = this.worldDataMap.get(lcName);
        boolean skipUpdate = false;
        if (data == null) {
            data = new WorldData(worldName, defaultWorldData, this.factoryRegistry);
            this.worldDataMap.put(data.getWorldNameLowerCase(), data);
            if (rawConfiguration == defaultWorldData.getRawConfiguration()) {
                defaultWorldData.addChild(data);
                skipUpdate = true;
            }
        }
        if (!skipUpdate) {
            data.update(rawConfiguration);
        }
        this.lock.unlock();
        return data;
    }

    @Override
    public void overrideCheckActivation(CheckType checkType, AlmostBoolean active, OverrideType overrideType, boolean overrideChildren) {
        this.lock.lock();
        IWorldData defaultWorldData = this.getDefaultWorldData();
        defaultWorldData.overrideCheckActivation(checkType, active, overrideType, overrideChildren);
        for (Map.Entry<String, WorldData> entry : this.worldDataMap.iterable()) {
            IWorldData worldData = entry.getValue();
            if (worldData == defaultWorldData) continue;
            worldData.overrideCheckActivation(checkType, active, overrideType, overrideChildren);
        }
        this.lock.unlock();
    }

    @Override
    public boolean isActiveAnywhere(CheckType checkType) {
        for (Map.Entry<String, WorldData> entry : this.worldDataMap.iterable()) {
            if (!entry.getValue().isCheckActive(checkType)) continue;
            return true;
        }
        return false;
    }

    public void updateWorldIdentifier(World world) {
        this.internalGetWorldData(world.getName().toLowerCase()).updateWorldIdentifier(world);
    }

    @Override
    public IWorldData getWorldDataSafe(Player player) {
        try {
            return this.getWorldData(player.getWorld());
        }
        catch (UnsupportedOperationException e) {
            return this.getDefaultWorldData();
        }
    }

    @Override
    public <T> void registerFactory(Class<T> registerFor, IFactoryOne<WorldFactoryArgument, T> factory) {
        this.factoryRegistry.registerFactory(registerFor, factory);
    }

    @Override
    public <G> void createAutoGroup(Class<G> groupType) {
        this.factoryRegistry.createAutoGroup(groupType);
    }

    @Override
    public <T> Collection<Class<? extends T>> getGroupedTypes(Class<T> groupType) {
        return this.factoryRegistry.getGroupedTypes(groupType);
    }

    @Override
    public <T> Collection<Class<? extends T>> getGroupedTypes(Class<T> groupType, CheckType checkType) {
        return this.factoryRegistry.getGroupedTypes(groupType, checkType);
    }

    @Override
    public <I> void addToGroups(Class<I> itemType, Class<? super I> ... groupTypes) {
        this.factoryRegistry.addToGroups(itemType, groupTypes);
    }

    @Override
    public void addToExistingGroups(Class<?> itemType) {
        this.factoryRegistry.addToExistingGroups(itemType);
    }

    @Override
    public <I> void addToGroups(CheckType checkType, Class<I> itemType, Class<? super I> ... groupTypes) {
        this.factoryRegistry.addToGroups(checkType, itemType, groupTypes);
    }

    @Override
    public <I> void addToExistingGroups(CheckType checkType, Class<I> itemType) {
        this.factoryRegistry.addToExistingGroups(checkType, itemType);
    }

    @Override
    public <I> void addToGroups(Collection<CheckType> checkTypes, Class<I> itemType, Class<? super I> ... groupTypes) {
        this.factoryRegistry.addToGroups(checkTypes, itemType, groupTypes);
    }

    @Override
    public <I> void addToExistingGroups(Collection<CheckType> checkTypes, Class<I> itemType) {
        this.factoryRegistry.addToExistingGroups(checkTypes, itemType);
    }

    @Override
    public <G> void createGroup(Class<G> groupType) {
        this.factoryRegistry.createGroup(groupType);
    }

    @Override
    public <T> T getNewInstance(Class<T> registeredFor, WorldFactoryArgument arg) {
        return this.factoryRegistry.getNewInstance(registeredFor, arg);
    }

    public void onEnable() {
        NoCheatPlusAPI api = NCPAPIProvider.getNoCheatPlusAPI();
        for (MiniListener<?> listener : this.miniListeners) {
            api.addComponent(listener, false);
        }
        api.addComponent(this);
    }

    private void onWorldUnload(WorldUnloadEvent event) {
        Collection<Class<? extends IDataOnWorldUnload>> types = this.factoryRegistry.getGroupedTypes(IDataOnWorldUnload.class);
        World world = event.getWorld();
        WorldData worldData = this.worldDataMap.get(world.getName().toLowerCase());
        worldData.onWorldUnload(event.getWorld(), types);
    }

    @Override
    public void onReload() {
        Collection<Class<? extends IDataOnReload>> types = this.factoryRegistry.getGroupedTypes(IDataOnReload.class);
        for (Map.Entry<String, WorldData> entry : this.worldDataMap.iterable()) {
            entry.getValue().onReload(types);
        }
    }

    @Override
    public void clearData(CheckType checkType) {
        boolean hasSub;
        RichFactoryRegistry.CheckRemovalSpec removalSpec = new RichFactoryRegistry.CheckRemovalSpec(checkType, true, this);
        boolean hasComplete = !removalSpec.completeRemoval.isEmpty();
        boolean bl = hasSub = !removalSpec.subCheckRemoval.isEmpty();
        if (hasComplete || hasSub) {
            for (Map.Entry<String, WorldData> entry : this.worldDataMap.iterable()) {
                WorldData worldData = entry.getValue();
                if (hasComplete) {
                    worldData.removeAllGenericInstances(removalSpec.completeRemoval);
                }
                if (!hasSub) continue;
                worldData.removeSubCheckData(removalSpec.subCheckRemoval, removalSpec.checkTypes);
            }
        }
    }

    @Override
    public void removeCachedConfigs() {
        LinkedHashSet types = new LinkedHashSet(this.factoryRegistry.getGroupedTypes(IConfig.class));
        if (!types.isEmpty()) {
            for (Map.Entry<String, WorldData> entry : this.worldDataMap.iterable()) {
                entry.getValue().removeAllGenericInstances(types);
            }
        }
    }

    static class IWorldDataIterator
    implements Iterator<Map.Entry<String, IWorldData>> {
        private final Iterator<Map.Entry<String, WorldData>> iterator;

        IWorldDataIterator(Iterator<Map.Entry<String, WorldData>> iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public Map.Entry<String, IWorldData> next() {
            return new IWorldDataEntry(this.iterator.next());
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    static class IWorldDataEntry
    implements Map.Entry<String, IWorldData> {
        private final Map.Entry<String, WorldData> entry;

        IWorldDataEntry(Map.Entry<String, WorldData> entry) {
            this.entry = entry;
        }

        @Override
        public String getKey() {
            return this.entry.getKey();
        }

        @Override
        public IWorldData getValue() {
            return this.entry.getValue();
        }

        @Override
        public IWorldData setValue(IWorldData value) {
            throw new UnsupportedOperationException();
        }
    }
}

