/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.workaround;

import fr.neatmonster.nocheatplus.utilities.ds.count.acceptdeny.IAcceptDenyCounter;
import fr.neatmonster.nocheatplus.workaround.IStagedWorkaround;
import fr.neatmonster.nocheatplus.workaround.IWorkaround;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public interface IWorkaroundRegistry {
    public void setWorkaroundBluePrint(IWorkaround ... var1);

    public void setGroup(String var1, Collection<String> var2);

    public void setGroup(String var1, IWorkaround ... var2);

    public void setWorkaroundSetByIds(String var1, Collection<String> var2, String ... var3);

    public WorkaroundSet getWorkaroundSet(String var1);

    public IAcceptDenyCounter getGlobalCounter(String var1);

    public IAcceptDenyCounter createGlobalCounter(String var1);

    public <C extends IWorkaround> C getWorkaround(String var1, Class<C> var2);

    public IWorkaround getWorkaround(String var1);

    public Map<String, IAcceptDenyCounter> getGlobalCounters();

    public String getCheckedWorkaroundId(String var1);

    public Set<String> getCheckedIdSet(Collection<? extends IWorkaround> var1);

    public static class WorkaroundSet {
        private final Map<String, IWorkaround> workaroundsById = new LinkedHashMap<String, IWorkaround>();
        private final IStagedWorkaround[] stagedWorkarounds;
        private final Map<String, IWorkaround[]> groups;
        private final Map<String, IStagedWorkaround[]> stagedGroups;
        private Collection<String> justUsedIds = null;

        public WorkaroundSet(IWorkaround[] bluePrints, Map<String, String[]> groups) {
            ArrayList<IWorkaround> stagedWorkarounds = new ArrayList<IWorkaround>(bluePrints.length);
            for (int i = 0; i < bluePrints.length; ++i) {
                IWorkaround workaround = bluePrints[i].getNewInstance();
                this.workaroundsById.put(workaround.getId(), workaround);
                if (!(workaround instanceof IStagedWorkaround)) continue;
                stagedWorkarounds.add(workaround);
            }
            this.stagedWorkarounds = stagedWorkarounds.toArray(new IStagedWorkaround[stagedWorkarounds.size()]);
            if (groups != null) {
                this.groups = new HashMap<String, IWorkaround[]>();
                this.stagedGroups = new HashMap<String, IStagedWorkaround[]>();
                for (Map.Entry<String, String[]> entry : groups.entrySet()) {
                    String groupId = entry.getKey();
                    String[] workaroundIds = entry.getValue();
                    IWorkaround[] group = new IWorkaround[workaroundIds.length];
                    ArrayList<IStagedWorkaround> stagedGroup = new ArrayList<IStagedWorkaround>(workaroundIds.length);
                    for (int i = 0; i < workaroundIds.length; ++i) {
                        IWorkaround workaround;
                        group[i] = workaround = this.getWorkaround(workaroundIds[i]);
                        if (!(workaround instanceof IStagedWorkaround)) continue;
                        stagedGroup.add((IStagedWorkaround)((Object)workaround));
                    }
                    this.groups.put(groupId, group);
                    if (stagedGroup.isEmpty()) continue;
                    this.stagedGroups.put(groupId, stagedGroup.toArray(new IStagedWorkaround[stagedGroup.size()]));
                }
            } else {
                this.groups = null;
                this.stagedGroups = null;
            }
        }

        public <C extends IWorkaround> C getWorkaround(String id, Class<C> workaroundClass) {
            IWorkaround present = this.getWorkaround(id);
            if (!workaroundClass.isAssignableFrom(present.getClass())) {
                throw new IllegalArgumentException("Wrong type of registered workaround requested: " + workaroundClass.getName() + " instead of " + present.getClass().getName());
            }
            return (C)present;
        }

        public IWorkaround getWorkaround(String id) {
            IWorkaround present = this.workaroundsById.get(id);
            if (present == null) {
                throw new IllegalArgumentException("Workaround id not registered: " + id);
            }
            return present;
        }

        public void resetConditions() {
            for (int i = 0; i < this.stagedWorkarounds.length; ++i) {
                this.stagedWorkarounds[i].resetConditions();
            }
        }

        public void resetConditions(String groupId) {
            IStagedWorkaround[] workarounds;
            if (this.stagedGroups != null && (workarounds = this.stagedGroups.get(groupId)) != null) {
                for (int i = 0; i < workarounds.length; ++i) {
                    workarounds[i].resetConditions();
                }
            }
        }

        public boolean use(String workaroundId) {
            IWorkaround workaround = this.workaroundsById.get(workaroundId);
            if (workaround == null) {
                throw new IllegalArgumentException("Workaround id not registered: " + workaroundId);
            }
            if (workaround.use()) {
                if (this.justUsedIds != null) {
                    this.justUsedIds.add(workaround.getId());
                }
                return true;
            }
            return false;
        }

        public boolean canUse(String workaroundId) {
            return this.workaroundsById.get(workaroundId).canUse();
        }

        public void setJustUsedIds(Collection<String> justUsedIds) {
            this.justUsedIds = justUsedIds;
        }
    }
}

