/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.utilities.location;

import fr.neatmonster.nocheatplus.compat.blocks.changetracker.BlockChangeReference;
import fr.neatmonster.nocheatplus.compat.blocks.changetracker.BlockChangeTracker;
import fr.neatmonster.nocheatplus.components.location.IGetBlockPosition;
import fr.neatmonster.nocheatplus.components.location.IGetBox3D;
import fr.neatmonster.nocheatplus.components.location.IGetBukkitLocation;
import fr.neatmonster.nocheatplus.components.location.IGetPosition;
import fr.neatmonster.nocheatplus.utilities.TickTask;
import fr.neatmonster.nocheatplus.utilities.collision.CollisionUtil;
import fr.neatmonster.nocheatplus.utilities.location.LocUtil;
import fr.neatmonster.nocheatplus.utilities.location.TrigUtil;
import fr.neatmonster.nocheatplus.utilities.map.BlockCache;
import fr.neatmonster.nocheatplus.utilities.map.BlockProperties;
import fr.neatmonster.nocheatplus.utilities.map.MapUtil;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.BlockFace;
import org.bukkit.util.Vector;

public class RichBoundsLocation
implements IGetBukkitLocation,
IGetBlockPosition,
IGetBox3D {
    double yOnGround = 0.001;
    int blockX;
    int blockY;
    int blockZ;
    double x;
    double y;
    double z;
    float yaw;
    float pitch;
    double minX;
    double maxX;
    double minY;
    double maxY;
    double minZ;
    double maxZ;
    double boxMarginHorizontal;
    double boxMarginVertical;
    double onGroundMinY = Double.MAX_VALUE;
    double notOnGroundMaxY = Double.MIN_VALUE;
    BlockCache.IBlockCacheNode node = null;
    BlockCache.IBlockCacheNode nodeBelow = null;
    Long blockFlags = null;
    Boolean onClimbable = null;
    Boolean passable = null;
    Boolean passableBox = null;
    Boolean aboveStairs = null;
    Boolean inLava = null;
    Boolean inWater = null;
    Boolean inWeb = null;
    Boolean onIce = null;
    Boolean onGround = null;
    BlockCache blockCache = null;
    World world = null;

    public RichBoundsLocation(BlockCache blockCache) {
        this.blockCache = blockCache;
    }

    @Override
    public World getWorld() {
        return this.world;
    }

    @Override
    public String getWorldName() {
        return this.world.getName();
    }

    @Override
    public double getX() {
        return this.x;
    }

    @Override
    public double getY() {
        return this.y;
    }

    @Override
    public double getZ() {
        return this.z;
    }

    @Override
    public float getYaw() {
        return this.yaw;
    }

    @Override
    public float getPitch() {
        return this.pitch;
    }

    public Vector getVector() {
        return new Vector(this.x, this.y, this.z);
    }

    public Location getLocation() {
        if (this.world == null) {
            throw new NullPointerException("World is null.");
        }
        return new Location(this.world, this.x, this.y, this.z, this.yaw, this.pitch);
    }

    @Override
    public int getBlockX() {
        return this.blockX;
    }

    @Override
    public int getBlockY() {
        return this.blockY;
    }

    @Override
    public int getBlockZ() {
        return this.blockZ;
    }

    public double[] getBoundsAsDoubles() {
        return new double[]{this.minX, this.minY, this.minZ, this.maxX, this.maxY, this.maxZ};
    }

    @Override
    public double getMinX() {
        return this.minX;
    }

    @Override
    public double getMinZ() {
        return this.minZ;
    }

    @Override
    public double getMaxX() {
        return this.maxX;
    }

    @Override
    public double getMaxZ() {
        return this.maxZ;
    }

    @Override
    public double getMinY() {
        return this.minY;
    }

    @Override
    public double getMaxY() {
        return this.maxY;
    }

    public double getBoxMarginHorizontal() {
        return this.boxMarginHorizontal;
    }

    public double getBoxMarginVertical() {
        return this.boxMarginVertical;
    }

    public final boolean isSameBlock(IGetBlockPosition other) {
        return this.blockX == other.getBlockX() && this.blockZ == other.getBlockZ() && this.blockY == other.getBlockY();
    }

    public final boolean isSameBlock(int x, int y, int z) {
        return this.blockX == x && this.blockZ == z && this.blockY == y;
    }

    public final boolean isSameBlock(Location loc) {
        return this.blockX == loc.getBlockX() && this.blockZ == loc.getBlockZ() && this.blockY == loc.getBlockY();
    }

    public boolean isBlockAbove(IGetBlockPosition loc) {
        return this.blockY == loc.getBlockY() + 1 && this.blockX == loc.getBlockX() && this.blockZ == loc.getBlockZ();
    }

    public boolean isBlockAbove(Location loc) {
        return this.blockY == loc.getBlockY() + 1 && this.blockX == loc.getBlockX() && this.blockZ == loc.getBlockZ();
    }

    public boolean isSamePos(IGetPosition loc) {
        return this.x == loc.getX() && this.z == loc.getZ() && this.y == loc.getY();
    }

    public boolean isSamePos(Location loc) {
        return this.x == loc.getX() && this.z == loc.getZ() && this.y == loc.getY();
    }

    public int manhattan(IGetBlockPosition other) {
        return TrigUtil.manhattan(this.blockX, this.blockY, this.blockZ, other.getBlockX(), other.getBlockY(), other.getBlockZ());
    }

    public int maxBlockDist(IGetBlockPosition other) {
        return TrigUtil.maxDistance(this.blockX, this.blockY, this.blockZ, other.getBlockX(), other.getBlockY(), other.getBlockZ());
    }

    public boolean hasIllegalCoords() {
        return LocUtil.isBadCoordinate(this.minX, this.maxX, this.minY, this.maxY, this.minZ, this.maxZ);
    }

    public Long getBlockFlags() {
        return this.blockFlags;
    }

    public void setBlockFlags(Long blockFlags) {
        this.blockFlags = blockFlags;
    }

    public Material getTypeIdAbove() {
        return this.blockCache.getType(this.blockX, this.blockY + 1, this.blockZ);
    }

    public boolean isDownStream(double xDistance, double zDistance) {
        return BlockProperties.isDownStream(this.blockCache, this.blockX, this.blockY, this.blockZ, this.getData(), xDistance, zDistance);
    }

    public BlockCache.IBlockCacheNode getOrCreateBlockCacheNode() {
        if (this.node == null) {
            this.node = this.blockCache.getOrCreateBlockCacheNode(this.blockX, this.blockY, this.blockZ, false);
        }
        return this.node;
    }

    public BlockCache.IBlockCacheNode getOrCreateBlockCacheNodeBelow() {
        if (this.nodeBelow == null) {
            this.nodeBelow = this.blockCache.getOrCreateBlockCacheNode(this.blockX, this.blockY - 1, this.blockZ, false);
        }
        return this.nodeBelow;
    }

    public Material getTypeId() {
        if (this.node == null) {
            this.getOrCreateBlockCacheNode();
        }
        return this.node.getType();
    }

    public Material getTypeIdBelow() {
        if (this.nodeBelow == null) {
            this.getOrCreateBlockCacheNodeBelow();
        }
        return this.nodeBelow.getType();
    }

    public Integer getData() {
        if (this.node == null) {
            this.node = this.blockCache.getOrCreateBlockCacheNode(this.blockX, this.blockY, this.blockZ, false);
            return this.node.getData(this.blockCache, this.blockX, this.blockY, this.blockZ);
        }
        return this.node.getData();
    }

    public final Material getTypeId(int x, int y, int z) {
        return this.blockCache.getType(x, y, z);
    }

    public final int getData(int x, int y, int z) {
        return this.blockCache.getData(x, y, z);
    }

    public void setBlockCache(BlockCache cache) {
        this.blockCache = cache;
    }

    public final BlockCache getBlockCache() {
        return this.blockCache;
    }

    public boolean isAboveStairs() {
        if (this.aboveStairs == null) {
            if (this.blockFlags != null && (this.blockFlags & 1L) == 0L) {
                this.aboveStairs = false;
                return false;
            }
            double diff = 0.0;
            this.aboveStairs = BlockProperties.collides(this.blockCache, this.minX - 0.0, this.minY - 1.0, this.minZ - 0.0, this.maxX + 0.0, this.minY + 0.25, this.maxZ + 0.0, 1L);
        }
        return this.aboveStairs;
    }

    public boolean isInLava() {
        if (this.inLava == null) {
            if (this.blockFlags != null && (this.blockFlags & 0x20L) == 0L) {
                this.inLava = false;
                return false;
            }
            this.inLava = BlockProperties.collides(this.blockCache, this.minX, this.minY, this.minZ, this.maxX, this.maxY, this.maxZ, 32L);
        }
        return this.inLava;
    }

    public boolean isInWater() {
        if (this.inWater == null) {
            if (this.blockFlags != null && (this.blockFlags & 0x10L) == 0L) {
                this.inWater = false;
                return false;
            }
            this.inWater = BlockProperties.collides(this.blockCache, this.minX, this.minY, this.minZ, this.maxX, this.maxY, this.maxZ, 16L);
        }
        return this.inWater;
    }

    public boolean isInLiquid() {
        if (this.blockFlags != null && (this.blockFlags & 2L) == 0L) {
            return false;
        }
        return this.isInWater() || this.isInLava();
    }

    public boolean isOnClimbable() {
        if (this.onClimbable == null) {
            Material typeId = this.getTypeId();
            if (this.blockFlags != null && (this.blockFlags & 0x200L) == 0L && (this.blockFlags & 0x400000L) == 0L) {
                this.onClimbable = false;
                return false;
            }
            long thisFlags = BlockProperties.getBlockFlags(typeId);
            this.onClimbable = (thisFlags & 0x200L) != 0L;
            if (!this.onClimbable.booleanValue() && (thisFlags & 0x400000L) != 0L && BlockProperties.isTrapDoorAboveLadderSpecialCase(this.blockCache, this.blockX, this.blockY, this.blockZ)) {
                this.onClimbable = true;
            }
        }
        return this.onClimbable;
    }

    public boolean isNextToGround(double xzMargin, double yMargin) {
        return BlockProperties.collides(this.blockCache, this.minX - xzMargin, this.minY - yMargin, this.minZ - xzMargin, this.maxX + xzMargin, this.maxY + yMargin, this.maxZ + xzMargin, 128L);
    }

    public boolean isResetCond() {
        return this.isInLiquid() || this.isOnClimbable() || this.isInWeb();
    }

    public boolean standsOnBlock(Material id) {
        if (!this.isOnGround()) {
            return false;
        }
        return BlockProperties.collidesBlock(this.blockCache, this.minX, this.minY - this.yOnGround, this.minZ, this.maxX, this.minY, this.maxZ, id);
    }

    public boolean isAboveLadder() {
        if (this.blockFlags != null && (this.blockFlags & 0x200L) == 0L) {
            return false;
        }
        return (BlockProperties.getBlockFlags(this.getTypeIdBelow()) & 0x200L) != 0L;
    }

    public boolean isInWeb() {
        if (this.inWeb == null) {
            if (this.blockFlags == null || (this.blockFlags & 0x200000000L) != 0L) {
                double inset = 0.001;
                this.inWeb = BlockProperties.collides(this.blockCache, this.minX + 0.001, this.minY + 0.001, this.minZ + 0.001, this.maxX - 0.001, this.maxY - 0.001, this.maxZ - 0.001, 0x200000000L);
            } else {
                this.inWeb = false;
            }
        }
        return this.inWeb;
    }

    public boolean isOnIce() {
        if (this.onIce == null) {
            this.onIce = this.blockFlags != null && (this.blockFlags & 0x20000L) == 0L ? Boolean.valueOf(false) : Boolean.valueOf(this.isOnGround() && BlockProperties.collides(this.blockCache, this.minX, this.minY - this.yOnGround, this.minZ, this.maxX, this.minY, this.maxZ, 131072L));
        }
        return this.onIce;
    }

    public boolean isOnRails() {
        return BlockProperties.isRails(this.getTypeId()) || this.y - (double)this.blockY < 0.3625 && BlockProperties.isAscendingRails(this.getTypeIdBelow(), this.getData(this.blockX, this.blockY - 1, this.blockZ));
    }

    public boolean isOnGround() {
        if (this.onGround != null) {
            return this.onGround;
        }
        if (this.notOnGroundMaxY >= this.yOnGround) {
            this.onGround = false;
        } else if (this.onGroundMinY <= this.yOnGround) {
            this.onGround = true;
        } else if (this.blockFlags == null || (this.blockFlags & 0x80L) != 0L) {
            double[] bounds;
            int bY = Location.locToBlock((double)(this.y - this.yOnGround));
            BlockCache.IBlockCacheNode useNode = bY == this.blockY ? this.getOrCreateBlockCacheNode() : (bY == this.blockY - 1 ? this.getOrCreateBlockCacheNodeBelow() : this.blockCache.getOrCreateBlockCacheNode(this.blockX, bY, this.blockZ, false));
            Material id = useNode.getType();
            long flags = BlockProperties.getBlockFlags(id);
            if ((flags & 0x80L) != 0L && (flags & 0x400L) == 0L && (bounds = useNode.getBounds(this.blockCache, this.blockX, bY, this.blockZ)) != null && this.y - (double)bY >= bounds[4] && BlockProperties.collidesBlock(this.blockCache, this.x, this.minY - this.yOnGround, this.z, this.x, this.minY, this.z, this.blockX, bY, this.blockZ, useNode, null, flags) && (!BlockProperties.isPassableWorkaround(this.blockCache, this.blockX, bY, this.blockZ, this.minX - (double)this.blockX, this.minY - this.yOnGround - (double)bY, this.minZ - (double)this.blockZ, useNode, this.maxX - this.minX, this.yOnGround, this.maxZ - this.minZ, 1.0) || (flags & 0x1000L) != 0L && BlockProperties.getGroundMinHeight(this.blockCache, this.blockX, bY, this.blockZ, useNode, flags) <= this.y - (double)bY)) {
                this.onGround = true;
            }
            if (this.onGround == null) {
                this.onGround = BlockProperties.isOnGround(this.blockCache, this.minX, this.minY - this.yOnGround, this.minZ, this.maxX, this.minY, this.maxZ, 0L);
            }
        } else {
            this.onGround = false;
        }
        if (this.onGround.booleanValue()) {
            this.onGroundMinY = Math.min(this.onGroundMinY, this.yOnGround);
        } else {
            this.notOnGroundMaxY = Math.max(this.notOnGroundMaxY, this.yOnGround);
        }
        return this.onGround;
    }

    public boolean isOnGround(double yOnGround) {
        if (this.notOnGroundMaxY >= yOnGround) {
            return false;
        }
        if (this.onGroundMinY <= yOnGround) {
            return true;
        }
        return this.isOnGround(yOnGround, 0.0, 0.0, 0L);
    }

    public boolean isOnGround(double yOnGround, long ignoreFlags) {
        if (ignoreFlags == 0L) {
            if (this.notOnGroundMaxY >= yOnGround) {
                return false;
            }
            if (this.onGroundMinY <= yOnGround) {
                return true;
            }
        }
        return this.isOnGround(yOnGround, 0.0, 0.0, ignoreFlags);
    }

    public boolean isOnGround(double yOnGround, double xzMargin, double yMargin) {
        if (xzMargin >= 0.0 && this.onGroundMinY <= yOnGround) {
            return true;
        }
        if (xzMargin <= 0.0 && yMargin == 0.0 && this.notOnGroundMaxY >= yOnGround) {
            return false;
        }
        return this.isOnGround(yOnGround, xzMargin, yMargin, 0L);
    }

    public boolean isOnGround(double yOnGround, double xzMargin, double yMargin, long ignoreFlags) {
        if (ignoreFlags == 0L) {
            if (xzMargin >= 0.0 && this.onGroundMinY <= yOnGround) {
                return true;
            }
            if (xzMargin <= 0.0 && yMargin == 0.0 && this.notOnGroundMaxY >= yOnGround) {
                return false;
            }
        }
        boolean onGround = BlockProperties.isOnGround(this.blockCache, this.minX - xzMargin, this.minY - yOnGround - yMargin, this.minZ - xzMargin, this.maxX + xzMargin, this.minY + yMargin, this.maxZ + xzMargin, ignoreFlags);
        if (ignoreFlags == 0L) {
            if (onGround) {
                if (xzMargin <= 0.0 && yMargin == 0.0) {
                    this.onGroundMinY = Math.min(this.onGroundMinY, yOnGround);
                }
            } else if (xzMargin >= 0.0) {
                this.notOnGroundMaxY = Math.max(this.notOnGroundMaxY, yOnGround);
            }
        }
        return onGround;
    }

    public final boolean isOnGroundOpportune(double yOnGround, long ignoreFlags, BlockChangeTracker blockChangeTracker, BlockChangeReference blockChangeRef, int tick) {
        return blockChangeTracker.isOnGround(this.blockCache, blockChangeRef, tick, this.world.getUID(), this.minX, this.minY - yOnGround, this.minZ, this.maxX, this.maxY, this.maxZ, ignoreFlags);
    }

    public boolean isNextToSolid(double xzMargin, double yMargin) {
        return BlockProperties.collides(this.blockCache, this.minX - xzMargin, this.minY - yMargin, this.minZ - xzMargin, this.maxX + xzMargin, this.maxY + yMargin, this.maxZ + xzMargin, 4L);
    }

    public boolean isOnGroundOrResetCond() {
        return this.isOnGround() || this.isResetCond();
    }

    public double getyOnGround() {
        return this.yOnGround;
    }

    public void setyOnGround(double yOnGround) {
        this.yOnGround = yOnGround;
        this.onGround = null;
        this.blockFlags = null;
    }

    public boolean isPassable() {
        if (this.passable == null) {
            if (this.isBlockFlagsPassable()) {
                this.passable = true;
            } else {
                if (this.node == null) {
                    this.node = this.blockCache.getOrCreateBlockCacheNode(this.blockX, this.blockY, this.blockZ, false);
                }
                this.passable = BlockProperties.isPassable(this.blockCache, this.x, this.y, this.z, this.node, null);
            }
        }
        return this.passable;
    }

    public boolean isPassableBox() {
        if (this.passableBox == null) {
            this.passableBox = this.isBlockFlagsPassable() ? Boolean.valueOf(true) : (this.passable != null && this.passable == false ? Boolean.valueOf(false) : Boolean.valueOf(BlockProperties.isPassableBox(this.blockCache, this.minX, this.minY, this.minZ, this.maxX, this.maxY, this.maxZ)));
        }
        return this.passableBox;
    }

    private boolean isBlockFlagsPassable() {
        return this.blockFlags != null && (this.blockFlags & 0x84L) == 0L;
    }

    public void collectBlockFlags() {
        if (this.blockFlags == null) {
            this.collectBlockFlags(this.yOnGround);
        }
    }

    public void collectBlockFlags(double maxYonGround) {
        maxYonGround = Math.max(this.yOnGround, maxYonGround);
        double yExtra = 0.6;
        double xzM = 0.0;
        this.blockFlags = BlockProperties.collectFlagsSimple(this.blockCache, this.minX - 0.0, this.minY - 0.6 - maxYonGround, this.minZ - 0.0, this.maxX + 0.0, Math.max(this.maxY, this.minY + 1.5), this.maxZ + 0.0);
    }

    public int ensureChunksLoaded() {
        return this.ensureChunksLoaded(1.0);
    }

    public int ensureChunksLoaded(double xzMargin) {
        return MapUtil.ensureChunksLoaded(this.world, this.x, this.z, xzMargin);
    }

    public boolean matchBlockChange(BlockChangeTracker blockChangeTracker, BlockChangeReference ref, BlockChangeTracker.Direction direction, double coverDistance) {
        int tick = TickTask.getTick();
        UUID worldId = this.world.getUID();
        int iMinX = Location.locToBlock((double)this.minX);
        int iMaxX = Location.locToBlock((double)this.maxX);
        int iMinY = Location.locToBlock((double)this.minY);
        int iMaxY = Location.locToBlock((double)this.maxY);
        int iMinZ = Location.locToBlock((double)this.minZ);
        int iMaxZ = Location.locToBlock((double)this.maxZ);
        BlockChangeTracker.BlockChangeEntry minEntry = null;
        for (int x = iMinX; x <= iMaxX; ++x) {
            for (int z = iMinZ; z <= iMaxZ; ++z) {
                for (int y = iMinY; y <= iMaxY; ++y) {
                    BlockChangeTracker.BlockChangeEntry entry = blockChangeTracker.getBlockChangeEntry(ref, tick, worldId, x, y, z, direction);
                    if (entry == null || minEntry != null && entry.id >= minEntry.id || !(coverDistance > 0.0) || !this.coversDistance(x, y, z, direction, coverDistance)) continue;
                    minEntry = entry;
                }
            }
        }
        if (minEntry == null) {
            return false;
        }
        ref.updateSpan(minEntry);
        return true;
    }

    public boolean matchBlockChangeMatchResultingFlags(BlockChangeTracker blockChangeTracker, BlockChangeReference ref, BlockChangeTracker.Direction direction, double coverDistance, long matchFlags) {
        int tick = TickTask.getTick();
        UUID worldId = this.world.getUID();
        BlockFace blockFace = direction == null ? BlockFace.SELF : direction.blockFace;
        int iMinX = Location.locToBlock((double)this.minX) - blockFace.getModX();
        int iMaxX = Location.locToBlock((double)this.maxX) - blockFace.getModX();
        int iMinY = Location.locToBlock((double)this.minY) - blockFace.getModY();
        int iMaxY = Location.locToBlock((double)this.maxY) - blockFace.getModY();
        int iMinZ = Location.locToBlock((double)this.minZ) - blockFace.getModZ();
        int iMaxZ = Location.locToBlock((double)this.maxZ) - blockFace.getModZ();
        BlockChangeTracker.BlockChangeEntry minEntry = null;
        for (int x = iMinX; x <= iMaxX; ++x) {
            for (int z = iMinZ; z <= iMaxZ; ++z) {
                for (int y = iMinY; y <= iMaxY; ++y) {
                    BlockChangeTracker.BlockChangeEntry entry = blockChangeTracker.getBlockChangeEntryMatchFlags(ref, tick, worldId, x, y, z, direction, matchFlags);
                    if (entry == null || minEntry != null && entry.id >= minEntry.id || !(coverDistance > 0.0) || !this.coversDistance(x + blockFace.getModX(), y + blockFace.getModY(), z + blockFace.getModZ(), direction, coverDistance)) continue;
                    minEntry = entry;
                }
            }
        }
        if (minEntry == null) {
            return false;
        }
        ref.updateSpan(minEntry);
        return true;
    }

    public boolean isBlockIntersecting(int x, int y, int z) {
        return CollisionUtil.intersectsBlock(this.minX, this.maxX, x) && CollisionUtil.intersectsBlock(this.minY, this.maxY, y) && CollisionUtil.intersectsBlock(this.minZ, this.maxZ, z);
    }

    public boolean isBlockIntersecting(int x, int y, int z, BlockFace blockFace) {
        return this.isBlockIntersecting(x, y, z) || this.isBlockIntersecting(x + blockFace.getModX(), y + blockFace.getModY(), z + blockFace.getModZ());
    }

    private boolean coversDistance(int x, int y, int z, BlockChangeTracker.Direction direction, double coverDistance) {
        switch (direction) {
            case Y_POS: {
                return (double)y + 1.0 - Math.max(this.minY, (double)y) >= coverDistance;
            }
            case Y_NEG: {
                return Math.min(this.maxY, (double)y + 1.0) - (double)y >= coverDistance;
            }
            case X_POS: {
                return (double)x + 1.0 - Math.max(this.minX, (double)x) >= coverDistance;
            }
            case X_NEG: {
                return Math.min(this.maxX, (double)x + 1.0) - (double)x >= coverDistance;
            }
            case Z_POS: {
                return (double)z + 1.0 - Math.max(this.minZ, (double)z) >= coverDistance;
            }
            case Z_NEG: {
                return Math.min(this.maxZ, (double)z + 1.0) - (double)z >= coverDistance;
            }
        }
        return true;
    }

    public void prepare(RichBoundsLocation other) {
        this.blockFlags = other.blockFlags;
        this.notOnGroundMaxY = other.notOnGroundMaxY;
        this.onGroundMinY = other.onGroundMinY;
        this.passable = other.passable;
        this.passableBox = other.passableBox;
        this.node = other.node;
        this.nodeBelow = other.nodeBelow;
        this.onGround = other.isOnGround();
        this.inWater = other.isInWater();
        this.inLava = other.isInLava();
        this.inWeb = other.isInWeb();
        this.onIce = other.isOnIce();
        this.onClimbable = other.isOnClimbable();
        if (!this.onGround.booleanValue() && !this.isResetCond()) {
            this.aboveStairs = other.isAboveStairs();
        }
    }

    public void set(Location location, double fullWidth, double fullHeight, double yOnGround) {
        this.doSet(location, fullWidth, fullHeight, yOnGround);
    }

    protected void doSet(Location location, double fullWidth, double fullHeight, double yOnGround) {
        this.blockX = location.getBlockX();
        this.blockY = location.getBlockY();
        this.blockZ = location.getBlockZ();
        this.x = location.getX();
        this.y = location.getY();
        this.z = location.getZ();
        this.yaw = location.getYaw();
        this.pitch = location.getPitch();
        double dxz = (double)Math.round(fullWidth * 500.0) / 1000.0;
        this.minX = this.x - dxz;
        this.minY = this.y;
        this.minZ = this.z - dxz;
        this.maxX = this.x + dxz;
        this.maxY = this.y + fullHeight;
        this.maxZ = this.z + dxz;
        this.boxMarginHorizontal = dxz;
        this.boxMarginVertical = fullHeight;
        this.world = location.getWorld();
        if (this.world == null) {
            throw new NullPointerException("World is null.");
        }
        this.nodeBelow = null;
        this.node = null;
        this.passableBox = null;
        this.passable = null;
        this.onClimbable = null;
        this.onGround = null;
        this.onIce = null;
        this.inWeb = null;
        this.inWater = null;
        this.inLava = null;
        this.aboveStairs = null;
        this.onGroundMinY = Double.MAX_VALUE;
        this.notOnGroundMaxY = Double.MIN_VALUE;
        this.blockFlags = null;
        this.yOnGround = yOnGround;
    }

    public void cleanup() {
        this.world = null;
        this.blockCache = null;
    }

    public int hashCode() {
        return LocUtil.hashCode(this);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(128);
        builder.append("RichBoundsLocation(");
        builder.append(this.world == null ? "null" : this.world.getName());
        builder.append('/');
        builder.append(Double.toString(this.x));
        builder.append(", ");
        builder.append(Double.toString(this.y));
        builder.append(", ");
        builder.append(Double.toString(this.z));
        builder.append(')');
        return builder.toString();
    }
}

