/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.utilities.ds.prefixtree;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PrefixTree<K, N extends Node<K, N>, L extends LookupEntry<K, N>> {
    protected final NodeFactory<K, N> nodeFactory;
    protected final LookupEntryFactory<K, N, L> resultFactory;
    protected N root;
    protected boolean visit;

    public PrefixTree(NodeFactory<K, N> nodeFactory, LookupEntryFactory<K, N, L> resultFactory) {
        this.nodeFactory = nodeFactory;
        this.root = nodeFactory.newNode(null);
        this.resultFactory = resultFactory;
    }

    public L lookup(K[] keys) {
        return this.lookup(keys, false);
    }

    public L lookup(List<K> keys) {
        return this.lookup(keys, false);
    }

    public L lookup(K[] keys, boolean create) {
        return this.lookup(Arrays.asList(keys), create);
    }

    public L lookup(List<K> keys, boolean create) {
        boolean visit = this.visit;
        N insertion = this.root;
        int depth = 0;
        N current = this.root;
        boolean hasPrefix = false;
        for (K key : keys) {
            Object child = ((Node)current).getChild(key);
            if (child == null) {
                if (!create) break;
                N temp = this.nodeFactory.newNode(current);
                current = ((Node)current).putChild(key, temp);
                continue;
            }
            current = child;
            insertion = current;
            ++depth;
            if (((Node)child).isEnd) {
                hasPrefix = true;
            }
            if (!visit) continue;
            this.visit(child);
        }
        Object node = null;
        if (create) {
            node = current;
            ((Node)current).isEnd = true;
        } else if (depth == keys.size()) {
            node = current;
        }
        L result = this.resultFactory.newLookupEntry(node, insertion, depth, hasPrefix);
        this.decorate(result);
        return result;
    }

    protected void visit(N node) {
    }

    protected void decorate(L result) {
    }

    public boolean feed(List<K> keys) {
        L result = this.lookup(keys, true);
        return ((LookupEntry)result).insertion == ((LookupEntry)result).node;
    }

    public boolean feed(K[] keys) {
        return this.feed(Arrays.asList(keys));
    }

    public boolean hasPrefix(List<K> keys) {
        return ((LookupEntry)this.lookup(keys, (boolean)false)).hasPrefix;
    }

    public boolean hasPrefix(K[] keys) {
        return this.hasPrefix(Arrays.asList(keys));
    }

    public boolean isPrefix(List<K> keys) {
        return ((LookupEntry)this.lookup(keys, (boolean)false)).depth == keys.size();
    }

    public boolean isPrefix(K[] keys) {
        return this.isPrefix(Arrays.asList(keys));
    }

    public boolean matches(List<K> keys) {
        L result = this.lookup(keys, false);
        return ((LookupEntry)result).node == ((LookupEntry)result).insertion && ((Node)((LookupEntry)result).insertion).isEnd;
    }

    public boolean matches(K[] keys) {
        return this.matches(Arrays.asList(keys));
    }

    public void clear() {
        this.root = this.nodeFactory.newNode(null);
    }

    public static <K> PrefixTree<K, SimpleNode<K>, LookupEntry<K, SimpleNode<K>>> newPrefixTree() {
        return new PrefixTree(new NodeFactory<K, SimpleNode<K>>(){

            @Override
            public final SimpleNode<K> newNode(SimpleNode<K> parent) {
                return new SimpleNode();
            }
        }, new LookupEntryFactory<K, SimpleNode<K>, LookupEntry<K, SimpleNode<K>>>(){

            @Override
            public final LookupEntry<K, SimpleNode<K>> newLookupEntry(SimpleNode<K> node, SimpleNode<K> insertion, int depth, boolean hasPrefix) {
                return new LookupEntry(node, insertion, depth, hasPrefix);
            }
        });
    }

    public static interface LookupEntryFactory<K, N extends Node<K, N>, L extends LookupEntry<K, N>> {
        public L newLookupEntry(N var1, N var2, int var3, boolean var4);
    }

    public static class LookupEntry<K, N extends Node<K, N>> {
        public final N node;
        public final N insertion;
        public final int depth;
        public final boolean hasPrefix;

        public LookupEntry(N node, N insertion, int depth, boolean hasPrefix) {
            this.node = node;
            this.insertion = insertion;
            this.depth = depth;
            this.hasPrefix = hasPrefix;
        }
    }

    public static interface NodeFactory<K, N extends Node<K, N>> {
        public N newNode(N var1);
    }

    public static class SimpleNode<K>
    extends Node<K, SimpleNode<K>> {
    }

    public static class Node<K, N extends Node<K, N>> {
        protected int minCap = 4;
        public boolean isEnd = false;
        public Map<K, N> children = null;

        public N getChild(K key) {
            if (this.children == null) {
                return null;
            }
            return (N)((Node)this.children.get(key));
        }

        public N putChild(K key, N child) {
            if (this.children == null) {
                this.children = new HashMap<K, N>(this.minCap);
            }
            this.children.put(key, child);
            return child;
        }
    }
}

