/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.utilities.collision;

import fr.neatmonster.nocheatplus.components.location.IGetBox3D;
import fr.neatmonster.nocheatplus.utilities.collision.CollisionUtil;
import fr.neatmonster.nocheatplus.utilities.collision.ICollideRayVsAABB;

public class CollideRayVsAABB
implements ICollideRayVsAABB {
    private boolean findNearestPointIfNotCollide = false;
    private double startX;
    private double startY;
    private double startZ;
    private double dirX;
    private double dirY;
    private double dirZ;
    private double minX;
    private double minY;
    private double minZ;
    private double maxX;
    private double maxY;
    private double maxZ;
    private double closestX;
    private double closestY;
    private double closestZ;
    private double closestDistanceSquared;
    private double closestTime;
    private boolean collides;

    @Override
    public ICollideRayVsAABB setRay(double startX, double startY, double startZ, double dirX, double dirY, double dirZ) {
        this.startX = startX;
        this.startY = startY;
        this.startZ = startZ;
        this.dirX = dirX;
        this.dirY = dirY;
        this.dirZ = dirZ;
        return this;
    }

    @Override
    public ICollideRayVsAABB setAABB(IGetBox3D box) {
        this.setAABB(box.getMinX(), box.getMinY(), box.getMinZ(), box.getMaxX(), box.getMaxY(), box.getMaxZ());
        return this;
    }

    @Override
    public ICollideRayVsAABB setAABB(double targetX, double targetY, double targetZ, double boxMarginHorizontal, double boxMarginVertical) {
        return this.setAABB(targetX - boxMarginHorizontal, targetY, targetZ - boxMarginHorizontal, targetX + boxMarginHorizontal, targetY + boxMarginVertical, targetZ + boxMarginHorizontal);
    }

    @Override
    public ICollideRayVsAABB setAABB(int targetX, int targetY, int targetZ, double margin) {
        return this.setAABB(-margin + (double)targetX, -margin + (double)targetY, -margin + (double)targetZ, 1.0 + margin + (double)targetX, 1.0 + margin + (double)targetY, 1.0 + margin + (double)targetZ);
    }

    @Override
    public ICollideRayVsAABB setAABB(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        this.minX = minX;
        this.minY = minY;
        this.minZ = minZ;
        this.maxX = maxX;
        this.maxY = maxY;
        this.maxZ = maxZ;
        return this;
    }

    @Override
    public ICollideRayVsAABB setFindNearestPointIfNotCollide(boolean findNearestPointIfNotCollide) {
        this.findNearestPointIfNotCollide = findNearestPointIfNotCollide;
        return this;
    }

    @Override
    public boolean getFindNearestPointIfNotCollide() {
        return this.findNearestPointIfNotCollide;
    }

    @Override
    public ICollideRayVsAABB loop() {
        this.collides = false;
        this.closestX = this.startX;
        this.closestY = this.startY;
        this.closestZ = this.startZ;
        this.closestDistanceSquared = 0.0;
        this.closestTime = 0.0;
        double tMinX = CollisionUtil.getMinTimeIncludeEdges(this.startX, this.dirX, this.minX, this.maxX);
        double tMinY = CollisionUtil.getMinTimeIncludeEdges(this.startY, this.dirY, this.minY, this.maxY);
        double tMinZ = CollisionUtil.getMinTimeIncludeEdges(this.startZ, this.dirZ, this.minZ, this.maxZ);
        double tMaxX = CollisionUtil.getMaxTimeIncludeEdges(this.startX, this.dirX, this.minX, this.maxX, tMinX);
        double tMaxY = CollisionUtil.getMaxTimeIncludeEdges(this.startY, this.dirY, this.minY, this.maxY, tMinY);
        double tMaxZ = CollisionUtil.getMaxTimeIncludeEdges(this.startZ, this.dirZ, this.minZ, this.maxZ, tMinZ);
        if (!(Double.isNaN(tMaxX) || Double.isNaN(tMaxY) || Double.isNaN(tMaxZ))) {
            double tMax;
            double tMin = Math.max(tMinX, Math.max(tMinY, tMinZ));
            if (tMin <= (tMax = Math.min(tMaxX, Math.min(tMaxY, tMaxZ)))) {
                this.collides = true;
                this.closestX = this.startX + this.dirX * tMin;
                this.closestY = this.startY + this.dirY * tMin;
                this.closestZ = this.startZ + this.dirZ * tMin;
                this.closestTime = tMin;
            } else if (this.findNearestPointIfNotCollide) {
                this.findNearestPoint(tMinX, tMinY, tMinZ, tMaxX, tMaxY, tMaxZ);
            }
        } else if (this.findNearestPointIfNotCollide) {
            this.findNearestPoint(tMinX, tMinY, tMinZ, tMaxX, tMaxY, tMaxZ);
        }
        return this;
    }

    private void findNearestPoint(double ... timeValues) {
        this.closestDistanceSquared = CollisionUtil.getSquaredDistAABB(this.startX, this.startY, this.startZ, this.minX, this.minY, this.minZ, this.maxX, this.maxY, this.maxZ);
        for (int i = 0; i < timeValues.length; ++i) {
            double z;
            double y;
            double x;
            double distanceSquared;
            double time = timeValues[i];
            if (Double.isNaN(time) || Double.isInfinite(time) || !((distanceSquared = CollisionUtil.getSquaredDistAABB(x = this.startX + this.dirX * time, y = this.startY + this.dirY * time, z = this.startZ + this.dirZ * time, this.minX, this.minY, this.minZ, this.maxX, this.maxY, this.maxZ)) < this.closestDistanceSquared)) continue;
            this.closestX = x;
            this.closestY = y;
            this.closestZ = z;
            this.closestDistanceSquared = distanceSquared;
            this.closestTime = time;
        }
    }

    @Override
    public boolean collides() {
        return this.collides;
    }

    @Override
    public double getX() {
        return this.closestX;
    }

    @Override
    public double getY() {
        return this.closestY;
    }

    @Override
    public double getZ() {
        return this.closestZ;
    }

    @Override
    public double getClosestDistanceSquared() {
        return this.closestDistanceSquared;
    }

    @Override
    public double getTime() {
        return this.closestTime;
    }
}

