/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.players;

import fr.neatmonster.nocheatplus.checks.CheckType;
import fr.neatmonster.nocheatplus.compat.AlmostBoolean;
import fr.neatmonster.nocheatplus.components.config.value.OverrideType;
import fr.neatmonster.nocheatplus.components.data.checktype.CheckNodeWithDebug;
import fr.neatmonster.nocheatplus.components.data.checktype.CheckTypeTree;
import fr.neatmonster.nocheatplus.components.data.checktype.IBaseCheckNode;
import fr.neatmonster.nocheatplus.config.ConfigFile;
import fr.neatmonster.nocheatplus.hooks.ExemptionContext;
import fr.neatmonster.nocheatplus.worlds.IWorldCheckNode;
import fr.neatmonster.nocheatplus.worlds.IWorldData;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.locks.Lock;
import org.bukkit.Bukkit;

public class PlayerCheckTypeTree
extends CheckTypeTree<PlayerCheckTypeTreeNode> {
    private final Lock lock;

    public PlayerCheckTypeTree(Lock lock) {
        this.lock = lock;
    }

    @Override
    protected PlayerCheckTypeTreeNode newNode(CheckType checkType, PlayerCheckTypeTreeNode parent, CheckTypeTree.CheckTypeTreeNodeFactory<PlayerCheckTypeTreeNode> factory) {
        return new PlayerCheckTypeTreeNode(checkType, parent, factory);
    }

    public boolean isExempted(CheckType checkType) {
        return ((PlayerCheckTypeTreeNode)this.getNode(checkType)).isExempted();
    }

    public void exempt(CheckType checkType, ExemptionContext context) {
        PlayerCheckTypeTreeNode node = (PlayerCheckTypeTreeNode)this.getNode(checkType);
        if (node == null) {
            throw new IllegalArgumentException("Invalid check type.");
        }
        if (Bukkit.isPrimaryThread()) {
            this.exemptPrimaryThread(node, context);
        } else {
            this.exemptAsynchronous(node, context);
        }
    }

    private void exemptPrimaryThread(PlayerCheckTypeTreeNode node, final ExemptionContext context) {
        this.visitWithDescendants(node, new CheckTypeTree.Visitor<PlayerCheckTypeTreeNode>(){

            @Override
            public boolean visit(PlayerCheckTypeTreeNode node) {
                node.exemptPrimaryThread(context);
                return true;
            }
        });
    }

    private void exemptAsynchronous(PlayerCheckTypeTreeNode node, final ExemptionContext context) {
        this.lock.lock();
        this.visitWithDescendants(node, new CheckTypeTree.Visitor<PlayerCheckTypeTreeNode>(){

            @Override
            public boolean visit(PlayerCheckTypeTreeNode node) {
                node.exemptAsynchronous(context);
                return true;
            }
        });
        this.lock.unlock();
    }

    public void unexempt(CheckType checkType, ExemptionContext context) {
        PlayerCheckTypeTreeNode node = (PlayerCheckTypeTreeNode)this.getNode(checkType);
        if (node == null) {
            throw new IllegalArgumentException("Invalid check type.");
        }
        if (Bukkit.isPrimaryThread()) {
            this.unexemptPrimaryThread(node, context);
        } else {
            this.unexemptAsynchronous(node, context);
        }
    }

    private void unexemptPrimaryThread(PlayerCheckTypeTreeNode node, final ExemptionContext context) {
        this.visitWithDescendants(node, new CheckTypeTree.Visitor<PlayerCheckTypeTreeNode>(){

            @Override
            public boolean visit(PlayerCheckTypeTreeNode node) {
                node.unexemptPrimaryThread(context);
                return true;
            }
        });
    }

    private void unexemptAsynchronous(PlayerCheckTypeTreeNode node, final ExemptionContext context) {
        this.lock.lock();
        this.visitWithDescendants(node, new CheckTypeTree.Visitor<PlayerCheckTypeTreeNode>(){

            @Override
            public boolean visit(PlayerCheckTypeTreeNode node) {
                node.unexemptAsynchronous(context);
                return true;
            }
        });
        this.lock.unlock();
    }

    public void unexemptAll(CheckType checkType, ExemptionContext context) {
        PlayerCheckTypeTreeNode node = (PlayerCheckTypeTreeNode)this.getNode(checkType);
        if (node == null) {
            throw new IllegalArgumentException("Invalid check type.");
        }
        if (Bukkit.isPrimaryThread()) {
            this.unexemptAllPrimaryThread(node, context);
        } else {
            this.unexemptAllAsynchronous(node, context);
        }
    }

    private void unexemptAllPrimaryThread(PlayerCheckTypeTreeNode node, final ExemptionContext context) {
        this.visitWithDescendants(node, new CheckTypeTree.Visitor<PlayerCheckTypeTreeNode>(){

            @Override
            public boolean visit(PlayerCheckTypeTreeNode node) {
                node.unexemptAllPrimaryThread(context);
                return true;
            }
        });
    }

    private void unexemptAllAsynchronous(PlayerCheckTypeTreeNode node, final ExemptionContext context) {
        this.lock.lock();
        this.visitWithDescendants(node, new CheckTypeTree.Visitor<PlayerCheckTypeTreeNode>(){

            @Override
            public boolean visit(PlayerCheckTypeTreeNode node) {
                node.unexemptAllAsynchronous(context);
                return true;
            }
        });
        this.lock.unlock();
    }

    public boolean isExempted(CheckType checkType, ExemptionContext context) {
        PlayerCheckTypeTreeNode node = (PlayerCheckTypeTreeNode)this.getNode(checkType);
        if (node == null) {
            throw new IllegalArgumentException("Invalid check type.");
        }
        if (Bukkit.isPrimaryThread()) {
            return this.isExemptedPrimaryThread(node, context);
        }
        return this.isExemptedAsynchronous(node, context);
    }

    private boolean isExemptedPrimaryThread(PlayerCheckTypeTreeNode node, ExemptionContext context) {
        return node.isExemptedPrimaryThread(context);
    }

    private boolean isExemptedAsynchronous(PlayerCheckTypeTreeNode node, ExemptionContext context) {
        this.lock.lock();
        boolean res = node.isExemptedPrimaryThread(context);
        this.lock.unlock();
        return res;
    }

    public void clearAllExemptions() {
        this.clearAllExemptions(CheckType.ALL);
    }

    public void clearAllExemptions(CheckType checkType) {
        PlayerCheckTypeTreeNode node = (PlayerCheckTypeTreeNode)this.getNode(checkType);
        if (node == null) {
            throw new IllegalArgumentException("Invalid check type.");
        }
        this.lock.lock();
        this.visitWithDescendants(node, new CheckTypeTree.Visitor<PlayerCheckTypeTreeNode>(){

            @Override
            public boolean visit(PlayerCheckTypeTreeNode node) {
                node.clearAllExemptions();
                return true;
            }
        });
        this.lock.unlock();
    }

    static class PlayerCheckTypeTreeNode
    extends CheckNodeWithDebug<PlayerCheckTypeTreeNode>
    implements IBaseCheckNode {
        private boolean exemptedPrimaryThread = false;
        private boolean exemptedAsynchronous = false;
        private List<ExemptionContext> exemptionsPrimaryThread = null;
        private List<ExemptionContext> exemptionsAsynchronous = null;

        PlayerCheckTypeTreeNode(CheckType checkType, PlayerCheckTypeTreeNode parent, CheckTypeTree.CheckTypeTreeNodeFactory<PlayerCheckTypeTreeNode> factory) {
            super(checkType, parent, factory);
        }

        boolean isExempted() {
            return this.exemptedPrimaryThread || this.exemptedAsynchronous;
        }

        void exemptAsynchronous(ExemptionContext context) {
            this.exemptedAsynchronous = true;
            if (this.exemptionsAsynchronous == null) {
                this.exemptionsAsynchronous = new LinkedList<ExemptionContext>();
            }
            this.exemptionsAsynchronous.add(0, context);
        }

        void exemptPrimaryThread(ExemptionContext context) {
            this.exemptedPrimaryThread = true;
            if (this.exemptionsPrimaryThread == null) {
                this.exemptionsPrimaryThread = new LinkedList<ExemptionContext>();
            }
            this.exemptionsPrimaryThread.add(0, context);
        }

        void unexemptAsynchronous(ExemptionContext context) {
            if (this.exemptionsAsynchronous != null) {
                this.exemptionsAsynchronous.remove(context);
                if (this.exemptionsAsynchronous.isEmpty()) {
                    this.exemptedAsynchronous = false;
                    this.exemptionsAsynchronous = null;
                }
            }
        }

        void unexemptPrimaryThread(ExemptionContext context) {
            if (this.exemptionsPrimaryThread != null) {
                this.exemptionsPrimaryThread.remove(context);
                if (this.exemptionsPrimaryThread.isEmpty()) {
                    this.exemptedPrimaryThread = false;
                    this.exemptionsPrimaryThread = null;
                }
            }
        }

        void unexemptAllAsynchronous(ExemptionContext context) {
            if (this.exemptionsAsynchronous != null) {
                this.exemptionsAsynchronous.removeAll(Collections.singleton(context));
                if (this.exemptionsAsynchronous.isEmpty()) {
                    this.exemptedAsynchronous = false;
                    this.exemptionsAsynchronous = null;
                }
            }
        }

        void unexemptAllPrimaryThread(ExemptionContext context) {
            if (this.exemptionsPrimaryThread != null) {
                this.exemptionsPrimaryThread.removeAll(Collections.singleton(context));
                if (this.exemptionsPrimaryThread.isEmpty()) {
                    this.exemptedPrimaryThread = false;
                    this.exemptionsPrimaryThread = null;
                }
            }
        }

        boolean isExemptedAsynchronous(ExemptionContext context) {
            return this.exemptionsAsynchronous != null && this.exemptionsAsynchronous.contains(context);
        }

        boolean isExemptedPrimaryThread(ExemptionContext context) {
            return this.exemptionsPrimaryThread != null && this.exemptionsPrimaryThread.contains(context);
        }

        void clearAllExemptions() {
            this.exemptedAsynchronous = false;
            this.exemptedPrimaryThread = false;
            this.exemptionsAsynchronous = null;
            this.exemptionsPrimaryThread = null;
        }

        void updateDebug(IWorldData worldData) {
            this.setDebugNoUpdate(worldData);
            this.updateDebug(worldData.getRawConfiguration());
        }

        private void setDebugNoUpdate(IWorldData worldData) {
            IWorldCheckNode worldNode = worldData.getCheckNode(this.getCheckType());
            this.configDebug.setValue(worldNode.isDebugActive(), worldNode.getOverrideTypeDebug());
            for (PlayerCheckTypeTreeNode node : this.getChildren()) {
                node.updateDebug(worldData);
            }
        }

        void updateDebug(ConfigFile rawConfiguration) {
            this.update(rawConfiguration, true, accessDebug);
        }

        void updateDebug() {
            this.update(true, accessDebug);
        }

        void resetDebug(IWorldData worldData) {
            this.resetDebugNoUpdate(worldData);
            this.updateDebug(worldData.getRawConfiguration());
        }

        private void resetDebugNoUpdate(IWorldData worldData) {
            IWorldCheckNode worldNode = worldData.getCheckNode(this.getCheckType());
            this.configDebug.resetValue(worldNode.isDebugActive(), worldNode.getOverrideTypeDebug());
            for (PlayerCheckTypeTreeNode node : this.getChildren()) {
                node.resetDebugNoUpdate(worldData);
            }
        }

        void overrideDebug(CheckType checkType, AlmostBoolean active, OverrideType overrideType, boolean overrideChildren) {
            this.override(active, overrideType, overrideChildren, accessDebug);
        }
    }
}

