/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.penalties;

import fr.neatmonster.nocheatplus.penalties.IPenalty;
import fr.neatmonster.nocheatplus.penalties.IPenaltyList;
import java.util.Collection;
import java.util.Random;

public class PenaltyNode {
    private final Random random;
    public final double probability;
    private final IPenalty<?> penalty;
    private final PenaltyNode[] childNodes;
    private final boolean abortOnApply;

    public PenaltyNode(Random random, IPenalty<?> penalty) {
        this(random, 1.0, penalty, null, false);
    }

    public PenaltyNode(Random random, double probability, IPenalty<?> penalty) {
        this(random, probability, penalty, null, false);
    }

    public PenaltyNode(Random random, double probability, IPenalty<?> penalty, Collection<PenaltyNode> childNodes, boolean abortOnApply) {
        this.random = random;
        this.probability = probability;
        this.penalty = penalty;
        this.childNodes = childNodes == null ? new PenaltyNode[]{} : childNodes.toArray(new PenaltyNode[childNodes.size()]);
        this.abortOnApply = abortOnApply;
    }

    public final boolean evaluate(IPenaltyList results) {
        if (this.probability < 1.0 && this.random.nextDouble() > this.probability) {
            return false;
        }
        this.add(results);
        return true;
    }

    protected void add(IPenaltyList results) {
        if (this.penalty != null) {
            this.penalty.addToPenaltyList(results);
        }
        if (this.childNodes.length > 0) {
            if (this.abortOnApply) {
                this.evaluateChildrenFCFS(results);
            } else {
                this.evaluateAllChildren(results);
            }
        }
    }

    protected void evaluateChildrenFCFS(IPenaltyList results) {
        double ref = this.random.nextDouble();
        double floor = 0.0;
        for (int i = 0; i < this.childNodes.length; ++i) {
            PenaltyNode childNode = this.childNodes[i];
            double nextFloor = floor + childNode.probability;
            if (nextFloor >= ref || nextFloor >= 0.999) {
                childNode.add(results);
                return;
            }
            floor = nextFloor;
        }
    }

    protected void evaluateAllChildren(IPenaltyList results) {
        for (int i = 0; i < this.childNodes.length; ++i) {
            this.childNodes[i].evaluate(results);
        }
    }
}

