/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.components.registry.setup.instance;

import fr.neatmonster.nocheatplus.NCPAPIProvider;
import fr.neatmonster.nocheatplus.checks.CheckType;
import fr.neatmonster.nocheatplus.components.config.ICheckConfig;
import fr.neatmonster.nocheatplus.components.config.IConfig;
import fr.neatmonster.nocheatplus.components.data.ICheckData;
import fr.neatmonster.nocheatplus.components.data.IData;
import fr.neatmonster.nocheatplus.components.data.IDataOnRemoveSubCheckData;
import fr.neatmonster.nocheatplus.components.registry.factory.IFactoryOne;
import fr.neatmonster.nocheatplus.components.registry.factory.IRichFactoryRegistry;
import fr.neatmonster.nocheatplus.components.registry.setup.IDoRegister;
import fr.neatmonster.nocheatplus.components.registry.setup.RegistrationContext;
import fr.neatmonster.nocheatplus.players.IPlayerDataManager;
import fr.neatmonster.nocheatplus.utilities.CheckTypeUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public abstract class RegisterInstance<T, A>
implements IDoRegister {
    protected final RegistrationContext registrationContext;
    protected final IRichFactoryRegistry<A> factoryRegistry;
    protected final Class<T> type;
    protected IFactoryOne<A, T> factory = null;
    protected boolean registerConfigTypesPlayer = false;
    protected boolean registerDataTypesPlayer = false;
    protected final List<IDoRegisterWithRegistry> genericDataItems = new LinkedList<IDoRegisterWithRegistry>();
    protected final List<IDoRegisterWithRegistry> genericConfigItems = new LinkedList<IDoRegisterWithRegistry>();
    protected final List<IDoRegister> items = new LinkedList<IDoRegister>();

    public RegisterInstance(RegistrationContext registrationContext, Class<T> type, IRichFactoryRegistry<A> factoryRegistry) {
        this.registrationContext = registrationContext;
        this.factoryRegistry = factoryRegistry;
        this.type = type;
    }

    public RegisterInstance<T, A> factory(IFactoryOne<A, T> factory) {
        this.factory = factory;
        return this;
    }

    public RegisterInstance<T, A> addToGroups(final CheckType checkType, final boolean withDescendantCheckTypes, final Class<? super T> ... groupTypes) {
        this.items.add(new IDoRegister(){

            @Override
            public void doRegister() {
                if (withDescendantCheckTypes) {
                    RegisterInstance.this.factoryRegistry.addToGroups(CheckTypeUtil.getWithDescendants(checkType), RegisterInstance.this.type, groupTypes);
                } else {
                    RegisterInstance.this.factoryRegistry.addToGroups(checkType, RegisterInstance.this.type, groupTypes);
                }
            }
        });
        return this;
    }

    public RegisterInstance<T, A> registerConfigTypesPlayer() {
        this.registerConfigTypesPlayer = true;
        return this;
    }

    public RegisterInstance<T, A> registerConfigTypesPlayer(CheckType checkType, boolean withDescendantCheckTypes) {
        Set<CheckType> checkTypes;
        this.registerConfigTypesPlayer();
        Collection<CheckType> collection = checkTypes = withDescendantCheckTypes ? CheckTypeUtil.getWithDescendants(checkType) : Arrays.asList(checkType);
        if (IConfig.class.isAssignableFrom(this.type)) {
            this.genericConfigItems.add(new IDoRegisterWithRegistry(){

                @Override
                public void doRegister(IRichFactoryRegistry<?> factoryRegistry) {
                    factoryRegistry.addToGroups(checkTypes, RegisterInstance.this.type, IConfig.class);
                }
            });
        }
        if (ICheckConfig.class.isAssignableFrom(this.type)) {
            this.genericConfigItems.add(new IDoRegisterWithRegistry(){

                @Override
                public void doRegister(IRichFactoryRegistry<?> factoryRegistry) {
                    factoryRegistry.addToGroups(checkTypes, RegisterInstance.this.type, ICheckConfig.class);
                }
            });
        }
        return this;
    }

    public RegisterInstance<T, A> registerDataTypesPlayer() {
        this.registerDataTypesPlayer = true;
        return this;
    }

    public RegisterInstance<T, A> registerDataTypesPlayer(CheckType checkType, boolean withDescendantCheckTypes) {
        Set<CheckType> checkTypes;
        this.registerDataTypesPlayer();
        Collection<CheckType> collection = checkTypes = withDescendantCheckTypes ? CheckTypeUtil.getWithDescendants(checkType) : Arrays.asList(checkType);
        if (IData.class.isAssignableFrom(this.type)) {
            this.genericConfigItems.add(new IDoRegisterWithRegistry(){

                @Override
                public void doRegister(IRichFactoryRegistry<?> factoryRegistry) {
                    factoryRegistry.addToGroups(checkTypes, RegisterInstance.this.type, IData.class);
                }
            });
        }
        if (ICheckData.class.isAssignableFrom(this.type)) {
            this.genericConfigItems.add(new IDoRegisterWithRegistry(){

                @Override
                public void doRegister(IRichFactoryRegistry<?> factoryRegistry) {
                    factoryRegistry.addToGroups(checkTypes, RegisterInstance.this.type, ICheckData.class);
                }
            });
        }
        return this;
    }

    public RegisterInstance<T, A> removeSubCheckData(CheckType checkType, boolean withDescendantCheckTypes) {
        if (!IDataOnRemoveSubCheckData.class.isAssignableFrom(this.type)) {
            throw new UnsupportedOperationException();
        }
        final Set<CheckType> checkTypes = withDescendantCheckTypes ? CheckTypeUtil.getWithDescendants(checkType) : Arrays.asList(checkType);
        this.items.add(new IDoRegister(){

            @Override
            public void doRegister() {
                RegisterInstance.this.factoryRegistry.addToGroups(checkTypes, RegisterInstance.this.type, IDataOnRemoveSubCheckData.class);
            }
        });
        return this;
    }

    public RegistrationContext registrationContext() {
        return this.registrationContext;
    }

    public RegistrationContext context() {
        return this.registrationContext();
    }

    @Override
    public void doRegister() {
        if (this.factory != null) {
            this.factoryRegistry.registerFactory(this.type, this.factory);
        }
        for (IDoRegister iDoRegister : this.items) {
            iDoRegister.doRegister();
        }
        for (IDoRegisterWithRegistry iDoRegisterWithRegistry : this.genericDataItems) {
            iDoRegisterWithRegistry.doRegister(this.factoryRegistry);
        }
        IPlayerDataManager pdMan = NCPAPIProvider.getNoCheatPlusAPI().getPlayerDataManager();
        if (this.registerConfigTypesPlayer) {
            this.registerConfigTypesPlayer(pdMan);
        }
        if (this.registerDataTypesPlayer) {
            this.registerDataTypesPlayer(pdMan);
        }
    }

    protected void registerConfigTypesPlayer(IPlayerDataManager pdMan) {
        if (IConfig.class.isAssignableFrom(this.type)) {
            pdMan.addToGroups(this.type, IConfig.class);
        }
        if (ICheckConfig.class.isAssignableFrom(this.type)) {
            pdMan.addToGroups(this.type, ICheckConfig.class);
        }
        for (IDoRegisterWithRegistry item : this.genericConfigItems) {
            item.doRegister(pdMan);
        }
    }

    protected void registerDataTypesPlayer(IPlayerDataManager pdMan) {
        if (IData.class.isAssignableFrom(this.type)) {
            pdMan.addToGroups(this.type, IData.class);
        }
        if (ICheckData.class.isAssignableFrom(this.type)) {
            pdMan.addToGroups(this.type, ICheckData.class);
        }
        for (IDoRegisterWithRegistry item : this.genericDataItems) {
            item.doRegister(pdMan);
        }
    }

    protected static interface IDoRegisterWithRegistry {
        public void doRegister(IRichFactoryRegistry<?> var1);
    }
}

