/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.components.registry.event;

import fr.neatmonster.nocheatplus.components.registry.GenericInstanceRegistry;
import fr.neatmonster.nocheatplus.components.registry.event.IGenericInstanceHandle;
import fr.neatmonster.nocheatplus.components.registry.event.IGenericInstanceRegistryListener;
import fr.neatmonster.nocheatplus.components.registry.event.IUnregisterGenericInstanceRegistryListener;

public class GenericInstanceHandle<T>
implements IGenericInstanceRegistryListener<T>,
IGenericInstanceHandle<T> {
    private GenericInstanceRegistry registry;
    private IUnregisterGenericInstanceRegistryListener unregister;
    private Class<T> registeredFor;
    private T handle = null;
    private boolean initialized = false;
    private boolean disabled = false;

    public GenericInstanceHandle(Class<T> registeredFor, GenericInstanceRegistry registry, IUnregisterGenericInstanceRegistryListener unregister) {
        this.registry = registry;
        this.unregister = unregister;
        this.registeredFor = registeredFor;
    }

    private T fetchHandle() {
        return this.registry.getGenericInstance(this.registeredFor);
    }

    @Override
    public void onGenericInstanceRegister(Class<T> registerFor, T instance) {
        this.handle = instance;
        this.initialized = true;
    }

    @Override
    public void onGenericInstanceOverride(Class<T> registerFor, T newInstance, T oldInstance) {
        this.handle = newInstance;
        this.initialized = true;
    }

    @Override
    public void onGenericInstanceRemove(Class<T> registerFor, T oldInstance) {
        this.handle = null;
        this.initialized = true;
    }

    @Override
    public T getHandle() {
        if (this.initialized) {
            return this.handle;
        }
        if (this.disabled) {
            throw new RuntimeException("Already disabled.");
        }
        return this.fetchHandle();
    }

    @Override
    public void disableHandle() {
        if (this.unregister != null) {
            this.disabled = true;
            this.initialized = false;
            this.handle = null;
            this.registeredFor = null;
            this.registry = null;
            if (this.unregister != null) {
                this.unregister.unregisterGenericInstanceRegistryListener(this.registeredFor, this);
            }
            this.unregister = null;
        }
    }

    public Class<T> getRegisteredFor() {
        return this.registeredFor;
    }

    public GenericInstanceRegistry getRegistry() {
        return this.registry;
    }

    public IUnregisterGenericInstanceRegistryListener getUnregister() {
        return this.unregister;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public static class ReferenceCountHandle<T>
    extends GenericInstanceHandle<T> {
        private int references = 0;

        public ReferenceCountHandle(Class<T> registeredFor, GenericInstanceRegistry registry, IUnregisterGenericInstanceRegistryListener unregister) {
            super(registeredFor, registry, unregister);
        }

        @Override
        public void disableHandle() {
            if (this.references > 0) {
                --this.references;
            }
            if (this.references == 0) {
                super.disableHandle();
            }
        }

        public IGenericInstanceHandle<T> getNewHandle() {
            if (this.isDisabled()) {
                throw new RuntimeException("Already disabled.");
            }
            ++this.references;
            return new ParentDelegateHandle(this.getRegisteredFor(), this.getRegistry(), this);
        }

        public int getNumberOfReferences() {
            return this.references;
        }
    }

    public static class ParentDelegateHandle<T>
    implements IGenericInstanceHandle<T> {
        private final IGenericInstanceHandle<T> parent;
        private boolean disabled = false;

        public ParentDelegateHandle(Class<T> registeredFor, GenericInstanceRegistry registry, IGenericInstanceHandle<T> parent) {
            this.parent = parent;
        }

        @Override
        public T getHandle() {
            if (this.disabled) {
                throw new RuntimeException("Already disabled.");
            }
            return this.parent.getHandle();
        }

        @Override
        public void disableHandle() {
            if (!this.disabled) {
                this.disabled = true;
                this.parent.disableHandle();
            }
        }
    }
}

