/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.components.registry.activation;

import fr.neatmonster.nocheatplus.NCPAPIProvider;
import fr.neatmonster.nocheatplus.compat.versions.GenericVersion;
import fr.neatmonster.nocheatplus.compat.versions.ServerVersion;
import fr.neatmonster.nocheatplus.components.NoCheatPlusAPI;
import fr.neatmonster.nocheatplus.components.registry.activation.IActivation;
import fr.neatmonster.nocheatplus.components.registry.activation.IDescriptiveActivation;
import fr.neatmonster.nocheatplus.utilities.ReflectionUtil;
import java.util.LinkedList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

public class Activation
implements IDescriptiveActivation {
    private final List<IActivation> conditions = new LinkedList<IActivation>();
    private boolean conditionsAND = true;
    private String neutralDescription = null;
    private boolean advertise = false;

    private static final String rightSideDelimiters(String version) {
        String pV = GenericVersion.parseVersionDelimiters(version, "", "-snapshot");
        if (pV == null) {
            pV = GenericVersion.parseVersionDelimiters(version, "", "-b");
        }
        return pV;
    }

    public static String guessUsablePluginVersion(String pluginName) {
        Plugin plugin = Bukkit.getServer().getPluginManager().getPlugin(pluginName);
        String version = plugin.getDescription().getVersion().toLowerCase();
        String pV = GenericVersion.collectVersion(version, 0);
        if (pV == null) {
            pV = Activation.rightSideDelimiters(version);
        }
        if (pV == null) {
            int i;
            for (i = 0; i < version.length() && !Character.isDigit(version.charAt(i)); ++i) {
            }
            if (i < version.length() && (pV = GenericVersion.collectVersion(version, i)) == null) {
                pV = Activation.rightSideDelimiters(version.substring(i));
            }
        }
        return pV;
    }

    public Activation setConditionsAND() {
        this.conditionsAND = true;
        return this;
    }

    public boolean getConditionsAND() {
        return this.conditionsAND;
    }

    public Activation setConditionsOR() {
        this.conditionsAND = false;
        return this;
    }

    public boolean getConditionsOR() {
        return !this.conditionsAND;
    }

    @Override
    public boolean isAvailable() {
        if (this.conditionsAND) {
            for (IActivation condition : this.conditions) {
                if (condition.isAvailable()) continue;
                return false;
            }
            return true;
        }
        for (IActivation condition : this.conditions) {
            if (!condition.isAvailable()) continue;
            return true;
        }
        return false;
    }

    public Activation neutralDescription(String neutralDescription) {
        this.neutralDescription = neutralDescription;
        return this;
    }

    @Override
    public String getNeutralDescription() {
        return this.neutralDescription;
    }

    public Activation pluginExist(final String pluginName) {
        this.conditions.add(new IActivation(){

            @Override
            public boolean isAvailable() {
                return Bukkit.getServer().getPluginManager().getPlugin(pluginName) != null;
            }
        });
        return this;
    }

    public Activation pluginEnabled(final String pluginName) {
        this.conditions.add(new IActivation(){

            @Override
            public boolean isAvailable() {
                return Bukkit.getServer().getPluginManager().isPluginEnabled(pluginName);
            }
        });
        return this;
    }

    public Activation pluginVersionGT(final String pluginName, final String version, final boolean allowEQ) {
        this.conditions.add(new IActivation(){

            @Override
            public boolean isAvailable() {
                String pluginVersion = Activation.guessUsablePluginVersion(pluginName);
                if (pluginVersion == null) {
                    return false;
                }
                int cmp = GenericVersion.compareVersions(pluginVersion, version);
                return cmp == 1 || allowEQ && cmp == 0;
            }
        });
        return this;
    }

    public Activation pluginVersionLT(final String pluginName, final String version, final boolean allowEQ) {
        this.conditions.add(new IActivation(){

            @Override
            public boolean isAvailable() {
                String pluginVersion = Activation.guessUsablePluginVersion(pluginName);
                if (pluginVersion == null) {
                    return false;
                }
                int cmp = GenericVersion.compareVersions(pluginVersion, version);
                return cmp == -1 || allowEQ && cmp == 0;
            }
        });
        return this;
    }

    public Activation pluginVersionEQ(final String pluginName, final String version) {
        this.conditions.add(new IActivation(){

            @Override
            public boolean isAvailable() {
                String pluginVersion = Activation.guessUsablePluginVersion(pluginName);
                if (pluginVersion == null) {
                    return false;
                }
                return GenericVersion.compareVersions(pluginVersion, version) == 0;
            }
        });
        return this;
    }

    public Activation pluginVersionBetween(final String pluginName, final String versionLow, final boolean allowEQlow, final String versionHigh, final boolean allowEQhigh) {
        this.conditions.add(new IActivation(){

            @Override
            public boolean isAvailable() {
                String pluginVersion = Activation.guessUsablePluginVersion(pluginName);
                if (pluginVersion == null) {
                    return false;
                }
                return GenericVersion.isVersionBetween(pluginVersion, versionLow, allowEQlow, versionHigh, allowEQhigh);
            }
        });
        return this;
    }

    public Activation minecraftVersionGT(final String version, final boolean allowEQ) {
        this.conditions.add(new IActivation(){

            @Override
            public boolean isAvailable() {
                int cmp = ServerVersion.compareMinecraftVersion(version);
                return cmp == 1 || allowEQ && cmp == 0;
            }
        });
        return this;
    }

    public Activation minecraftVersionLT(final String version, final boolean allowEQ) {
        this.conditions.add(new IActivation(){

            @Override
            public boolean isAvailable() {
                int cmp = ServerVersion.compareMinecraftVersion(version);
                return cmp == -1 || allowEQ && cmp == 0;
            }
        });
        return this;
    }

    public Activation minecraftVersionEQ(final String version) {
        this.conditions.add(new IActivation(){

            @Override
            public boolean isAvailable() {
                return ServerVersion.compareMinecraftVersion(version) == 0;
            }
        });
        return this;
    }

    public Activation minecraftVersionBetween(final String versionLow, final boolean allowEQlow, final String versionHigh, final boolean allowEQhigh) {
        this.conditions.add(new IActivation(){

            @Override
            public boolean isAvailable() {
                return ServerVersion.isMinecraftVersionBetween(versionLow, allowEQlow, versionHigh, allowEQhigh);
            }
        });
        return this;
    }

    public Activation serverVersionContains(final String content) {
        this.conditions.add(new IActivation(){

            @Override
            public boolean isAvailable() {
                return Bukkit.getServer().getVersion().contains(content);
            }
        });
        return this;
    }

    public Activation serverVersionContainsIgnoreCase(final String content) {
        this.conditions.add(new IActivation(){

            @Override
            public boolean isAvailable() {
                return Bukkit.getServer().getVersion().toLowerCase().contains(content.toLowerCase());
            }
        });
        return this;
    }

    public Activation classExist(final String className) {
        this.conditions.add(new IActivation(){

            @Override
            public boolean isAvailable() {
                return ReflectionUtil.getClass(className) != null;
            }
        });
        return this;
    }

    public Activation classNotExist(final String className) {
        this.conditions.add(new IActivation(){

            @Override
            public boolean isAvailable() {
                return ReflectionUtil.getClass(className) == null;
            }
        });
        return this;
    }

    public Activation advertise(boolean advertise) {
        this.advertise = advertise;
        return this;
    }

    @Override
    public boolean advertise() {
        return this.advertise;
    }

    public Activation condition(IActivation condition) {
        this.conditions.add(condition);
        return this;
    }

    private boolean checkUnitTest() {
        NoCheatPlusAPI api = NCPAPIProvider.getNoCheatPlusAPI();
        return api == null || api.getClass().getSimpleName().startsWith("UnitTest");
    }

    public Activation unitTest() {
        this.conditions.add(new IActivation(){

            @Override
            public boolean isAvailable() {
                return Activation.this.checkUnitTest();
            }
        });
        return this;
    }

    public Activation notUnitTest() {
        this.conditions.add(new IActivation(){

            @Override
            public boolean isAvailable() {
                return !Activation.this.checkUnitTest();
            }
        });
        return this;
    }
}

