/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.compat.spigotcb1_9_R2;

import fr.neatmonster.nocheatplus.utilities.map.BlockCache;
import java.util.List;
import net.minecraft.server.v1_9_R2.AxisAlignedBB;
import net.minecraft.server.v1_9_R2.Block;
import net.minecraft.server.v1_9_R2.BlockPosition;
import net.minecraft.server.v1_9_R2.EntityBoat;
import net.minecraft.server.v1_9_R2.EntityShulker;
import net.minecraft.server.v1_9_R2.WorldServer;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_9_R2.CraftWorld;
import org.bukkit.craftbukkit.v1_9_R2.entity.CraftEntity;
import org.bukkit.entity.Entity;

public class BlockCacheSpigotCB1_9_R2
extends BlockCache {
    protected WorldServer world;
    protected World bukkitWorld;

    public BlockCacheSpigotCB1_9_R2(World world) {
        this.setAccess(world);
    }

    @Override
    public BlockCache setAccess(World world) {
        if (world != null) {
            this.maxBlockY = world.getMaxHeight() - 1;
            this.world = ((CraftWorld)world).getHandle();
            this.bukkitWorld = world;
        } else {
            this.world = null;
            this.bukkitWorld = null;
        }
        return this;
    }

    @Override
    public Material fetchTypeId(int x, int y, int z) {
        return this.bukkitWorld.getBlockAt(x, y, z).getType();
    }

    @Override
    public int fetchData(int x, int y, int z) {
        return this.bukkitWorld.getBlockAt(x, y, z).getData();
    }

    @Override
    public double[] fetchBounds(int x, int y, int z) {
        int id = this.getType(x, y, z).getId();
        Block block = Block.getById((int)id);
        if (block == null) {
            return null;
        }
        BlockPosition pos = new BlockPosition(x, y, z);
        AxisAlignedBB bb = block.a(this.world.getType(pos), (net.minecraft.server.v1_9_R2.World)this.world, pos);
        if (bb == null) {
            return new double[]{0.0, 0.0, 0.0, 1.0, 1.0, 1.0};
        }
        return new double[]{bb.a, bb.b, bb.c, bb.d, bb.e, bb.f};
    }

    @Override
    public boolean standsOnEntity(Entity entity, double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        try {
            net.minecraft.server.v1_9_R2.Entity mcEntity = ((CraftEntity)entity).getHandle();
            AxisAlignedBB box = new AxisAlignedBB(minX, minY, minZ, maxX, maxY, maxZ);
            List list = this.world.getEntities(mcEntity, box);
            for (net.minecraft.server.v1_9_R2.Entity other : list) {
                if (mcEntity == other || !(other instanceof EntityBoat) && !(other instanceof EntityShulker)) continue;
                if (minY >= other.locY && minY - other.locY <= 0.7) {
                    return true;
                }
                AxisAlignedBB otherBox = other.getBoundingBox();
                if (box.a > otherBox.d || box.d < otherBox.a || box.b > otherBox.e || box.e < otherBox.b || box.c > otherBox.f || box.f < otherBox.c) continue;
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    @Override
    public void cleanup() {
        super.cleanup();
        this.world = null;
        this.bukkitWorld = null;
    }
}

