/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.compat.cb3026;

import fr.neatmonster.nocheatplus.utilities.map.BlockCache;
import java.util.List;
import net.minecraft.server.v1_7_R2.AxisAlignedBB;
import net.minecraft.server.v1_7_R2.Block;
import net.minecraft.server.v1_7_R2.Entity;
import net.minecraft.server.v1_7_R2.EntityBoat;
import net.minecraft.server.v1_7_R2.IBlockAccess;
import net.minecraft.server.v1_7_R2.TileEntity;
import net.minecraft.server.v1_7_R2.WorldServer;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_7_R2.CraftWorld;
import org.bukkit.craftbukkit.v1_7_R2.entity.CraftEntity;

public class BlockCacheCB3026
extends BlockCache {
    protected static final AxisAlignedBB useBox = AxisAlignedBB.a((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0);
    protected WorldServer world;
    protected World bukkitWorld;
    private final IBlockAccess iBlockAccess = new IBlockAccess(){

        public int getData(int x, int y, int z) {
            return BlockCacheCB3026.this.getData(x, y, z);
        }

        public TileEntity getTileEntity(int x, int y, int z) {
            return BlockCacheCB3026.this.world.getTileEntity(x, y, z);
        }

        public int getBlockPower(int arg0, int arg1, int arg2, int arg3) {
            return BlockCacheCB3026.this.world.getBlockPower(arg0, arg1, arg2, arg3);
        }

        public Block getType(int x, int y, int z) {
            return BlockCacheCB3026.this.world.getType(x, y, z);
        }
    };

    public BlockCacheCB3026(World world) {
        this.setAccess(world);
    }

    @Override
    public BlockCache setAccess(World world) {
        this.bukkitWorld = world;
        if (world != null) {
            this.maxBlockY = world.getMaxHeight() - 1;
            this.world = ((CraftWorld)world).getHandle();
        } else {
            this.world = null;
        }
        return this;
    }

    @Override
    public Material fetchTypeId(int x, int y, int z) {
        return this.bukkitWorld.getBlockAt(x, y, z).getType();
    }

    @Override
    public int fetchData(int x, int y, int z) {
        return this.world.getData(x, y, z);
    }

    @Override
    public double[] fetchBounds(int x, int y, int z) {
        int id = this.getType(x, y, z).getId();
        Block block = Block.e((int)id);
        if (block == null) {
            return null;
        }
        block.updateShape(this.iBlockAccess, x, y, z);
        return new double[]{block.x(), block.z(), block.B(), block.y(), block.A(), block.C()};
    }

    @Override
    public boolean standsOnEntity(org.bukkit.entity.Entity entity, double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        try {
            Entity mcEntity = ((CraftEntity)entity).getHandle();
            AxisAlignedBB box = useBox.b(minX, minY, minZ, maxX, maxY, maxZ);
            List list = this.world.getEntities(mcEntity, box);
            for (Entity other : list) {
                if (!(other instanceof EntityBoat)) continue;
                if (minY >= other.locY && minY - other.locY <= 0.7) {
                    return true;
                }
                AxisAlignedBB otherBox = other.boundingBox;
                if (box.a > otherBox.d || box.d < otherBox.a || box.b > otherBox.e || box.e < otherBox.b || box.c > otherBox.f || box.f < otherBox.c) continue;
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    @Override
    public void cleanup() {
        super.cleanup();
        this.world = null;
        this.bukkitWorld = null;
    }
}

