/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.compat.bukkit;

import fr.neatmonster.nocheatplus.utilities.map.BlockCache;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;

public class BlockCacheBukkit
extends BlockCache {
    protected World world;
    protected final Location useLoc = new Location(null, 0.0, 0.0, 0.0);

    public BlockCacheBukkit(World world) {
        this.setAccess(world);
    }

    @Override
    public BlockCache setAccess(World world) {
        this.world = world;
        if (world != null) {
            this.maxBlockY = world.getMaxHeight() - 1;
        }
        return this;
    }

    @Override
    public Material fetchTypeId(int x, int y, int z) {
        return this.world.getBlockAt(x, y, z).getType();
    }

    @Override
    public int fetchData(int x, int y, int z) {
        return this.world.getBlockAt(x, y, z).getData();
    }

    @Override
    public double[] fetchBounds(int x, int y, int z) {
        return new double[]{0.0, 0.0, 0.0, 1.0, 1.0, 1.0};
    }

    @Override
    public boolean standsOnEntity(Entity entity, double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        try {
            for (Entity other : entity.getNearbyEntities(2.0, 2.0, 2.0)) {
                EntityType type = other.getType();
                if (type != EntityType.BOAT) continue;
                double locY = entity.getLocation(this.useLoc).getY();
                this.useLoc.setWorld(null);
                return Math.abs(locY - minY) < 0.7;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    @Override
    public void cleanup() {
        super.cleanup();
        this.world = null;
    }
}

