/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.compat.blocks.init;

import fr.neatmonster.nocheatplus.utilities.map.BlockFlags;
import fr.neatmonster.nocheatplus.utilities.map.BlockProperties;
import org.bukkit.Material;

public class BlockInit {
    public static void assertMaterialExists(String id) {
        if (BlockProperties.getMaterial(id) == null) {
            throw new RuntimeException("Material " + id + " does not exist.");
        }
    }

    public static Material getMaterial(String name) {
        try {
            return Material.matchMaterial((String)name.toUpperCase());
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void setPropsAs(String newId, Material mat) {
        BlockProperties.setBlockProps(newId, BlockProperties.getBlockProps(mat));
    }

    public static void setPropsAs(String newId, String otherId) {
        BlockProperties.setBlockProps(newId, BlockProperties.getBlockProps(otherId));
    }

    public static void setAs(String newId, Material mat) {
        BlockFlags.setFlagsAs(newId, mat);
        BlockInit.setPropsAs(newId, mat);
    }

    public static void setAs(String newId, String otherId) {
        BlockFlags.setFlagsAs(newId, otherId);
        BlockInit.setPropsAs(newId, otherId);
    }

    public static void setInstantAir(String newId) {
        BlockFlags.setFlagsAs(newId, Material.AIR);
        BlockProperties.setBlockProps(newId, BlockProperties.instantType);
    }
}

