/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.compat.blocks.changetracker;

import fr.neatmonster.nocheatplus.NCPAPIProvider;
import fr.neatmonster.nocheatplus.compat.blocks.changetracker.BlockChangeTracker;
import fr.neatmonster.nocheatplus.components.NoCheatPlusAPI;
import fr.neatmonster.nocheatplus.components.registry.order.RegistrationOrder;
import fr.neatmonster.nocheatplus.event.mini.MiniListener;
import fr.neatmonster.nocheatplus.logging.Streams;
import fr.neatmonster.nocheatplus.utilities.ReflectionUtil;
import fr.neatmonster.nocheatplus.utilities.map.BlockProperties;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockFormEvent;
import org.bukkit.event.block.BlockPistonExtendEvent;
import org.bukkit.event.block.BlockPistonRetractEvent;
import org.bukkit.event.block.BlockRedstoneEvent;
import org.bukkit.event.entity.EntityChangeBlockEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.material.Directional;
import org.bukkit.material.Door;
import org.bukkit.material.MaterialData;

public class BlockChangeListener
implements Listener {
    public static long F_MOVABLE_IGNORE = 2L;
    public static long F_MOVABLE = 132L;
    private final BlockChangeTracker tracker;
    private final boolean retractHasBlocks;
    private boolean enabled = true;
    private final String defaultTag = "system.nocheatplus.blockchangetracker";
    private final MiniListener<?>[] miniListeners = new MiniListener[]{new MiniListener<BlockRedstoneEvent>(){

        @Override
        @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
        @RegistrationOrder.RegisterMethodWithOrder(tag="system.nocheatplus.blockchangetracker")
        public void onEvent(BlockRedstoneEvent event) {
            if (BlockChangeListener.this.enabled) {
                BlockChangeListener.this.onBlockRedstone(event);
            }
        }
    }, new MiniListener<EntityChangeBlockEvent>(){

        @Override
        @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
        @RegistrationOrder.RegisterMethodWithOrder(tag="system.nocheatplus.blockchangetracker")
        public void onEvent(EntityChangeBlockEvent event) {
            if (BlockChangeListener.this.enabled) {
                BlockChangeListener.this.onEntityChangeBlock(event);
            }
        }
    }, new MiniListener<BlockPistonExtendEvent>(){

        @Override
        @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
        @RegistrationOrder.RegisterMethodWithOrder(tag="system.nocheatplus.blockchangetracker")
        public void onEvent(BlockPistonExtendEvent event) {
            if (BlockChangeListener.this.enabled) {
                BlockChangeListener.this.onPistonExtend(event);
            }
        }
    }, new MiniListener<BlockPistonRetractEvent>(){

        @Override
        @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
        @RegistrationOrder.RegisterMethodWithOrder(tag="system.nocheatplus.blockchangetracker")
        public void onEvent(BlockPistonRetractEvent event) {
            if (BlockChangeListener.this.enabled) {
                BlockChangeListener.this.onPistonRetract(event);
            }
        }
    }, new MiniListener<PlayerInteractEvent>(){

        @Override
        @EventHandler(ignoreCancelled=false, priority=EventPriority.MONITOR)
        @RegistrationOrder.RegisterMethodWithOrder(tag="system.nocheatplus.blockchangetracker")
        public void onEvent(PlayerInteractEvent event) {
            if (BlockChangeListener.this.enabled) {
                BlockChangeListener.this.onPlayerInteract(event);
            }
        }
    }, new MiniListener<BlockFormEvent>(){

        @Override
        @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
        @RegistrationOrder.RegisterMethodWithOrder(tag="system.nocheatplus.blockchangetracker")
        public void onEvent(BlockFormEvent event) {
            if (BlockChangeListener.this.enabled) {
                BlockChangeListener.this.onBlockForm(event);
            }
        }
    }};

    public BlockChangeListener(BlockChangeTracker tracker) {
        this.tracker = tracker;
        if (ReflectionUtil.getMethodNoArgs(BlockPistonRetractEvent.class, "getBlocks", new Class[0]) == null) {
            this.retractHasBlocks = false;
            NCPAPIProvider.getNoCheatPlusAPI().getLogManager().info(Streams.STATUS, "Assume legacy piston behavior.");
        } else {
            this.retractHasBlocks = true;
        }
    }

    public void register() {
        NoCheatPlusAPI api = NCPAPIProvider.getNoCheatPlusAPI();
        for (MiniListener<?> listener : this.miniListeners) {
            api.addComponent(listener);
        }
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    private BlockFace getDirection(Block pistonBlock) {
        MaterialData data = pistonBlock.getState().getData();
        if (data instanceof Directional) {
            Directional directional = (Directional)data;
            return directional.getFacing();
        }
        return null;
    }

    private BlockFace getRetractDirection(Block pistonBlock, BlockFace eventDirection) {
        BlockFace pistonDirection = this.getDirection(pistonBlock);
        if (pistonDirection == null) {
            return eventDirection;
        }
        return eventDirection.getOppositeFace();
    }

    private void onPistonExtend(BlockPistonExtendEvent event) {
        BlockFace direction = event.getDirection();
        this.tracker.addPistonBlocks(event.getBlock().getRelative(direction), direction, event.getBlocks());
    }

    private void onPistonRetract(BlockPistonRetractEvent event) {
        ArrayList<Block> blocks;
        if (this.retractHasBlocks) {
            blocks = event.getBlocks();
        } else {
            Location retLoc = event.getRetractLocation();
            if (retLoc == null) {
                blocks = null;
            } else {
                Block retBlock = retLoc.getBlock();
                long flags = BlockProperties.getBlockFlags(retBlock.getType());
                if ((flags & F_MOVABLE_IGNORE) == 0L && (flags & F_MOVABLE) != 0L) {
                    blocks = new ArrayList<Block>(1);
                    blocks.add(retBlock);
                } else {
                    blocks = null;
                }
            }
        }
        Block pistonBlock = event.getBlock();
        BlockFace direction = this.getRetractDirection(pistonBlock, event.getDirection());
        this.tracker.addPistonBlocks(pistonBlock.getRelative(direction.getOppositeFace()), direction, (List<Block>)blocks);
    }

    private void onBlockRedstone(BlockRedstoneEvent event) {
        int newCurrent;
        int oldCurrent = event.getOldCurrent();
        if (oldCurrent == (newCurrent = event.getNewCurrent()) || oldCurrent > 0 && newCurrent > 0) {
            return;
        }
        Block block = event.getBlock();
        if (block == null || (BlockProperties.getBlockFlags(block.getType()) | 0x800000000L) == 0L) {
            return;
        }
        this.addRedstoneBlock(block);
    }

    private void addRedstoneBlock(Block block) {
        this.addBlockWithAttachedPotential(block, 0x800000000L);
    }

    private void onEntityChangeBlock(EntityChangeBlockEvent event) {
        Block block = event.getBlock();
        if (block != null) {
            this.tracker.addBlocks(block);
        }
    }

    private void onPlayerInteract(PlayerInteractEvent event) {
        Action action = event.getAction();
        if (action == Action.RIGHT_CLICK_BLOCK) {
            this.onRightClickBlock(event);
        } else if (!event.isCancelled() && action == Action.PHYSICAL) {
            this.onInteractPhysical(event);
        }
    }

    private void onInteractPhysical(PlayerInteractEvent event) {
        Material type;
        Block block = event.getClickedBlock();
        if (block != null && (type = block.getType()) == Material.SOIL) {
            this.tracker.addBlocks(block);
        }
    }

    private void onRightClickBlock(PlayerInteractEvent event) {
        Material type;
        Block block;
        Event.Result result = event.useInteractedBlock();
        if ((result == Event.Result.ALLOW || result == Event.Result.DEFAULT && !event.isCancelled()) && (block = event.getClickedBlock()) != null && (BlockProperties.getBlockFlags(type = block.getType()) | 0x400000000L) != 0L) {
            this.addBlockWithAttachedPotential(block, 0x400000000L);
        }
    }

    private void onBlockForm(BlockFormEvent event) {
        Block block = event.getBlock();
        if (block != null) {
            this.tracker.addBlocks(block);
        }
    }

    private void addBlockWithAttachedPotential(Block block, long relevantFlags) {
        Door door;
        Block otherBlock;
        MaterialData materialData = block.getState().getData();
        if (materialData instanceof Door && (otherBlock = block.getRelative((door = (Door)materialData).isTopHalf() ? BlockFace.DOWN : BlockFace.UP)) != null && (BlockProperties.getBlockFlags(otherBlock.getType()) | relevantFlags) == 0L) {
            this.tracker.addBlocks(block, otherBlock);
            return;
        }
        this.tracker.addBlocks(block);
    }
}

