/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.compat.blocks;

import fr.neatmonster.nocheatplus.NCPAPIProvider;
import fr.neatmonster.nocheatplus.components.location.IGetPosition;
import fr.neatmonster.nocheatplus.components.registry.event.IGenericInstanceHandle;
import fr.neatmonster.nocheatplus.logging.Streams;
import fr.neatmonster.nocheatplus.utilities.ReflectionUtil;
import fr.neatmonster.nocheatplus.utilities.TickTask;
import fr.neatmonster.nocheatplus.utilities.ds.map.CoordHashMap;
import fr.neatmonster.nocheatplus.utilities.ds.map.CoordMap;
import fr.neatmonster.nocheatplus.utilities.ds.map.LinkedCoordHashMap;
import fr.neatmonster.nocheatplus.utilities.location.RichBoundsLocation;
import fr.neatmonster.nocheatplus.utilities.map.BlockCache;
import fr.neatmonster.nocheatplus.utilities.map.BlockProperties;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockPistonExtendEvent;
import org.bukkit.event.block.BlockPistonRetractEvent;
import org.bukkit.event.block.BlockRedstoneEvent;
import org.bukkit.material.Directional;
import org.bukkit.material.Door;
import org.bukkit.material.MaterialData;

public class BlockChangeTracker {
    public static long F_MOVABLE_IGNORE = 2L;
    public static long F_MOVABLE = 132L;
    private long maxChangeId = 0L;
    private int expirationAgeTicks = 80;
    private int worldNodeSkipSize = 500;
    private int activityResolution = 32;
    private final Map<UUID, WorldNode> worldMap = new LinkedHashMap<UUID, WorldNode>();
    private final Set<Block> processBlocks = new LinkedHashSet<Block>();
    private IGenericInstanceHandle<BlockCache> blockCacheHandle = null;

    public void addPistonBlocks(Block pistonBlock, BlockFace blockFace, List<Block> movedBlocks) {
        this.checkProcessBlocks();
        int tick = TickTask.getTick();
        World world = pistonBlock.getWorld();
        WorldNode worldNode = this.getOrCreateWorldNode(world, tick);
        long changeId = ++this.maxChangeId;
        if (pistonBlock != null) {
            this.processBlocks.add(pistonBlock);
        }
        if (movedBlocks != null) {
            for (Block movedBlock : movedBlocks) {
                this.processBlocks.add(movedBlock);
                this.processBlocks.add(movedBlock.getRelative(blockFace));
            }
        }
        BlockCache blockCache = this.blockCacheHandle.getHandle();
        blockCache.setAccess(world);
        for (Block block : this.processBlocks) {
            this.addPistonBlock(changeId, tick, worldNode, block.getX(), block.getY(), block.getZ(), blockFace, blockCache);
        }
        blockCache.cleanup();
        this.processBlocks.clear();
    }

    private void addPistonBlock(long changeId, int tick, WorldNode worldNode, int x, int y, int z, BlockFace blockFace, BlockCache blockCache) {
        this.addBlockChange(changeId, tick, worldNode, x, y, z, Direction.getDirection(blockFace), blockCache.getOrCreateBlockCacheNode(x, y, z, true));
    }

    public void addBlocks(Block ... blocks) {
        if (blocks == null || blocks.length == 0) {
            return;
        }
        this.addBlocks(Arrays.asList(blocks));
    }

    public void addBlocks(Collection<Block> blocks) {
        if (blocks == null || blocks.isEmpty()) {
            return;
        }
        this.checkProcessBlocks();
        World world = null;
        for (Block block : blocks) {
            if (block == null) continue;
            if (world == null) {
                world = block.getWorld();
            }
            this.processBlocks.add(block);
        }
        if (world == null || !this.processBlocks.isEmpty()) {
            this.processBlocks.clear();
            return;
        }
        int tick = TickTask.getTick();
        WorldNode worldNode = this.getOrCreateWorldNode(world, tick);
        long changeId = ++this.maxChangeId;
        BlockCache blockCache = this.blockCacheHandle.getHandle();
        blockCache.setAccess(world);
        for (Block block : this.processBlocks) {
            this.addBlock(changeId, tick, worldNode, block.getX(), block.getY(), block.getZ(), blockCache);
        }
        blockCache.cleanup();
        this.processBlocks.clear();
    }

    private final void addBlock(long changeId, int tick, WorldNode worldNode, int x, int y, int z, BlockCache blockCache) {
        this.addBlockChange(changeId, tick, worldNode, x, y, z, Direction.NONE, blockCache.getOrCreateBlockCacheNode(x, y, z, true));
    }

    private final WorldNode getOrCreateWorldNode(World world, int tick) {
        UUID worldId = world.getUID();
        WorldNode worldNode = this.worldMap.get(worldId);
        if (worldNode == null) {
            worldNode = new WorldNode(worldId);
            this.worldMap.put(worldId, worldNode);
        }
        return worldNode;
    }

    private void addBlockChange(long changeId, int tick, WorldNode worldNode, int x, int y, int z, Direction direction, BlockCache.IBlockCacheNode previousState) {
        worldNode.lastChangeTick = tick;
        BlockChangeEntry entry = new BlockChangeEntry(changeId, tick, x, y, z, direction, previousState);
        LinkedList<BlockChangeEntry> entries = worldNode.blocks.get(x, y, z, LinkedCoordHashMap.MoveOrder.END);
        ActivityNode activityNode = worldNode.getActivityNode(x, y, z, this.activityResolution);
        if (entries == null) {
            entries = new LinkedList();
            worldNode.blocks.put(x, y, z, entries, LinkedCoordHashMap.MoveOrder.END);
        } else if (!entries.isEmpty()) {
            if (entries.getFirst().tick < tick - this.expirationAgeTicks) {
                int expired = this.expireEntries(tick - this.expirationAgeTicks, entries);
                worldNode.size -= expired;
                activityNode.count -= expired;
            }
            if (!entries.isEmpty()) {
                entries.getLast().nextEntryTick = tick;
            }
        }
        entries.add(entry);
        ++activityNode.count;
        ++worldNode.size;
    }

    private int expireEntries(int olderThanTick, LinkedList<BlockChangeEntry> entries) {
        int removed = 0;
        Iterator it = entries.iterator();
        while (it.hasNext()) {
            if (((BlockChangeEntry)it.next()).tick < olderThanTick) {
                it.remove();
                ++removed;
                continue;
            }
            return removed;
        }
        return removed;
    }

    public void checkExpiration(int currentTick) {
        int olderThanTick = currentTick - this.expirationAgeTicks;
        Iterator<Map.Entry<UUID, WorldNode>> it = this.worldMap.entrySet().iterator();
        while (it.hasNext()) {
            WorldNode worldNode = it.next().getValue();
            if (worldNode.lastChangeTick < olderThanTick) {
                worldNode.clear();
                it.remove();
                continue;
            }
            if (worldNode.size < this.worldNodeSkipSize) continue;
            Iterator blockIt = worldNode.blocks.iterator();
            while (blockIt.hasNext()) {
                CoordMap.Entry entry = (CoordMap.Entry)blockIt.next();
                LinkedList entries = (LinkedList)entry.getValue();
                ActivityNode activityNode = worldNode.getActivityNode(entry.getX(), entry.getY(), entry.getZ(), this.activityResolution);
                if (!entries.isEmpty() && ((BlockChangeEntry)entries.getFirst()).tick < olderThanTick) {
                    int expired = this.expireEntries(olderThanTick, entries);
                    worldNode.size -= expired;
                    activityNode.count -= expired;
                }
                if (!entries.isEmpty()) continue;
                blockIt.remove();
                if (activityNode.count > 0) continue;
                worldNode.removeActivityNode(entry.getX(), entry.getY(), entry.getZ(), this.activityResolution);
            }
            if (worldNode.size > 0) continue;
            it.remove();
        }
    }

    public BlockChangeEntry getBlockChangeEntry(BlockChangeReference ref, long tick, UUID worldId, int x, int y, int z, Direction direction) {
        WorldNode worldNode = this.worldMap.get(worldId);
        if (worldNode == null) {
            return null;
        }
        return this.getBlockChangeEntry(ref, tick, worldNode, x, y, z, direction);
    }

    private BlockChangeEntry getBlockChangeEntry(BlockChangeReference ref, long tick, WorldNode worldNode, int x, int y, int z, Direction direction) {
        long expireOlderThanTick = tick - (long)this.expirationAgeTicks;
        if ((long)worldNode.lastChangeTick < expireOlderThanTick) {
            worldNode.clear();
            this.worldMap.remove(worldNode.worldId);
            return null;
        }
        LinkedList entries = (LinkedList)worldNode.blocks.get(x, y, z);
        if (entries == null) {
            return null;
        }
        ActivityNode activityNode = worldNode.getActivityNode(x, y, z, this.activityResolution);
        Iterator it = entries.iterator();
        while (it.hasNext()) {
            BlockChangeEntry entry = (BlockChangeEntry)it.next();
            if ((long)entry.tick < expireOlderThanTick) {
                it.remove();
                --activityNode.count;
                continue;
            }
            if (ref != null && (!ref.canUpdateWith(entry) || direction != null && entry.direction != direction)) continue;
            return entry;
        }
        if (entries.isEmpty()) {
            worldNode.blocks.remove(x, y, z);
            if (worldNode.size == 0) {
                this.worldMap.remove(worldNode.worldId);
            } else if (activityNode.count <= 0) {
                worldNode.removeActivityNode(x, y, z, this.activityResolution);
            }
        }
        return null;
    }

    public boolean hasActivity(UUID worldId, IGetPosition pos1, IGetPosition pos2, double margin) {
        return this.hasActivity(worldId, pos1.getX(), pos1.getY(), pos1.getZ(), pos2.getX(), pos2.getY(), pos2.getZ());
    }

    public boolean hasActivity(UUID worldId, double x1, double y1, double z1, double x2, double y2, double z2) {
        return this.hasActivity(worldId, Location.locToBlock((double)x1), Location.locToBlock((double)y1), Location.locToBlock((double)z1), Location.locToBlock((double)x2), Location.locToBlock((double)y2), Location.locToBlock((double)z2));
    }

    public boolean hasActivity(UUID worldId, int x1, int y1, int z1, int x2, int y2, int z2) {
        WorldNode worldNode = this.worldMap.get(worldId);
        if (worldNode == null) {
            return false;
        }
        int minX = Math.min(x1, x2) / this.activityResolution;
        int minY = Math.min(y1, y2) / this.activityResolution;
        int minZ = Math.min(z1, z2) / this.activityResolution;
        int maxX = Math.max(x1, x2) / this.activityResolution;
        int maxY = Math.max(y1, y2) / this.activityResolution;
        int maxZ = Math.max(z1, z2) / this.activityResolution;
        for (int x = minX; x <= maxX; ++x) {
            for (int z = minZ; z <= maxZ; ++z) {
                for (int y = minY; y <= maxY; ++y) {
                    if (!worldNode.activityMap.contains(x, y, z)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public void clear() {
        for (WorldNode worldNode : this.worldMap.values()) {
            worldNode.clear();
        }
        this.worldMap.clear();
    }

    public int size() {
        int size = 0;
        for (WorldNode worldNode : this.worldMap.values()) {
            size += worldNode.size;
        }
        return size;
    }

    public int getExpirationAgeTicks() {
        return this.expirationAgeTicks;
    }

    public void setExpirationAgeTicks(int expirationAgeTicks) {
        this.expirationAgeTicks = expirationAgeTicks;
    }

    public int getWorldNodeSkipSize() {
        return this.worldNodeSkipSize;
    }

    public void setWorldNodeSkipSize(int worldNodeSkipSize) {
        this.worldNodeSkipSize = worldNodeSkipSize;
    }

    public void updateBlockCacheHandle() {
        if (this.blockCacheHandle != null) {
            this.blockCacheHandle.disableHandle();
        }
        this.blockCacheHandle = NCPAPIProvider.getNoCheatPlusAPI().getGenericInstanceHandle(BlockCache.class);
    }

    private void checkProcessBlocks() {
        if (!this.processBlocks.isEmpty()) {
            this.processBlocks.clear();
            NCPAPIProvider.getNoCheatPlusAPI().getLogManager().warning(Streams.STATUS, "BlockChangeTracker: processBlocks is not empty on starting to add blocks.");
        }
    }

    public static class BlockChangeListener
    implements Listener {
        private final BlockChangeTracker tracker;
        private final boolean retractHasBlocks;
        private boolean enabled = true;
        private final Set<Material> redstoneMaterials = new HashSet<Material>();

        public BlockChangeListener(BlockChangeTracker tracker) {
            this.tracker = tracker;
            if (ReflectionUtil.getMethodNoArgs(BlockPistonRetractEvent.class, "getBlocks", new Class[0]) == null) {
                this.retractHasBlocks = false;
                NCPAPIProvider.getNoCheatPlusAPI().getLogManager().info(Streams.STATUS, "Assume legacy piston behavior.");
            } else {
                this.retractHasBlocks = true;
            }
            for (Material material : Material.values()) {
                String name;
                if (!material.isBlock() || (name = material.name().toLowerCase()).indexOf("door") < 0 && name.indexOf("gate") < 0) continue;
                this.redstoneMaterials.add(material);
            }
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        private BlockFace getDirection(Block pistonBlock) {
            MaterialData data = pistonBlock.getState().getData();
            if (data instanceof Directional) {
                Directional directional = (Directional)data;
                return directional.getFacing();
            }
            return null;
        }

        private BlockFace getRetractDirection(Block pistonBlock, BlockFace eventDirection) {
            BlockFace pistonDirection = this.getDirection(pistonBlock);
            if (pistonDirection == null) {
                return eventDirection;
            }
            return eventDirection.getOppositeFace();
        }

        @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
        public void onPistonExtend(BlockPistonExtendEvent event) {
            if (!this.enabled) {
                return;
            }
            BlockFace direction = event.getDirection();
            this.tracker.addPistonBlocks(event.getBlock().getRelative(direction), direction, event.getBlocks());
        }

        @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
        public void onPistonRetract(BlockPistonRetractEvent event) {
            ArrayList<Block> blocks;
            if (!this.enabled) {
                return;
            }
            if (this.retractHasBlocks) {
                blocks = event.getBlocks();
            } else {
                Location retLoc = event.getRetractLocation();
                if (retLoc == null) {
                    blocks = null;
                } else {
                    Block retBlock = retLoc.getBlock();
                    long flags = BlockProperties.getBlockFlags(retBlock.getType());
                    if ((flags & F_MOVABLE_IGNORE) == 0L && (flags & F_MOVABLE) != 0L) {
                        blocks = new ArrayList<Block>(1);
                        blocks.add(retBlock);
                    } else {
                        blocks = null;
                    }
                }
            }
            Block pistonBlock = event.getBlock();
            BlockFace direction = this.getRetractDirection(pistonBlock, event.getDirection());
            this.tracker.addPistonBlocks(pistonBlock.getRelative(direction.getOppositeFace()), direction, (List<Block>)blocks);
        }

        @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
        public void onBlockRedstone(BlockRedstoneEvent event) {
            Door door;
            Block otherBlock;
            if (!this.enabled) {
                return;
            }
            Block block = event.getBlock();
            if (block == null || !this.redstoneMaterials.contains(block.getType())) {
                return;
            }
            MaterialData materialData = block.getState().getData();
            if (materialData instanceof Door && this.redstoneMaterials.contains((otherBlock = block.getRelative((door = (Door)materialData).isTopHalf() ? BlockFace.DOWN : BlockFace.UP)).getType())) {
                this.tracker.addBlocks(block, otherBlock);
                return;
            }
            this.tracker.addBlocks(block);
        }
    }

    public static class BlockChangeReference {
        public BlockChangeEntry firstSpanEntry = null;
        public BlockChangeEntry lastSpanEntry = null;
        public BlockChangeEntry lastUsedEntry = null;
        public boolean valid = false;

        public boolean canUpdateWith(BlockChangeEntry entry) {
            return this.lastUsedEntry == null || entry.tick > this.lastUsedEntry.tick || entry.tick == this.lastUsedEntry.tick && this.valid;
        }

        public void updateSpan(BlockChangeEntry entry) {
            if (this.firstSpanEntry == null || entry.id < this.firstSpanEntry.id) {
                this.firstSpanEntry = entry;
            }
            if (this.lastSpanEntry == null || entry.id > this.lastSpanEntry.id) {
                this.lastSpanEntry = entry;
            }
        }

        public void updateFinal(RichBoundsLocation to) {
            if (this.firstSpanEntry == null) {
                return;
            }
            if (this.lastSpanEntry != null && (this.lastUsedEntry == null || this.lastSpanEntry.id > this.lastUsedEntry.id)) {
                this.lastUsedEntry = this.lastSpanEntry;
                this.valid = to != null && to.isBlockIntersecting(this.lastSpanEntry.x, this.lastSpanEntry.y, this.lastSpanEntry.z);
            }
            this.lastSpanEntry = null;
            this.firstSpanEntry = null;
        }

        public BlockChangeReference copy() {
            BlockChangeReference copy = new BlockChangeReference();
            copy.firstSpanEntry = this.firstSpanEntry;
            copy.lastSpanEntry = this.lastSpanEntry;
            copy.lastUsedEntry = this.lastUsedEntry;
            copy.valid = this.valid;
            return copy;
        }

        public void clear() {
            this.lastUsedEntry = null;
            this.lastSpanEntry = null;
            this.firstSpanEntry = null;
            this.valid = false;
        }

        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof BlockChangeReference)) {
                return false;
            }
            BlockChangeReference other = (BlockChangeReference)obj;
            return this.valid == other.valid && (this.lastUsedEntry != null && this.lastUsedEntry.equals(other.lastUsedEntry) || this.lastUsedEntry == null && other.lastUsedEntry == null) && (this.firstSpanEntry != null && this.firstSpanEntry.equals(other.firstSpanEntry) || this.firstSpanEntry == null && other.firstSpanEntry == null) && (this.lastSpanEntry != null && this.lastSpanEntry.equals(other.lastSpanEntry) || this.lastSpanEntry == null && other.lastSpanEntry == null);
        }
    }

    public static class BlockChangeEntry {
        public final long id;
        public final int tick;
        public final int x;
        public final int y;
        public final int z;
        public final Direction direction;
        public final BlockCache.IBlockCacheNode previousState;
        public int nextEntryTick = -1;

        public BlockChangeEntry(long id, int tick, int x, int y, int z, Direction direction, BlockCache.IBlockCacheNode previousState) {
            this.id = id;
            this.tick = tick;
            this.x = x;
            this.y = y;
            this.z = z;
            this.direction = direction;
            this.previousState = previousState;
        }

        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof BlockChangeEntry)) {
                return false;
            }
            BlockChangeEntry other = (BlockChangeEntry)obj;
            return this.id == other.id && this.tick == other.tick && this.x == other.x && this.z == other.z && this.y == other.y && this.direction == other.direction;
        }
    }

    public static class WorldNode {
        public final CoordMap<ActivityNode> activityMap = new CoordHashMap<ActivityNode>();
        public final LinkedCoordHashMap<LinkedList<BlockChangeEntry>> blocks = new LinkedCoordHashMap();
        public int lastChangeTick = 0;
        public int size = 0;
        public final UUID worldId;

        public WorldNode(UUID worldId) {
            this.worldId = worldId;
        }

        public void clear() {
            this.activityMap.clear();
            this.blocks.clear();
            this.size = 0;
        }

        public ActivityNode getActivityNode(int x, int y, int z, int activityResolution) {
            ActivityNode node = this.activityMap.get(x /= activityResolution, y /= activityResolution, z /= activityResolution);
            if (node == null) {
                node = new ActivityNode();
                this.activityMap.put(x, y, z, node);
            }
            return node;
        }

        public void removeActivityNode(int x, int y, int z, int activityResolution) {
            this.activityMap.remove(x / activityResolution, y / activityResolution, z / activityResolution);
        }
    }

    public static class ActivityNode {
        public int count = 0;
    }

    public static enum Direction {
        NONE,
        X_POS,
        X_NEG,
        Y_POS,
        Y_NEG,
        Z_POS,
        Z_NEG;


        public static Direction getDirection(BlockFace blockFace) {
            int x = blockFace.getModX();
            if (x == 1) {
                return X_POS;
            }
            if (x == -1) {
                return X_NEG;
            }
            int y = blockFace.getModY();
            if (y == 1) {
                return Y_POS;
            }
            if (y == -1) {
                return Y_NEG;
            }
            int z = blockFace.getModZ();
            if (z == 1) {
                return Z_POS;
            }
            if (z == -1) {
                return Z_NEG;
            }
            return NONE;
        }
    }
}

