/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.compat;

import fr.neatmonster.nocheatplus.utilities.map.BlockProperties;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;

public final class BridgeEnchant {
    private static final Enchantment DEPTH_STRIDER = BridgeEnchant.parseEnchantment("DEPTH_STRIDER");
    private static final Enchantment THORNS = BridgeEnchant.parseEnchantment("THORNS");

    private static final Enchantment parseEnchantment(String name) {
        try {
            return Enchantment.getByName((String)name);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static int getMaxLevelArmor(Player player, Enchantment enchantment) {
        if (enchantment == null) {
            return 0;
        }
        int level = 0;
        ItemStack[] armor = player.getInventory().getArmorContents();
        for (int i = 0; i < armor.length; ++i) {
            ItemStack item = armor[i];
            if (BlockProperties.isAir(item)) continue;
            level = Math.max(item.getEnchantmentLevel(enchantment), level);
        }
        return level;
    }

    private static boolean hasArmor(Player player, Enchantment enchantment) {
        if (enchantment == null) {
            return false;
        }
        PlayerInventory inv = player.getInventory();
        ItemStack[] contents = inv.getArmorContents();
        for (int i = 0; i < contents.length; ++i) {
            ItemStack stack = contents[i];
            if (stack == null || stack.getEnchantmentLevel(enchantment) <= 0) continue;
            return true;
        }
        return false;
    }

    public static boolean hasThorns() {
        return THORNS != null;
    }

    public static boolean hasDepthStrider() {
        return DEPTH_STRIDER != null;
    }

    public static boolean hasThorns(Player player) {
        return BridgeEnchant.hasArmor(player, THORNS);
    }

    public static int getDepthStriderLevel(Player player) {
        return Math.min(3, BridgeEnchant.getMaxLevelArmor(player, DEPTH_STRIDER));
    }
}

