/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.command.admin.exemption;

import fr.neatmonster.nocheatplus.checks.CheckType;
import fr.neatmonster.nocheatplus.command.BaseCommand;
import fr.neatmonster.nocheatplus.hooks.NCPExemptionManager;
import fr.neatmonster.nocheatplus.permissions.Permissions;
import fr.neatmonster.nocheatplus.players.DataManager;
import fr.neatmonster.nocheatplus.utilities.StringUtil;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;

public class ExemptionsCommand
extends BaseCommand {
    public ExemptionsCommand(JavaPlugin plugin) {
        super(plugin, "exemptions", Permissions.COMMAND_EXEMPTIONS, new String[]{"exe"});
    }

    @Override
    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        UUID id;
        if (args.length != 2) {
            return false;
        }
        String playerName = args[1].trim();
        Player player = DataManager.getPlayer(playerName);
        if (player != null) {
            playerName = player.getName();
            id = player.getUniqueId();
        } else {
            id = DataManager.getUUID(playerName);
        }
        LinkedList<String> entries = new LinkedList<String>();
        if (id == null) {
            sender.sendMessage(TAG + "Not online nor a UUID: " + playerName);
            return true;
        }
        for (CheckType type : CheckType.values()) {
            if (!NCPExemptionManager.isExempted(id, type)) continue;
            entries.add(type.toString());
        }
        if (entries.isEmpty()) {
            sender.sendMessage(TAG + "No exemption entries available for " + playerName + " .");
        } else {
            sender.sendMessage(TAG + "Exemptions for " + playerName + ": " + StringUtil.join(entries, ", "));
        }
        return true;
    }

    @Override
    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        return null;
    }
}

