/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.checks.net.protocollib;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.events.ListenerPriority;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.events.PacketEvent;
import com.comphenix.protocol.reflect.StructureModifier;
import fr.neatmonster.nocheatplus.checks.CheckType;
import fr.neatmonster.nocheatplus.checks.net.NetConfig;
import fr.neatmonster.nocheatplus.checks.net.protocollib.BaseAdapter;
import fr.neatmonster.nocheatplus.compat.versions.ServerVersion;
import fr.neatmonster.nocheatplus.players.DataManager;
import fr.neatmonster.nocheatplus.players.IPlayerData;
import fr.neatmonster.nocheatplus.utilities.location.TrigUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.bukkit.Location;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class SoundDistance
extends BaseAdapter {
    private static final Set<String> effectNames = new HashSet<String>(Arrays.asList("ambient.weather.thunder", "wither-spawn-sound-radius", "mob.wither.spawn", "mob.wither.shoot", "mob.wither.idle", "mob.wither.hurt", "mob.wither.death", "dragon-death-sound-radius", "mob.enderdragon.wings", "mob.enderdragon.grow", "mob.enderdragon.growl", "mob.enderdragon.hit", "mob.enderdragon.end", "game.neutral.die", "ENTITY_LIGHTNING_IMPACT", "ENTITY_LIGHTNING_THUNDER", "ENTITY_ENDERDRAGON_AMBIENT", "ENTITY_ENDERDRAGON_DEATH", "ENTITY_ENDERDRAGON_FIREBALL_EXPLODE", "ENTITY_ENDERDRAGON_FLAP", "ENTITY_ENDERDRAGON_GROWL", "ENTITY_ENDERDRAGON_HURT", "ENTITY_ENDERDRAGON_SHOOT", "ENTITY_WITHER_AMBIENT", "ENTITY_WITHER_BREAK_BLOCK", "ENTITY_WITHER_DEATH", "ENTITY_WITHER_HURT", "ENTITY_WITHER_SHOOT", "ENTITY_WITHER_SPAWN"));
    private final Integer idSoundEffectCancel;
    private final Location useLoc;
    private final boolean pre1_9;

    public SoundDistance(Plugin plugin) {
        super(plugin, ListenerPriority.LOW, PacketType.Play.Server.NAMED_SOUND_EFFECT);
        this.idSoundEffectCancel = this.counters.registerKey("packet.sound.cancel");
        this.useLoc = new Location(null, 0.0, 0.0, 0.0);
        this.checkType = CheckType.NET_SOUNDDISTANCE;
        this.pre1_9 = ServerVersion.compareMinecraftVersion("1.9") < 0;
        this.inflateEffectNames();
    }

    private void inflateEffectNames() {
        ArrayList<String> names = new ArrayList<String>(effectNames);
        for (String name : names) {
            effectNames.add(name.toLowerCase());
            effectNames.add(name.toUpperCase());
        }
    }

    private boolean isSoundMonitoredPre1_9(PacketContainer packetContainer) {
        return effectNames.contains(packetContainer.getStrings().read(0));
    }

    private boolean isSoundMonitoredLatest(PacketContainer packetContainer) {
        StructureModifier sounds = packetContainer.getSoundEffects();
        for (Sound sound : sounds.getValues()) {
            if (!effectNames.contains(sound.name())) continue;
            return true;
        }
        return false;
    }

    private boolean isSoundMonitored(PacketContainer packetContainer) {
        if (this.pre1_9) {
            return this.isSoundMonitoredPre1_9(packetContainer);
        }
        return this.isSoundMonitoredLatest(packetContainer);
    }

    public void onPacketSending(PacketEvent event) {
        PacketContainer packetContainer = event.getPacket();
        if (!this.isSoundMonitored(packetContainer)) {
            return;
        }
        Player player = event.getPlayer();
        IPlayerData pData = DataManager.getPlayerData(player);
        if (!pData.isCheckActive(CheckType.NET_SOUNDDISTANCE, player)) {
            return;
        }
        Location loc = player.getLocation(this.useLoc);
        StructureModifier ints = packetContainer.getIntegers();
        double dSq = TrigUtil.distanceSquared((Integer)ints.read(0) / 8, (Integer)ints.read(2) / 8, loc.getX(), loc.getZ());
        NetConfig cc = pData.getGenericInstance(NetConfig.class);
        if (dSq > cc.soundDistanceSq) {
            event.setCancelled(true);
            this.counters.add(this.idSoundEffectCancel, 1);
        }
        this.useLoc.setWorld(null);
    }
}

