/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.checks.net.protocollib;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.ProtocolManager;
import com.comphenix.protocol.events.PacketAdapter;
import com.comphenix.protocol.events.PacketListener;
import fr.neatmonster.nocheatplus.NCPAPIProvider;
import fr.neatmonster.nocheatplus.checks.CheckType;
import fr.neatmonster.nocheatplus.checks.net.NetData;
import fr.neatmonster.nocheatplus.compat.versions.ServerVersion;
import fr.neatmonster.nocheatplus.components.NoCheatPlusAPI;
import fr.neatmonster.nocheatplus.components.registry.feature.IDisableListener;
import fr.neatmonster.nocheatplus.components.registry.feature.INotifyReload;
import fr.neatmonster.nocheatplus.components.registry.feature.JoinLeaveListener;
import fr.neatmonster.nocheatplus.config.ConfigManager;
import fr.neatmonster.nocheatplus.logging.StaticLog;
import fr.neatmonster.nocheatplus.logging.Streams;
import fr.neatmonster.nocheatplus.players.DataManager;
import fr.neatmonster.nocheatplus.players.IPlayerData;
import fr.neatmonster.nocheatplus.stats.Counters;
import fr.neatmonster.nocheatplus.utilities.StringUtil;
import fr.neatmonster.nocheatplus.worlds.IWorldDataManager;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.plugin.Plugin;

public class ProtocolLibComponent
implements IDisableListener,
INotifyReload,
JoinLeaveListener,
Listener {
    public static final int idNullPlayer = NCPAPIProvider.getNoCheatPlusAPI().getGenericInstance(Counters.class).registerKey("packet.nullplayer");
    public static final int idInconsistentIsAsync = NCPAPIProvider.getNoCheatPlusAPI().getGenericInstance(Counters.class).registerKey("packet.inconsistent.isasync");
    private final List<PacketAdapter> registeredPacketAdapters = new LinkedList<PacketAdapter>();

    public static PacketType findPacketTypeByName(PacketType.Protocol protocol, PacketType.Sender sender, String name) {
        try {
            return PacketType.findCurrent((PacketType.Protocol)protocol, (PacketType.Sender)sender, (String)name);
        }
        catch (Throwable t) {
            return null;
        }
    }

    public ProtocolLibComponent(Plugin plugin) {
        this.register(plugin);
    }

    private void register(Plugin plugin) {
        StaticLog.logInfo("Adding packet level hooks for ProtocolLib (MC " + ProtocolLibrary.getProtocolManager().getMinecraftVersion().getVersion() + ")...");
        IWorldDataManager worldMan = NCPAPIProvider.getNoCheatPlusAPI().getWorldDataManager();
        if (ConfigManager.isTrueForAnyConfig("checks.net.debug") || ConfigManager.isTrueForAnyConfig("checks.debug")) {
            this.register("fr.neatmonster.nocheatplus.checks.net.protocollib.DebugAdapter", plugin);
        }
        if (ServerVersion.compareMinecraftVersion("1.6.4") <= 0) {
            NCPAPIProvider.getNoCheatPlusAPI().getLogManager().info(Streams.STATUS, "Disable EntityUseAdapter due to incompatibilities. Use fight.speed instead of net.attackfrequency.");
        } else if (worldMan.isActiveAnywhere(CheckType.NET_ATTACKFREQUENCY)) {
            this.register("fr.neatmonster.nocheatplus.checks.net.protocollib.UseEntityAdapter", plugin);
        }
        if (worldMan.isActiveAnywhere(CheckType.NET_FLYINGFREQUENCY)) {
            this.register("fr.neatmonster.nocheatplus.checks.net.protocollib.MovingFlying", plugin);
            this.register("fr.neatmonster.nocheatplus.checks.net.protocollib.OutgoingPosition", plugin);
        }
        if (worldMan.isActiveAnywhere(CheckType.NET_KEEPALIVEFREQUENCY) || worldMan.isActiveAnywhere(CheckType.FIGHT_GODMODE)) {
            this.register("fr.neatmonster.nocheatplus.checks.net.protocollib.KeepAliveAdapter", plugin);
        }
        if (worldMan.isActiveAnywhere(CheckType.NET_SOUNDDISTANCE)) {
            this.register("fr.neatmonster.nocheatplus.checks.net.protocollib.SoundDistance", plugin);
        }
        if (ServerVersion.compareMinecraftVersion("1.9") < 0 && worldMan.isActiveAnywhere(CheckType.NET_PACKETFREQUENCY)) {
            this.register("fr.neatmonster.nocheatplus.checks.net.protocollib.CatchAllAdapter", plugin);
        }
        if (!this.registeredPacketAdapters.isEmpty()) {
            ArrayList<String> names = new ArrayList<String>(this.registeredPacketAdapters.size());
            for (PacketAdapter adapter : this.registeredPacketAdapters) {
                names.add(adapter.getClass().getSimpleName());
            }
            StaticLog.logInfo("Available (and activated) packet level hooks: " + StringUtil.join(names, " | "));
            NCPAPIProvider.getNoCheatPlusAPI().addFeatureTags("packet-listeners", names);
        } else {
            StaticLog.logInfo("No packet level hooks activated.");
        }
    }

    private void register(String name, Plugin plugin) {
        Exception t = null;
        try {
            Class<?> clazz = Class.forName(name);
            this.register(clazz, plugin);
            return;
        }
        catch (ClassNotFoundException e) {
            t = e;
        }
        catch (ClassCastException e) {
            t = e;
        }
        StaticLog.logWarning("Could not register packet level hook: " + name);
        StaticLog.logWarning(t);
    }

    private void register(Class<? extends PacketAdapter> clazz, Plugin plugin) {
        block2: {
            try {
                PacketAdapter adapter = clazz.getDeclaredConstructor(Plugin.class).newInstance(plugin);
                ProtocolLibrary.getProtocolManager().addPacketListener((PacketListener)adapter);
                this.registeredPacketAdapters.add(adapter);
            }
            catch (Throwable t) {
                StaticLog.logWarning("Could not register packet level hook: " + clazz.getSimpleName());
                StaticLog.logWarning(t);
                if (t.getCause() == null) break block2;
                StaticLog.logWarning(t.getCause());
            }
        }
    }

    @Override
    public void onDisable() {
        this.unregister();
    }

    @Override
    public void onReload() {
        this.unregister();
        NCPAPIProvider.getNoCheatPlusAPI().getPlayerDataManager().removeGenericInstance(NetData.class);
        this.register(Bukkit.getPluginManager().getPlugin("NoCheatPlus"));
    }

    private void unregister() {
        ProtocolManager protocolManager = ProtocolLibrary.getProtocolManager();
        NoCheatPlusAPI api = NCPAPIProvider.getNoCheatPlusAPI();
        for (PacketAdapter adapter : this.registeredPacketAdapters) {
            try {
                protocolManager.removePacketListener((PacketListener)adapter);
                api.removeComponent(adapter);
            }
            catch (Throwable t) {
                StaticLog.logWarning("Failed to unregister packet level hook: " + adapter.getClass().getName());
            }
        }
        this.registeredPacketAdapters.clear();
    }

    @Override
    public void playerJoins(Player player) {
        if (!this.registeredPacketAdapters.isEmpty()) {
            DataManager.getGenericInstance(player, NetData.class).onJoin(player);
        }
    }

    @Override
    public void playerLeaves(Player player) {
        if (!this.registeredPacketAdapters.isEmpty()) {
            DataManager.getGenericInstance(player, NetData.class).onLeave(player);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=false)
    public void onPlayerRespawn(PlayerRespawnEvent event) {
        if (!this.registeredPacketAdapters.isEmpty()) {
            Player player = event.getPlayer();
            NetData data = DataManager.getGenericInstance(player, NetData.class);
            data.onJoin(player);
            Location loc = event.getRespawnLocation();
            data.teleportQueue.onTeleportEvent(loc.getX(), loc.getY(), loc.getZ(), loc.getYaw(), loc.getPitch());
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onPlayerTeleport(PlayerTeleportEvent event) {
        if (!this.registeredPacketAdapters.isEmpty()) {
            Location to = event.getTo();
            if (to == null) {
                return;
            }
            Player player = event.getPlayer();
            IPlayerData pData = DataManager.getPlayerData(player);
            NetData data = pData.getGenericInstance(NetData.class);
            if (pData.isCheckActive(CheckType.NET_FLYINGFREQUENCY, player)) {
                data.teleportQueue.onTeleportEvent(to.getX(), to.getY(), to.getZ(), to.getYaw(), to.getPitch());
            }
            data.clearFlyingQueue();
        }
    }
}

