/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.checks.net.model;

import fr.neatmonster.nocheatplus.checks.net.model.CountableLocation;
import fr.neatmonster.nocheatplus.checks.net.model.DataLocation;
import fr.neatmonster.nocheatplus.checks.net.model.DataPacketFlying;
import fr.neatmonster.nocheatplus.compat.AlmostBoolean;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class TeleportQueue {
    private final Lock lock = new ReentrantLock();
    private final LinkedList<CountableLocation> expectIncoming = new LinkedList();
    private DataLocation expectOutgoing = null;
    private long maxAge = 4000L;
    private int maxQueueSize = 60;
    private CountableLocation lastAck = null;
    private AckReference lastAckReference = new AckReference();

    public long getMaxAge() {
        return this.maxAge;
    }

    public CountableLocation getLastAck() {
        return this.lastAck;
    }

    public AckReference getLastAckReference() {
        return this.lastAckReference;
    }

    public void onTeleportEvent(double x, double y, double z, float yaw, float pitch) {
        this.lock.lock();
        this.lastAck = null;
        this.expectOutgoing = new DataLocation(x, y, z, yaw, pitch);
        this.lock.unlock();
    }

    public CountableLocation onOutgoingTeleport(double x, double y, double z, float yaw, float pitch, int teleportId) {
        CountableLocation res = null;
        long time = System.currentTimeMillis();
        this.lock.lock();
        this.lastAckReference.lastOutgoingId = teleportId;
        if (this.lastAckReference.maxConfirmedId > this.lastAckReference.lastOutgoingId) {
            this.lastAckReference.maxConfirmedId = Integer.MIN_VALUE;
        }
        if (this.expectOutgoing != null) {
            if (this.expectOutgoing.isSameLocation(x, y, z, yaw, pitch)) {
                if (!this.expectIncoming.isEmpty()) {
                    CountableLocation last;
                    Iterator it = this.expectIncoming.iterator();
                    while (it.hasNext()) {
                        CountableLocation ref = (CountableLocation)it.next();
                        if (time < ref.time) {
                            ref.time = time;
                            continue;
                        }
                        if (time - this.maxAge <= ref.time) break;
                        it.remove();
                    }
                    if (!this.expectIncoming.isEmpty() && (last = this.expectIncoming.getLast()).isSameLocation(x, y, z, yaw, pitch)) {
                        last.time = time;
                        ++last.count;
                        last.teleportId = teleportId;
                        res = last;
                    }
                }
                if (res == null) {
                    res = new CountableLocation(x, y, z, yaw, pitch, 1, time, teleportId);
                    this.expectIncoming.addLast(res);
                    if (this.expectIncoming.size() > this.maxQueueSize) {
                        this.expectIncoming.removeFirst();
                    }
                }
            }
            this.expectOutgoing = null;
        }
        this.lock.unlock();
        return res;
    }

    public AlmostBoolean processAck(int teleportId) {
        if (teleportId == Integer.MIN_VALUE) {
            return AlmostBoolean.NO;
        }
        this.lock.lock();
        if (teleportId == this.lastAckReference.lastOutgoingId) {
            this.lastAckReference.maxConfirmedId = teleportId;
            this.expectIncoming.clear();
            this.lock.unlock();
            return AlmostBoolean.YES;
        }
        AlmostBoolean ackState = AlmostBoolean.NO;
        for (CountableLocation ref : this.expectIncoming) {
            if (ref.teleportId != teleportId) continue;
            while (ref != this.expectIncoming.getFirst()) {
                this.expectIncoming.removeFirst();
            }
            this.expectIncoming.removeFirst();
            ref.count = 0;
            ackState = AlmostBoolean.YES;
            break;
        }
        if (teleportId < this.lastAckReference.lastOutgoingId && teleportId > this.lastAckReference.maxConfirmedId) {
            this.lastAckReference.maxConfirmedId = teleportId;
            if (ackState == AlmostBoolean.NO) {
                ackState = AlmostBoolean.MAYBE;
            }
        } else {
            this.lastAckReference.maxConfirmedId = Integer.MIN_VALUE;
        }
        this.lock.unlock();
        return ackState;
    }

    public AckResolution processAck(DataPacketFlying packetData) {
        if (!packetData.hasPos || !packetData.hasLook) {
            return AckResolution.IDLE;
        }
        this.lock.lock();
        AckResolution res = this.expectIncoming.isEmpty() ? AckResolution.IDLE : this.getAckResolution(packetData);
        this.lock.unlock();
        return res;
    }

    private AckResolution getAckResolution(DataPacketFlying packetData) {
        Iterator it = this.expectIncoming.iterator();
        while (it.hasNext()) {
            CountableLocation ref = (CountableLocation)it.next();
            if (packetData.time - this.maxAge >= ref.time) {
                it.remove();
                continue;
            }
            if (packetData.isSameLocation(ref)) {
                while (ref != this.expectIncoming.getFirst()) {
                    this.expectIncoming.removeFirst();
                }
                if (--ref.count <= 0) {
                    this.expectIncoming.removeFirst();
                }
                this.lastAck = ref;
                return AckResolution.ACK;
            }
            if (packetData.time >= ref.time) continue;
            ref.time = packetData.time;
        }
        return this.expectIncoming.isEmpty() ? AckResolution.IDLE : AckResolution.WAITING;
    }

    public void clear() {
        this.lock.lock();
        this.expectIncoming.clear();
        this.expectOutgoing = null;
        this.lock.unlock();
    }

    public static class AckReference {
        public int lastOutgoingId = Integer.MIN_VALUE;
        public int maxConfirmedId = Integer.MIN_VALUE;
    }

    public static enum AckResolution {
        WAITING,
        ACK,
        IDLE;

    }
}

