/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.checks.net;

import fr.neatmonster.nocheatplus.actions.ActionList;
import fr.neatmonster.nocheatplus.checks.CheckType;
import fr.neatmonster.nocheatplus.checks.access.ACheckConfig;
import fr.neatmonster.nocheatplus.compat.AlmostBoolean;
import fr.neatmonster.nocheatplus.compat.versions.ServerVersion;
import fr.neatmonster.nocheatplus.components.config.value.OverrideType;
import fr.neatmonster.nocheatplus.config.ConfigFile;
import fr.neatmonster.nocheatplus.config.ConfigManager;
import fr.neatmonster.nocheatplus.permissions.Permissions;
import fr.neatmonster.nocheatplus.permissions.RegisteredPermission;
import fr.neatmonster.nocheatplus.worlds.IWorldData;

public class NetConfig
extends ACheckConfig {
    private static RegisteredPermission[] preferKeepUpdatedPermissions = new RegisteredPermission[]{Permissions.NET_ATTACKFREQUENCY, Permissions.NET_FLYINGFREQUENCY, Permissions.NET_KEEPALIVEFREQUENCY, Permissions.NET_PACKETFREQUENCY};
    public final float attackFrequencyLimitSecondsHalf;
    public final float attackFrequencyLimitSecondsOne;
    public final float attackFrequencyLimitSecondsTwo;
    public final float attackFrequencyLimitSecondsFour;
    public final float attackFrequencyLimitSecondsEight;
    public final ActionList attackFrequencyActions;
    public final int flyingFrequencySeconds;
    public final double flyingFrequencyPPS;
    public final ActionList flyingFrequencyActions;
    public final boolean flyingFrequencyRedundantActive;
    public final int flyingFrequencyRedundantSeconds;
    public final ActionList flyingFrequencyRedundantActions;
    public final ActionList keepAliveFrequencyActions;
    public final float packetFrequencyPacketsPerSecond;
    public final int packetFrequencySeconds;
    public final ActionList packetFrequencyActions;
    public final double soundDistanceSq;
    public final boolean supersededFlyingCancelWaiting;

    public static RegisteredPermission[] getPreferKeepUpdatedPermissions() {
        return preferKeepUpdatedPermissions;
    }

    public NetConfig(IWorldData worldData) {
        super(worldData);
        ConfigFile config = worldData.getRawConfiguration();
        ConfigFile globalConfig = ConfigManager.getConfigFile();
        this.attackFrequencyLimitSecondsHalf = config.getInt("checks.net.attackfrequency.limitforseconds.half");
        this.attackFrequencyLimitSecondsOne = config.getInt("checks.net.attackfrequency.limitforseconds.one");
        this.attackFrequencyLimitSecondsTwo = config.getInt("checks.net.attackfrequency.limitforseconds.two");
        this.attackFrequencyLimitSecondsFour = config.getInt("checks.net.attackfrequency.limitforseconds.four");
        this.attackFrequencyLimitSecondsEight = config.getInt("checks.net.attackfrequency.limitforseconds.eight");
        this.attackFrequencyActions = (ActionList)config.getOptimizedActionList("checks.net.attackfrequency.actions", Permissions.NET_ATTACKFREQUENCY);
        this.flyingFrequencySeconds = Math.max(1, globalConfig.getInt("checks.net.flyingfrequency.seconds"));
        this.flyingFrequencyPPS = Math.max(1.0, globalConfig.getDouble("checks.net.flyingfrequency.packetspersecond"));
        this.flyingFrequencyActions = (ActionList)config.getOptimizedActionList("checks.net.flyingfrequency.actions", Permissions.NET_FLYINGFREQUENCY);
        this.flyingFrequencyRedundantActive = config.getBoolean("checks.net.flyingfrequency.cancelredundant");
        this.flyingFrequencyRedundantSeconds = Math.max(1, config.getInt("checks.net.flyingfrequency.reduceredundant.seconds"));
        this.flyingFrequencyRedundantActions = (ActionList)config.getOptimizedActionList("checks.net.flyingfrequency.reduceredundant.actions", Permissions.NET_FLYINGFREQUENCY);
        this.keepAliveFrequencyActions = (ActionList)config.getOptimizedActionList("checks.net.keepalivefrequency.actions", Permissions.NET_KEEPALIVEFREQUENCY);
        if (ServerVersion.compareMinecraftVersion("1.9") >= 0) {
            worldData.overrideCheckActivation(CheckType.NET_PACKETFREQUENCY, AlmostBoolean.NO, OverrideType.PERMANENT, true);
        }
        this.packetFrequencyPacketsPerSecond = config.getInt("checks.net.packetfrequency.limitpersecond");
        this.packetFrequencySeconds = config.getInt("checks.net.packetfrequency.seconds");
        this.packetFrequencyActions = (ActionList)config.getOptimizedActionList("checks.net.packetfrequency.actions", Permissions.NET_PACKETFREQUENCY);
        double dist = config.getDouble("checks.net.sounddistance.maxdistance");
        this.soundDistanceSq = dist * dist;
        this.supersededFlyingCancelWaiting = config.getBoolean("checks.net.superseded.flying.cancelwaiting");
    }
}

