/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.checks.moving.player;

import fr.neatmonster.nocheatplus.NCPAPIProvider;
import fr.neatmonster.nocheatplus.actions.ParameterName;
import fr.neatmonster.nocheatplus.checks.Check;
import fr.neatmonster.nocheatplus.checks.CheckType;
import fr.neatmonster.nocheatplus.checks.ViolationData;
import fr.neatmonster.nocheatplus.checks.moving.MovingConfig;
import fr.neatmonster.nocheatplus.checks.moving.MovingData;
import fr.neatmonster.nocheatplus.compat.blocks.changetracker.BlockChangeTracker;
import fr.neatmonster.nocheatplus.components.location.IGetPosition;
import fr.neatmonster.nocheatplus.players.IPlayerData;
import fr.neatmonster.nocheatplus.utilities.collision.Axis;
import fr.neatmonster.nocheatplus.utilities.collision.ICollidePassable;
import fr.neatmonster.nocheatplus.utilities.collision.PassableAxisTracing;
import fr.neatmonster.nocheatplus.utilities.location.LocUtil;
import fr.neatmonster.nocheatplus.utilities.location.PlayerLocation;
import fr.neatmonster.nocheatplus.utilities.location.TrigUtil;
import fr.neatmonster.nocheatplus.utilities.map.BlockProperties;
import java.util.Arrays;
import java.util.Locale;
import org.bukkit.Location;
import org.bukkit.entity.Player;

public class Passable
extends Check {
    private static double rt_xzFactor = 0.98;
    private static double rt_heightFactor = 0.99999999;
    private final ICollidePassable rayTracing = new PassableAxisTracing();
    private final BlockChangeTracker blockTracker;

    public static boolean isPassable(Location from, Location to) {
        return BlockProperties.isPassableAxisWise(from, to);
    }

    public Passable() {
        super(CheckType.MOVING_PASSABLE);
        this.rayTracing.setMaxSteps(60);
        this.blockTracker = NCPAPIProvider.getNoCheatPlusAPI().getBlockChangeTracker();
    }

    public Location check(Player player, PlayerLocation from, PlayerLocation to, MovingData data, MovingConfig cc, IPlayerData pData, int tick, boolean useBlockChangeTracker) {
        return this.checkActual(player, from, to, data, cc, pData, tick, useBlockChangeTracker);
    }

    private Location checkActual(Player player, PlayerLocation from, PlayerLocation to, MovingData data, MovingConfig cc, IPlayerData pData, int tick, boolean useBlockChangeTracker) {
        boolean debug = pData.isDebugActive(this.type);
        int manhattan = from.manhattan(to);
        this.rayTracing.setAxisOrder(Axis.AXIS_ORDER_YXZ);
        String newTag = this.checkRayTracing(player, from, to, manhattan, data, cc, debug, tick, useBlockChangeTracker);
        if (newTag != null) {
            newTag = this.checkRayTracingAlernateOrder(player, from, to, manhattan, debug, data, cc, tick, useBlockChangeTracker, newTag);
        }
        if (newTag == null) {
            data.passableVL *= 0.99;
            return null;
        }
        return this.potentialViolation(player, from, to, manhattan, debug, newTag, data, cc);
    }

    private String checkRayTracingAlernateOrder(Player player, PlayerLocation from, PlayerLocation to, int manhattan, boolean debug, MovingData data, MovingConfig cc, int tick, boolean useBlockChangeTracker, String previousTag) {
        Axis axis = this.rayTracing.getCollidingAxis();
        if (axis == Axis.X_AXIS || axis == Axis.Z_AXIS) {
            this.rayTracing.setAxisOrder(Axis.AXIS_ORDER_YZX);
            return this.checkRayTracing(player, from, to, manhattan, data, cc, debug, tick, useBlockChangeTracker);
        }
        if (axis == Axis.Y_AXIS) {
            this.rayTracing.setAxisOrder(Axis.AXIS_ORDER_XZY);
            if (this.checkRayTracing(player, from, to, manhattan, data, cc, debug, tick, useBlockChangeTracker) == null) {
                return null;
            }
            this.rayTracing.setAxisOrder(Axis.AXIS_ORDER_ZXY);
            return this.checkRayTracing(player, from, to, manhattan, data, cc, debug, tick, useBlockChangeTracker);
        }
        return previousTag;
    }

    private String checkRayTracing(Player player, PlayerLocation from, PlayerLocation to, int manhattan, MovingData data, MovingConfig cc, boolean debug, int tick, boolean useBlockChangeTracker) {
        String tags = null;
        this.setNormalMargins(this.rayTracing, from);
        this.rayTracing.set(from, to);
        this.rayTracing.setIgnoreInitiallyColliding(true);
        if (useBlockChangeTracker) {
            this.rayTracing.setBlockChangeTracker(this.blockTracker, data.blockChangeRef, tick, from.getWorld().getUID());
        }
        this.rayTracing.loop();
        this.rayTracing.setIgnoreInitiallyColliding(false);
        if (this.rayTracing.collides()) {
            tags = "raytracing_collide_";
        } else if (this.rayTracing.getStepsDone() >= this.rayTracing.getMaxSteps()) {
            tags = "raytracing_maxsteps_";
        }
        if (debug) {
            this.debugExtraCollisionDetails(player, this.rayTracing, "std");
        }
        this.rayTracing.cleanup();
        return tags;
    }

    private void setNormalMargins(ICollidePassable rayTracing, PlayerLocation from) {
        rayTracing.setMargins(from.getBoxMarginVertical() * rt_heightFactor, from.getWidth() / 2.0 * rt_xzFactor);
    }

    private Location potentialViolation(Player player, PlayerLocation from, PlayerLocation to, int manhattan, boolean debug, String tags, MovingData data, MovingConfig cc) {
        return this.actualViolation(player, from, to, tags, debug, data, cc);
    }

    private Location actualViolation(Player player, PlayerLocation from, PlayerLocation to, String tags, boolean debug, MovingData data, MovingConfig cc) {
        Location setBackLoc = null;
        if (data.hasSetBack()) {
            setBackLoc = data.getSetBack(to);
            if (debug) {
                this.debug(player, "Using set back location for passable.");
            }
        }
        data.passableVL += 1.0;
        ViolationData vd = new ViolationData(this, player, data.passableVL, 1.0, cc.passableActions);
        if (debug || vd.needsParameters()) {
            vd.setParameter(ParameterName.LOCATION_FROM, String.format(Locale.US, "%.2f, %.2f, %.2f", from.getX(), from.getY(), from.getZ()));
            vd.setParameter(ParameterName.LOCATION_TO, String.format(Locale.US, "%.2f, %.2f, %.2f", to.getX(), to.getY(), to.getZ()));
            vd.setParameter(ParameterName.DISTANCE, String.format(Locale.US, "%.2f", TrigUtil.distance((IGetPosition)from, to)));
            if (!tags.isEmpty()) {
                vd.setParameter(ParameterName.TAGS, tags);
            }
        }
        if (this.executeActions(vd).willCancel()) {
            Location newTo;
            if (setBackLoc != null) {
                newTo = LocUtil.clone(setBackLoc);
            } else {
                newTo = from.getLocation();
                if (debug) {
                    this.debug(player, "Using from location for passable.");
                }
            }
            newTo.setYaw(to.getYaw());
            newTo.setPitch(to.getPitch());
            return newTo;
        }
        return null;
    }

    private void debugExtraCollisionDetails(Player player, ICollidePassable rayTracing, String tag) {
        if (rayTracing.collides()) {
            this.debug(player, "Raytracing collision with order " + Arrays.toString((Object[])rayTracing.getAxisOrder()) + " (" + tag + "): " + (Object)((Object)rayTracing.getCollidingAxis()));
        } else if (rayTracing.getStepsDone() >= rayTracing.getMaxSteps()) {
            this.debug(player, "Raytracing max steps exceeded (" + tag + "): " + (Object)((Object)rayTracing.getCollidingAxis()));
        }
    }
}

