/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.checks.inventory;

import fr.neatmonster.nocheatplus.actions.ActionList;
import fr.neatmonster.nocheatplus.checks.access.ACheckConfig;
import fr.neatmonster.nocheatplus.config.ConfigFile;
import fr.neatmonster.nocheatplus.permissions.Permissions;
import fr.neatmonster.nocheatplus.worlds.IWorldData;
import java.util.HashSet;
import java.util.Set;
import org.bukkit.Material;

public class InventoryConfig
extends ACheckConfig {
    public final int dropLimit;
    public final long dropTimeFrame;
    public final ActionList dropActions;
    public final boolean fastClickSpareCreative;
    public final boolean fastClickTweaks1_5;
    public final float fastClickShortTermLimit;
    public final float fastClickNormalLimit;
    public final ActionList fastClickActions;
    public final long fastConsumeDuration;
    public final boolean fastConsumeWhitelist;
    public final Set<Material> fastConsumeItems = new HashSet<Material>();
    public final ActionList fastConsumeActions;
    public final ActionList gutenbergActions;
    public final boolean instantBowStrict;
    public final long instantBowDelay;
    public final boolean instantBowImprobableFeedOnly;
    public final float instantBowImprobableWeight;
    public final ActionList instantBowActions;
    public final ActionList instantEatActions;
    public final boolean openClose;
    public final boolean openCancelOther;
    public final boolean hotFixFallingBlockEndPortalActive;

    public InventoryConfig(IWorldData worldData) {
        super(worldData);
        ConfigFile data = worldData.getRawConfiguration();
        this.dropLimit = data.getInt("checks.inventory.drop.limit");
        this.dropTimeFrame = data.getLong("checks.inventory.drop.timeframe");
        this.dropActions = (ActionList)data.getOptimizedActionList("checks.inventory.drop.actions", Permissions.INVENTORY_DROP);
        this.fastClickSpareCreative = data.getBoolean("checks.inventory.fastclick.sparecreative");
        this.fastClickTweaks1_5 = data.getBoolean("checks.inventory.fastclick.tweaks1_5");
        this.fastClickShortTermLimit = (float)data.getDouble("checks.inventory.fastclick.limit.shortterm");
        this.fastClickNormalLimit = (float)data.getDouble("checks.inventory.fastclick.limit.normal");
        this.fastClickActions = (ActionList)data.getOptimizedActionList("checks.inventory.fastclick.actions", Permissions.INVENTORY_FASTCLICK);
        this.fastConsumeDuration = (long)(1000.0 * data.getDouble("checks.inventory.fastconsume.duration"));
        this.fastConsumeWhitelist = data.getBoolean("checks.inventory.fastconsume.whitelist");
        data.readMaterialFromList("checks.inventory.fastconsume.items", this.fastConsumeItems);
        this.fastConsumeActions = (ActionList)data.getOptimizedActionList("checks.inventory.fastconsume.actions", Permissions.INVENTORY_FASTCONSUME);
        this.gutenbergActions = (ActionList)data.getOptimizedActionList("checks.inventory.gutenberg.actions", Permissions.INVENTORY_GUTENBERG);
        this.instantBowStrict = data.getBoolean("checks.inventory.instantbow.strict");
        this.instantBowDelay = data.getInt("checks.inventory.instantbow.delay");
        this.instantBowImprobableFeedOnly = data.getBoolean("checks.inventory.instantbow.improbable.feedonly");
        this.instantBowImprobableWeight = (float)data.getDouble("checks.inventory.instantbow.improbable.weight");
        this.instantBowActions = (ActionList)data.getOptimizedActionList("checks.inventory.instantbow.actions", Permissions.INVENTORY_INSTANTBOW);
        this.instantEatActions = (ActionList)data.getOptimizedActionList("checks.inventory.instanteat.actions", Permissions.INVENTORY_INSTANTEAT);
        this.openClose = data.getBoolean("checks.inventory.open.close");
        this.openCancelOther = data.getBoolean("checks.inventory.open.cancelother");
        this.hotFixFallingBlockEndPortalActive = data.getBoolean("checks.inventory.hotfix.duplication.fallingblockendportal");
    }
}

