/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.checks.inventory;

import fr.neatmonster.nocheatplus.actions.ParameterName;
import fr.neatmonster.nocheatplus.checks.Check;
import fr.neatmonster.nocheatplus.checks.CheckType;
import fr.neatmonster.nocheatplus.checks.ViolationData;
import fr.neatmonster.nocheatplus.checks.inventory.InventoryConfig;
import fr.neatmonster.nocheatplus.checks.inventory.InventoryData;
import fr.neatmonster.nocheatplus.players.DataManager;
import fr.neatmonster.nocheatplus.players.IPlayerData;
import org.bukkit.entity.Player;

public class InstantEat
extends Check {
    public InstantEat() {
        super(CheckType.INVENTORY_INSTANTEAT);
    }

    public boolean check(Player player, int level) {
        long time = System.currentTimeMillis();
        IPlayerData pData = DataManager.getPlayerData(player);
        InventoryData data = pData.getGenericInstance(InventoryData.class);
        boolean cancel = false;
        if (data.instantEatFood == null || level <= player.getFoodLevel()) {
            return false;
        }
        long expectedTimeWhenEatingFinished = Math.max(data.instantEatInteract, data.lastClickTime) + 700L;
        if (data.instantEatInteract > 0L && expectedTimeWhenEatingFinished < time) {
            data.instantEatVL *= 0.6;
        } else if (data.instantEatInteract <= time) {
            double difference = (double)(expectedTimeWhenEatingFinished - time) / 100.0;
            data.instantEatVL += difference;
            ViolationData vd = new ViolationData(this, player, data.instantEatVL, difference, pData.getGenericInstance(InventoryConfig.class).instantEatActions);
            if (data.instantEatFood != null) {
                vd.setParameter(ParameterName.FOOD, data.instantEatFood.toString());
            }
            cancel = this.executeActions(vd).willCancel();
        }
        data.instantEatInteract = 0L;
        data.instantEatFood = null;
        return cancel;
    }
}

