/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.checks.inventory;

import fr.neatmonster.nocheatplus.NCPAPIProvider;
import fr.neatmonster.nocheatplus.actions.ParameterName;
import fr.neatmonster.nocheatplus.checks.Check;
import fr.neatmonster.nocheatplus.checks.CheckType;
import fr.neatmonster.nocheatplus.checks.ViolationData;
import fr.neatmonster.nocheatplus.checks.inventory.InventoryConfig;
import fr.neatmonster.nocheatplus.checks.inventory.InventoryData;
import fr.neatmonster.nocheatplus.compat.AlmostBoolean;
import fr.neatmonster.nocheatplus.compat.BridgeHealth;
import fr.neatmonster.nocheatplus.components.config.value.OverrideType;
import fr.neatmonster.nocheatplus.components.registry.feature.INotifyReload;
import fr.neatmonster.nocheatplus.logging.StaticLog;
import fr.neatmonster.nocheatplus.players.DataManager;
import fr.neatmonster.nocheatplus.players.IPlayerData;
import fr.neatmonster.nocheatplus.stats.Counters;
import fr.neatmonster.nocheatplus.utilities.InventoryUtil;
import fr.neatmonster.nocheatplus.utilities.TickTask;
import org.bukkit.Material;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerItemConsumeEvent;
import org.bukkit.inventory.ItemStack;

public class FastConsume
extends Check
implements Listener,
INotifyReload {
    private final Counters counters = NCPAPIProvider.getNoCheatPlusAPI().getGenericInstance(Counters.class);
    private final int idCancelDead = this.counters.registerKey("cancel.dead");

    public static void testAvailability() {
        if (!PlayerItemConsumeEvent.class.getSimpleName().equals("PlayerItemConsumeEvent")) {
            throw new RuntimeException("This exception should not even get thrown.");
        }
    }

    public FastConsume() {
        super(CheckType.INVENTORY_FASTCONSUME);
        this.disableInstantEat();
    }

    private void disableInstantEat() {
        NCPAPIProvider.getNoCheatPlusAPI().getWorldDataManager().overrideCheckActivation(CheckType.INVENTORY_INSTANTEAT, AlmostBoolean.NO, OverrideType.PERMANENT, true);
        StaticLog.logInfo("Inventory checks: FastConsume is available, disabled InstantEat.");
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onItemConsume(PlayerItemConsumeEvent event) {
        Player player = event.getPlayer();
        if (player.isDead() && BridgeHealth.getHealth((LivingEntity)player) <= 0.0) {
            event.setCancelled(true);
            this.counters.addPrimaryThread(this.idCancelDead, 1);
            return;
        }
        IPlayerData pData = DataManager.getPlayerData(player);
        if (!pData.isCheckActive(this.type, player)) {
            return;
        }
        InventoryData data = pData.getGenericInstance(InventoryData.class);
        long time = System.currentTimeMillis();
        if (this.check(player, event.getItem(), time, data, pData)) {
            event.setCancelled(true);
            DataManager.getPlayerData(player).requestUpdateInventory();
        }
    }

    private boolean check(Player player, ItemStack stack, long time, InventoryData data, IPlayerData pData) {
        Material mat;
        long ref;
        if (stack == null) {
            return false;
        }
        long l = ref = data.instantEatInteract == 0L ? 0L : Math.max(data.instantEatInteract, data.lastClickTime);
        if (time < ref) {
            data.instantEatInteract = data.lastClickTime = time;
            return false;
        }
        InventoryConfig cc = pData.getGenericInstance(InventoryConfig.class);
        Material material = mat = stack == null ? null : stack.getType();
        if (mat != null && (cc.fastConsumeWhitelist ? !cc.fastConsumeItems.contains(mat) : cc.fastConsumeItems.contains(mat))) {
            return false;
        }
        long timeSpent = ref == 0L ? 0L : time - ref;
        long expectedDuration = cc.fastConsumeDuration;
        boolean cancel = false;
        if (timeSpent < expectedDuration) {
            float lag = TickTask.getLag(expectedDuration, true);
            if ((float)timeSpent * lag < (float)expectedDuration) {
                double difference = (double)((float)expectedDuration - (float)timeSpent * lag) / 100.0;
                data.instantEatVL += difference;
                ViolationData vd = new ViolationData(this, player, data.instantEatVL, difference, cc.fastConsumeActions);
                vd.setParameter(ParameterName.FOOD, "" + mat);
                if (data.instantEatFood != mat) {
                    vd.setParameter(ParameterName.TAGS, "inconsistent(" + data.instantEatFood + ")");
                } else {
                    vd.setParameter(ParameterName.TAGS, "");
                }
                if (this.executeActions(vd).willCancel()) {
                    cancel = true;
                }
            }
        } else {
            data.instantEatVL *= 0.6;
        }
        if (cancel) {
            ItemStack actualStack = InventoryUtil.getFirstConsumableItemInHand(player);
            data.instantEatFood = actualStack == null ? null : actualStack.getType();
        } else {
            if (pData.isDebugActive(this.type)) {
                this.debug(player, "PlayerItemConsumeEvent, reset fastconsume: " + data.instantEatFood);
            }
            data.instantEatFood = null;
        }
        data.instantEatInteract = time;
        return cancel;
    }

    @Override
    public void onReload() {
        this.disableInstantEat();
    }
}

