/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.checks.generic.block;

import fr.neatmonster.nocheatplus.actions.ActionList;
import fr.neatmonster.nocheatplus.checks.Check;
import fr.neatmonster.nocheatplus.checks.CheckType;
import fr.neatmonster.nocheatplus.checks.net.FlyingQueueHandle;
import fr.neatmonster.nocheatplus.checks.net.FlyingQueueLookBlockChecker;
import fr.neatmonster.nocheatplus.components.config.ICheckConfig;
import fr.neatmonster.nocheatplus.components.data.ICheckData;
import fr.neatmonster.nocheatplus.players.IPlayerData;
import fr.neatmonster.nocheatplus.utilities.collision.CollideRayVsAABB;
import fr.neatmonster.nocheatplus.utilities.collision.ICollideRayVsAABB;
import fr.neatmonster.nocheatplus.utilities.location.LocUtil;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;

public abstract class AbstractBlockDirectionCheck<D extends ICheckData, C extends ICheckConfig>
extends Check {
    private final ICollideRayVsAABB boulder = new CollideRayVsAABB();
    private final Location useLoc = new Location(null, 0.0, 0.0, 0.0);
    private final BoulderChecker checker = new BoulderChecker();

    public AbstractBlockDirectionCheck(CheckType checkType) {
        super(checkType);
    }

    protected abstract double addVL(Player var1, double var2, D var4, C var5);

    protected abstract ActionList getActions(C var1);

    protected abstract void cooldown(Player var1, D var2, C var3);

    public boolean check(Player player, Location loc, double eyeHeight, Block block, FlyingQueueHandle flyingHandle, D data, C cc, IPlayerData pData) {
        boolean cancel = false;
        double x = loc.getX();
        double y = loc.getY() + eyeHeight;
        double z = loc.getZ();
        int blockX = block.getX();
        int blockY = block.getY();
        int blockZ = block.getZ();
        double distance = this.checker.checkFlyingQueue(x, y, z, loc.getYaw(), loc.getPitch(), blockX, blockY, blockZ, flyingHandle) ? Double.MAX_VALUE : this.checker.getMinDistance();
        if (distance != Double.MAX_VALUE) {
            distance = Math.sqrt(distance);
            if (pData.isDebugActive(this.type)) {
                this.outputDebugFail(player, this.boulder, distance);
            }
            double vl = this.addVL(player, distance, data, cc);
            cancel = this.executeActions(player, vl, distance, this.getActions(cc)).willCancel();
        } else {
            this.cooldown(player, data, cc);
        }
        return cancel;
    }

    private double checkBoulder(double x, double y, double z, float yaw, float pitch, int blockX, int blockY, int blockZ) {
        this.useLoc.setYaw(yaw);
        this.useLoc.setPitch(pitch);
        Vector dir = this.useLoc.getDirection();
        double dirX = dir.getX();
        double dirY = dir.getY();
        double dirZ = dir.getZ();
        this.boulder.setFindNearestPointIfNotCollide(true).setRay(x, y, z, dirX, dirY, dirZ).setAABB(blockX, blockY, blockZ, 0.1).loop();
        if (this.boulder.collides()) {
            return Double.MAX_VALUE;
        }
        return this.boulder.getClosestDistanceSquared();
    }

    private void outputDebugFail(Player player, ICollideRayVsAABB boulder, double distance) {
        this.debug(player, "Failed: collides: " + boulder.collides() + " , dist: " + distance + " , pos: " + LocUtil.simpleFormat(boulder));
    }

    private final class BoulderChecker
    extends FlyingQueueLookBlockChecker {
        private double minDistance;

        private BoulderChecker() {
        }

        @Override
        protected boolean check(double x, double y, double z, float yaw, float pitch, int blockX, int blockY, int blockZ) {
            double distance = AbstractBlockDirectionCheck.this.checkBoulder(x, y, z, yaw, pitch, blockX, blockY, blockZ);
            if (distance == Double.MAX_VALUE) {
                return true;
            }
            this.minDistance = Math.min(this.minDistance, distance);
            return false;
        }

        @Override
        public boolean checkFlyingQueue(double x, double y, double z, float oldYaw, float oldPitch, int blockX, int blockY, int blockZ, FlyingQueueHandle flyingHandle) {
            this.minDistance = Double.MAX_VALUE;
            return super.checkFlyingQueue(x, y, z, oldYaw, oldPitch, blockX, blockY, blockZ, flyingHandle);
        }

        public double getMinDistance() {
            return this.minDistance;
        }
    }
}

