/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.checks.fight;

import fr.neatmonster.nocheatplus.actions.ActionList;
import fr.neatmonster.nocheatplus.checks.CheckType;
import fr.neatmonster.nocheatplus.checks.access.ACheckConfig;
import fr.neatmonster.nocheatplus.compat.AlmostBoolean;
import fr.neatmonster.nocheatplus.compat.versions.Bugs;
import fr.neatmonster.nocheatplus.compat.versions.ServerVersion;
import fr.neatmonster.nocheatplus.components.config.value.OverrideType;
import fr.neatmonster.nocheatplus.config.ConfigFile;
import fr.neatmonster.nocheatplus.permissions.Permissions;
import fr.neatmonster.nocheatplus.worlds.IWorldData;

public class FightConfig
extends ACheckConfig {
    public final double angleThreshold;
    public final ActionList angleActions;
    public final long toolChangeAttackPenalty;
    public final double criticalFallDistance;
    public final ActionList criticalActions;
    public final boolean directionStrict;
    public final long directionPenalty;
    public final ActionList directionActions;
    public final long fastHealInterval;
    public final long fastHealBuffer;
    public final ActionList fastHealActions;
    public final long godModeLagMinAge;
    public final long godModeLagMaxAge;
    public final ActionList godModeActions;
    public final ActionList noSwingActions;
    public final long reachPenalty;
    public final boolean reachPrecision;
    public final boolean reachReduce;
    public final double reachSurvivalDistance;
    public final double reachReduceDistance;
    public final double reachReduceStep;
    public final ActionList reachActions;
    public final ActionList selfHitActions;
    public final int speedLimit;
    public final int speedBuckets;
    public final long speedBucketDur;
    public final float speedBucketFactor;
    public final int speedShortTermLimit;
    public final int speedShortTermTicks;
    public final ActionList speedActions;
    public final ActionList wrongTurnActions;
    public final boolean cancelDead;
    public final boolean knockBackVelocityPvP;
    public final long loopMaxLatencyTicks = 15L;

    public FightConfig(IWorldData worldData) {
        super(worldData);
        ConfigFile config = worldData.getRawConfiguration();
        this.angleThreshold = config.getDouble("checks.fight.angle.threshold");
        this.angleActions = (ActionList)config.getOptimizedActionList("checks.fight.angle.actions", Permissions.FIGHT_ANGLE);
        this.toolChangeAttackPenalty = config.getLong("checks.fight.toolchangepenalty");
        this.criticalFallDistance = config.getDouble("checks.fight.critical.falldistance");
        this.criticalActions = (ActionList)config.getOptimizedActionList("checks.fight.critical.actions", Permissions.FIGHT_CRITICAL);
        this.directionStrict = config.getBoolean("checks.fight.direction.strict");
        this.directionPenalty = config.getLong("checks.fight.direction.penalty");
        this.directionActions = (ActionList)config.getOptimizedActionList("checks.fight.direction.actions", Permissions.FIGHT_DIRECTION);
        if (ServerVersion.compareMinecraftVersion("1.9") >= 0) {
            worldData.overrideCheckActivation(CheckType.FIGHT_FASTHEAL, AlmostBoolean.NO, OverrideType.PERMANENT, true);
        }
        this.fastHealInterval = config.getLong("checks.fight.fastheal.interval");
        this.fastHealBuffer = config.getLong("checks.fight.fastheal.buffer");
        this.fastHealActions = (ActionList)config.getOptimizedActionList("checks.fight.fastheal.actions", Permissions.FIGHT_FASTHEAL);
        this.godModeLagMinAge = config.getLong("checks.fight.godmode.minage");
        this.godModeLagMaxAge = config.getLong("checks.fight.godmode.maxage");
        this.godModeActions = (ActionList)config.getOptimizedActionList("checks.fight.godmode.actions", Permissions.FIGHT_GODMODE);
        this.noSwingActions = (ActionList)config.getOptimizedActionList("checks.fight.noswing.actions", Permissions.FIGHT_NOSWING);
        this.reachSurvivalDistance = config.getDouble("checks.fight.reach.survivaldistance", 3.5, 6.0, 4.4);
        this.reachPenalty = config.getLong("checks.fight.reach.penalty");
        this.reachPrecision = config.getBoolean("checks.fight.reach.precision");
        this.reachReduce = config.getBoolean("checks.fight.reach.reduce");
        this.reachReduceDistance = config.getDouble("checks.fight.reach.reducedistance", 0.0, this.reachSurvivalDistance, 0.9);
        this.reachReduceStep = config.getDouble("checks.fight.reach.reducestep", 0.0, this.reachReduceDistance, 0.15);
        this.reachActions = (ActionList)config.getOptimizedActionList("checks.fight.reach.actions", Permissions.FIGHT_REACH);
        this.selfHitActions = (ActionList)config.getOptimizedActionList("checks.fight.selfhit.actions", Permissions.FIGHT_SELFHIT);
        this.speedLimit = config.getInt("checks.fight.speed.limit");
        this.speedBuckets = config.getInt("checks.fight.speed.buckets.number", 6);
        this.speedBucketDur = config.getLong("checks.fight.speed.buckets.duration", 333L);
        this.speedBucketFactor = (float)config.getDouble("checks.fight.speed.buckets.factor", 1.0);
        this.speedShortTermLimit = config.getInt("checks.fight.speed.shortterm.limit");
        this.speedShortTermTicks = config.getInt("checks.fight.speed.shortterm.ticks");
        this.speedActions = (ActionList)config.getOptimizedActionList("checks.fight.speed.actions", Permissions.FIGHT_SPEED);
        this.wrongTurnActions = (ActionList)config.getOptimizedActionList("checks.fight.wrongturn.actions", CheckType.FIGHT_WRONGTURN.getPermission());
        this.cancelDead = config.getBoolean("checks.fight.canceldead");
        AlmostBoolean ref = config.getAlmostBoolean("checks.fight.pvp.knockbackvelocity", AlmostBoolean.MAYBE);
        this.knockBackVelocityPvP = ref == AlmostBoolean.MAYBE ? Bugs.shouldPvpKnockBackVelocity() : ref.decide();
    }
}

