/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.checks.combined;

import fr.neatmonster.nocheatplus.actions.ParameterName;
import fr.neatmonster.nocheatplus.checks.Check;
import fr.neatmonster.nocheatplus.checks.CheckType;
import fr.neatmonster.nocheatplus.checks.ViolationData;
import fr.neatmonster.nocheatplus.checks.combined.CombinedConfig;
import fr.neatmonster.nocheatplus.checks.combined.CombinedData;
import fr.neatmonster.nocheatplus.components.registry.feature.IDisableListener;
import fr.neatmonster.nocheatplus.players.DataManager;
import fr.neatmonster.nocheatplus.players.IPlayerData;
import fr.neatmonster.nocheatplus.utilities.TickTask;
import org.bukkit.entity.Player;

public class Improbable
extends Check
implements IDisableListener {
    private static Improbable instance = null;

    public static final boolean check(Player player, float weight, long now, String tags, IPlayerData pData) {
        return instance.checkImprobable(player, weight, now, tags, pData);
    }

    public static final void feed(Player player, float weight, long now, IPlayerData pData) {
        pData.getGenericInstance(CombinedData.class).improbableCount.add(now, weight);
    }

    public static void feed(Player player, float weight, long now) {
        Improbable.feed(player, weight, now, DataManager.getPlayerData(player));
    }

    public Improbable() {
        super(CheckType.COMBINED_IMPROBABLE);
        instance = this;
    }

    private boolean checkImprobable(Player player, float weight, long now, String tags, IPlayerData pData) {
        double full;
        if (!pData.isCheckActive(this.type, player)) {
            return false;
        }
        CombinedData data = pData.getGenericInstance(CombinedData.class);
        CombinedConfig cc = pData.getGenericInstance(CombinedConfig.class);
        data.improbableCount.add(now, weight);
        float shortTerm = data.improbableCount.bucketScore(0);
        double violation = 0.0;
        boolean violated = false;
        if ((double)(shortTerm * 0.8f) > (double)cc.improbableLevel / 20.0) {
            float lag;
            float f = lag = pData.getCurrentWorldData().shouldAdjustToLag(this.type) ? TickTask.getLag(data.improbableCount.bucketDuration(), true) : 1.0f;
            if ((double)(shortTerm / lag) > (double)cc.improbableLevel / 20.0) {
                violation += (double)shortTerm * 2.0 / (double)lag;
                violated = true;
            }
        }
        if ((full = (double)data.improbableCount.score(1.0f)) > (double)cc.improbableLevel) {
            float lag;
            float f = lag = pData.getCurrentWorldData().shouldAdjustToLag(this.type) ? TickTask.getLag(data.improbableCount.bucketDuration() * (long)data.improbableCount.numberOfBuckets(), true) : 1.0f;
            if (full / (double)lag > (double)cc.improbableLevel) {
                violation += full / (double)lag;
                violated = true;
            }
        }
        boolean cancel = false;
        if (violated) {
            data.improbableVL += violation / 10.0;
            ViolationData vd = new ViolationData(this, player, data.improbableVL, violation, cc.improbableActions);
            if (tags != null && !tags.isEmpty()) {
                vd.setParameter(ParameterName.TAGS, tags);
            }
            cancel = this.executeActions(vd).willCancel();
        } else {
            data.improbableVL *= 0.95;
        }
        return cancel;
    }

    @Override
    public void onDisable() {
        instance = null;
    }
}

