/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.checks.blockplace;

import fr.neatmonster.nocheatplus.actions.ActionList;
import fr.neatmonster.nocheatplus.checks.access.ACheckConfig;
import fr.neatmonster.nocheatplus.config.ConfigFile;
import fr.neatmonster.nocheatplus.permissions.Permissions;
import fr.neatmonster.nocheatplus.worlds.IWorldData;
import java.util.HashSet;
import java.util.Set;
import org.bukkit.Material;

public class BlockPlaceConfig
extends ACheckConfig {
    public final ActionList againstActions;
    public final boolean autoSignSkipEmpty;
    public final ActionList autoSignActions;
    public final ActionList directionActions;
    public final int fastPlaceLimit;
    public final int fastPlaceShortTermTicks;
    public final int fastPlaceShortTermLimit;
    public final ActionList fastPlaceActions;
    public final Set<Material> noSwingExceptions = new HashSet<Material>();
    public final ActionList noSwingActions;
    public final ActionList reachActions;
    public final long speedInterval;
    public final ActionList speedActions;
    public final boolean preventBoatsAnywhere;

    public BlockPlaceConfig(IWorldData worldData) {
        super(worldData);
        ConfigFile config = worldData.getRawConfiguration();
        this.againstActions = (ActionList)config.getOptimizedActionList("checks.blockplace.against.actions", Permissions.BLOCKPLACE_AGAINST);
        this.autoSignSkipEmpty = config.getBoolean("checks.blockplace.autosign.skipempty");
        this.autoSignActions = (ActionList)config.getOptimizedActionList("checks.blockplace.autosign.actions", Permissions.BLOCKPLACE_AUTOSIGN);
        this.directionActions = (ActionList)config.getOptimizedActionList("checks.blockplace.direction.actions", Permissions.BLOCKPLACE_DIRECTION);
        this.fastPlaceLimit = config.getInt("checks.blockplace.fastplace.limit");
        this.fastPlaceShortTermTicks = config.getInt("checks.blockplace.fastplace.shortterm.ticks");
        this.fastPlaceShortTermLimit = config.getInt("checks.blockplace.fastplace.shortterm.limit");
        this.fastPlaceActions = (ActionList)config.getOptimizedActionList("checks.blockplace.fastplace.actions", Permissions.BLOCKPLACE_FASTPLACE);
        config.readMaterialFromList("checks.blockplace.noswing.exceptions", this.noSwingExceptions);
        this.noSwingActions = (ActionList)config.getOptimizedActionList("checks.blockplace.noswing.actions", Permissions.BLOCKPLACE_NOSWING);
        this.reachActions = (ActionList)config.getOptimizedActionList("checks.blockplace.reach.actions", Permissions.BLOCKPLACE_REACH);
        this.speedInterval = config.getLong("checks.blockplace.speed.interval");
        this.speedActions = (ActionList)config.getOptimizedActionList("checks.blockplace.speed.actions", Permissions.BLOCKPLACE_SPEED);
        this.preventBoatsAnywhere = config.getBoolean("checks.blockplace.preventmisc.boatsanywhere");
    }
}

