/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.checks.blockbreak;

import fr.neatmonster.nocheatplus.checks.access.ACheckData;
import fr.neatmonster.nocheatplus.checks.blockbreak.BlockBreakConfig;
import fr.neatmonster.nocheatplus.components.data.IDataOnReload;
import fr.neatmonster.nocheatplus.components.registry.IGetGenericInstance;
import fr.neatmonster.nocheatplus.stats.Timings;
import fr.neatmonster.nocheatplus.utilities.ds.count.ActionFrequency;
import fr.neatmonster.nocheatplus.utilities.map.BlockProperties;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.inventory.ItemStack;

public class BlockBreakData
extends ACheckData
implements IDataOnReload {
    public double directionVL;
    public double fastBreakVL;
    public double frequencyVL;
    public double noSwingVL;
    public double reachVL;
    public final ActionFrequency wrongBlockVL;
    public int clickedX = Integer.MAX_VALUE;
    public int clickedY;
    public int clickedZ;
    public int clickedTick;
    public Material clickedTool = null;
    public long wasInstaBreak;
    public Timings stats;
    public final ActionFrequency fastBreakPenalties;
    public long fastBreakBreakTime = System.currentTimeMillis() - 1000L;
    public long fastBreakfirstDamage = System.currentTimeMillis();
    public final ActionFrequency frequencyBuckets;
    public int frequencyShortTermCount;
    public int frequencyShortTermTick;
    public boolean noSwingArmSwung = true;
    public double reachDistance;

    public BlockBreakData(BlockBreakConfig cc) {
        this.setStats();
        this.fastBreakPenalties = new ActionFrequency(cc.fastBreakBuckets, cc.fastBreakBucketDur);
        this.frequencyBuckets = new ActionFrequency(cc.frequencyBuckets, cc.frequencyBucketDur);
        this.wrongBlockVL = new ActionFrequency(6, 20000L);
    }

    void setStats() {
        if (this.stats == null) {
            this.stats = new Timings("NCP/FASTBREAK");
        }
    }

    public void setClickedBlock(Block block, int tick, long now, Material tool) {
        this.fastBreakfirstDamage = now;
        this.clickedX = block.getX();
        this.clickedY = block.getY();
        this.clickedZ = block.getZ();
        this.clickedTick = tick;
        this.clickedTool = tool == Material.AIR ? null : tool;
    }

    public void resetClickedBlock() {
        this.clickedX = Integer.MAX_VALUE;
        this.clickedTick = 0;
        this.fastBreakfirstDamage = 0L;
        this.clickedTool = null;
    }

    public boolean toolChanged(ItemStack stack) {
        return this.toolChanged(stack == null ? null : stack.getType());
    }

    public boolean toolChanged(Material mat) {
        if (BlockProperties.isAir(mat)) {
            return !BlockProperties.isAir(this.clickedTool);
        }
        return this.clickedTool != mat;
    }

    @Override
    public boolean dataOnReload(IGetGenericInstance dataAccess) {
        return true;
    }
}

