/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.checks.blockbreak;

import fr.neatmonster.nocheatplus.actions.ActionList;
import fr.neatmonster.nocheatplus.checks.access.ACheckConfig;
import fr.neatmonster.nocheatplus.config.ConfigFile;
import fr.neatmonster.nocheatplus.permissions.Permissions;
import fr.neatmonster.nocheatplus.worlds.IWorldData;

public class BlockBreakConfig
extends ACheckConfig {
    public final ActionList directionActions;
    public final boolean fastBreakStrict;
    public final int fastBreakBuckets;
    public final long fastBreakBucketDur;
    public final float fastBreakBucketFactor;
    public final long fastBreakGrace;
    public final long fastBreakDelay;
    public final int fastBreakModSurvival;
    public final ActionList fastBreakActions;
    public final int frequencyBuckets;
    public final long frequencyBucketDur;
    public final float frequencyBucketFactor;
    public final int frequencyIntervalCreative;
    public final int frequencyIntervalSurvival;
    public final int frequencyShortTermLimit;
    public final int frequencyShortTermTicks;
    public final ActionList frequencyActions;
    public boolean improbableFastBreakCheck;
    public final ActionList noSwingActions;
    public final ActionList reachActions;
    public final float wrongBLockLevel;
    public final ActionList wrongBlockActions;

    public BlockBreakConfig(IWorldData worldData) {
        super(worldData);
        ConfigFile config = worldData.getRawConfiguration();
        this.directionActions = (ActionList)config.getOptimizedActionList("checks.blockbreak.direction.actions", Permissions.BLOCKBREAK_DIRECTION);
        this.fastBreakStrict = config.getBoolean("checks.blockbreak.fastbreak.strict");
        this.fastBreakDelay = config.getLong("checks.blockbreak.fastbreak.delay");
        this.fastBreakGrace = config.getLong("checks.blockbreak.buckets.contention", config.getLong("checks.blockbreak.fastbreak.grace", 2000L));
        this.fastBreakBucketDur = config.getInt("checks.blockbreak.buckets.duration", 4000);
        this.fastBreakBucketFactor = (float)config.getDouble("checks.blockbreak.buckets.factor", 0.99);
        this.fastBreakBuckets = config.getInt("checks.blockbreak.buckets.number", 30);
        this.fastBreakModSurvival = config.getInt("checks.blockbreak.fastbreak.intervalsurvival");
        this.fastBreakActions = (ActionList)config.getOptimizedActionList("checks.blockbreak.fastbreak.actions", Permissions.BLOCKBREAK_FASTBREAK);
        this.frequencyBuckets = config.getInt("checks.blockbreak.frequency.buckets.number", 2);
        this.frequencyBucketDur = config.getLong("checks.blockbreak.frequency.buckets.duration", 1000L);
        this.frequencyBucketFactor = (float)config.getDouble("checks.blockbreak.frequency.buckets.factor", 1.0);
        this.frequencyIntervalCreative = config.getInt("checks.blockbreak.frequency.intervalcreative");
        this.frequencyIntervalSurvival = config.getInt("checks.blockbreak.frequency.intervalsurvival");
        this.frequencyShortTermLimit = config.getInt("checks.blockbreak.frequency.shortterm.limit");
        this.frequencyShortTermTicks = config.getInt("checks.blockbreak.frequency.shortterm.ticks");
        this.frequencyActions = (ActionList)config.getOptimizedActionList("checks.blockbreak.frequency.actions", Permissions.BLOCKBREAK_FREQUENCY);
        this.noSwingActions = (ActionList)config.getOptimizedActionList("checks.blockbreak.noswing.actions", Permissions.BLOCKBREAK_NOSWING);
        this.reachActions = (ActionList)config.getOptimizedActionList("checks.blockbreak.reach.actions", Permissions.BLOCKBREAK_REACH);
        this.wrongBLockLevel = config.getInt("checks.blockbreak.wrongblock.level");
        this.wrongBlockActions = (ActionList)config.getOptimizedActionList("checks.blockbreak.wrongblock.actions", Permissions.BLOCKBREAK_WRONGBLOCK);
    }
}

