/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.utilities.map;

import fr.neatmonster.nocheatplus.logging.debug.DebugUtil;
import fr.neatmonster.nocheatplus.utilities.ds.map.CoordHashMap;
import fr.neatmonster.nocheatplus.utilities.ds.map.CoordMap;
import fr.neatmonster.nocheatplus.utilities.map.BlockCache;
import fr.neatmonster.nocheatplus.utilities.map.MapUtil;
import java.util.Iterator;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.entity.Entity;

public class FakeBlockCache
extends BlockCache {
    private final CoordMap<Material> idMapStored = new CoordHashMap<Material>(23);
    private final CoordMap<Integer> dataMapStored = new CoordHashMap<Integer>(23);
    private final CoordMap<double[]> boundsMapStored = new CoordHashMap<double[]>(23);

    public void set(BlockCache other, double x0, double y0, double z0, double x1, double y1, double z1, double margin) {
        this.set(other, Location.locToBlock((double)(Math.min(x0, x1) - margin)), Location.locToBlock((double)(Math.min(y0, y1) - margin)), Location.locToBlock((double)(Math.min(z0, z1) - margin)), Location.locToBlock((double)(Math.max(x0, x1) + margin)), Location.locToBlock((double)(Math.max(y0, y1) + margin)), Location.locToBlock((double)(Math.max(z0, z1) + margin)));
    }

    public void set(BlockCache other, int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    this.set(x, y, z, other.getType(x, y, z), other.getData(x, y, z), other.getBounds(x, y, z));
                }
            }
        }
    }

    public void set(int x, int y, int z, Material type) {
        this.set(x, y, z, type, 0);
    }

    public void set(int x, int y, int z, Material type, double[] bounds) {
        this.set(x, y, z, type, 0, bounds);
    }

    public void set(int x, int y, int z, Material typeId, int data) {
        this.set(x, y, z, typeId, data, new double[]{0.0, 0.0, 0.0, 1.0, 1.0, 1.0});
    }

    public void set(int x, int y, int z, Material typeId, int data, double[] bounds) {
        this.idMapStored.put(x, y, z, typeId);
        this.dataMapStored.put(x, y, z, data);
        if (bounds == null) {
            this.boundsMapStored.remove(x, y, z);
        } else {
            this.boundsMapStored.put(x, y, z, bounds);
        }
    }

    public void fill(int x1, int y1, int z1, int x2, int y2, int z2, Material type) {
        this.fill(x1, y1, z1, x2, y2, z2, type, 0, new double[]{0.0, 0.0, 0.0, 1.0, 1.0, 1.0});
    }

    public void fill(int x1, int y1, int z1, int x2, int y2, int z2, Material typeId, int data, double[] bounds) {
        for (int x = x1; x <= x2; ++x) {
            for (int y = y1; y <= y2; ++y) {
                for (int z = z1; z <= z2; ++z) {
                    this.set(x, y, z, typeId, data, bounds);
                }
            }
        }
    }

    public void walls(int x1, int y1, int z1, int x2, int y2, int z2, Material type) {
        this.walls(x1, y1, z1, x2, y2, z2, type, 0, new double[]{0.0, 0.0, 0.0, 1.0, 1.0, 1.0});
    }

    public void walls(int x1, int y1, int z1, int x2, int y2, int z2, Material typeId, int data, double[] bounds) {
        for (int x = x1; x <= x2; ++x) {
            for (int y = y1; y <= y2; ++y) {
                for (int z = z1; z <= z2; ++z) {
                    if (x != x1 && x != x2 && z != z1 && z != z2) continue;
                    this.set(x, y, z, typeId, data, bounds);
                }
            }
        }
    }

    public void room(int x1, int y1, int z1, int x2, int y2, int z2, Material type) {
        this.room(x1, y1, z1, x2, y2, z2, type, 0, new double[]{0.0, 0.0, 0.0, 1.0, 1.0, 1.0});
    }

    public void room(int x1, int y1, int z1, int x2, int y2, int z2, Material typeId, int data, double[] bounds) {
        for (int x = x1; x <= x2; ++x) {
            for (int y = y1; y <= y2; ++y) {
                for (int z = z1; z <= z2; ++z) {
                    if (x != x1 && x != x2 && z != z1 && z != z2 && y != y1 && y != y2) continue;
                    this.set(x, y, z, typeId, data, bounds);
                }
            }
        }
    }

    public boolean hasIdEntry(int x, int y, int z) {
        return this.idMapStored.contains(x, y, z);
    }

    public void toJava(StringBuilder builder, String fbcName, String boundsPrefix) {
        String fullBounds;
        builder.append("FakeBlockCache " + fbcName + " = new FakeBlockCache();");
        if (boundsPrefix != null) {
            fullBounds = boundsPrefix + "_fb";
            builder.append(" double[] " + fullBounds + " = new double[]{0.0, 0.0, 0.0, 1.0, 1.0, 1.0};");
        } else {
            fullBounds = null;
        }
        Iterator<CoordMap.Entry<Material>> it = this.idMapStored.iterator();
        while (it.hasNext()) {
            CoordMap.Entry<Material> entry = it.next();
            int x = entry.getX();
            int y = entry.getY();
            int z = entry.getZ();
            Material id = entry.getValue();
            if (id == Material.AIR) {
                builder.append(fbcName + ".set(" + x + ", " + y + ", " + z + ", " + id + ");");
                continue;
            }
            Integer data = this.dataMapStored.get(x, y, z);
            double[] bounds = this.boundsMapStored.get(x, y, z);
            if (bounds == null) {
                if (data == null) {
                    builder.append(fbcName + ".set(" + x + ", " + y + ", " + z + ", " + id + ");");
                    continue;
                }
                builder.append(fbcName + ".set(" + x + ", " + y + ", " + z + ", " + id + ", " + data + ");");
                continue;
            }
            if (boundsPrefix != null && MapUtil.isFullBounds(bounds)) {
                builder.append(fbcName + ".set(" + x + ", " + y + ", " + z + ", " + id + ", " + data + ", " + fullBounds + ");");
                continue;
            }
            builder.append(fbcName + ".set(" + x + ", " + y + ", " + z + ", " + id + ", " + data + ", ");
            DebugUtil.toJava(bounds, builder);
            builder.append(");");
        }
    }

    @Override
    public BlockCache setAccess(World world) {
        return this;
    }

    @Override
    public Material fetchTypeId(int x, int y, int z) {
        Material id = this.idMapStored.get(x, y, z);
        if (id == null) {
            return Material.AIR;
        }
        return id;
    }

    @Override
    public int fetchData(int x, int y, int z) {
        Integer data = this.dataMapStored.get(x, y, z);
        if (data == null) {
            return 0;
        }
        return data;
    }

    @Override
    public double[] fetchBounds(int x, int y, int z) {
        double[] bounds = this.boundsMapStored.get(x, y, z);
        return bounds;
    }

    @Override
    public boolean standsOnEntity(Entity entity, double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        return false;
    }

    @Override
    public void cleanup() {
        super.cleanup();
        this.idMapStored.clear();
        this.dataMapStored.clear();
        this.boundsMapStored.clear();
    }
}

