/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.utilities.location;

import fr.neatmonster.nocheatplus.compat.MCAccess;
import fr.neatmonster.nocheatplus.components.registry.event.IHandle;
import fr.neatmonster.nocheatplus.utilities.location.RichEntityLocation;
import fr.neatmonster.nocheatplus.utilities.map.BlockCache;
import fr.neatmonster.nocheatplus.utilities.map.BlockProperties;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class PlayerLocation
extends RichEntityLocation {
    private Player player = null;

    public PlayerLocation(IHandle<MCAccess> mcAccess, BlockCache blockCache) {
        super(mcAccess, blockCache);
    }

    public Player getPlayer() {
        return this.player;
    }

    @Override
    public boolean isOnIce() {
        if (this.onIce == null) {
            if (this.blockFlags != null && (this.blockFlags & 0x20000L) == 0L) {
                this.onIce = false;
            } else {
                Material id = this.player.isSneaking() || this.player.isBlocking() ? this.getTypeId(this.blockX, Location.locToBlock((double)(this.minY - 0.1)), this.blockZ) : this.getTypeIdBelow();
                this.onIce = BlockProperties.isIce(id);
            }
        }
        return this.onIce;
    }

    public void set(Location location, Player player) {
        this.set(location, player, 0.001);
    }

    public void set(Location location, Player player, double yOnGround) {
        super.set(location, (Entity)player, yOnGround);
        this.player = player;
    }

    public void set(Location location, Player player, double width, double eyeHeight, double height, double fullHeight, double yOnGround) {
        super.doSetExactHeight(location, (Entity)player, true, width, eyeHeight, height, fullHeight, yOnGround);
        this.player = player;
    }

    @Override
    public void set(Location location, Entity entity, double yOnGround) {
        throw new UnsupportedOperationException("Set must specify an instance of Player.");
    }

    @Override
    public void set(Location location, Entity entity, double fullHeight, double yOnGround) {
        throw new UnsupportedOperationException("Set must specify an instance of Player.");
    }

    @Override
    public void set(Location location, Entity entity, double fullWidth, double fullHeight, double yOnGround) {
        throw new UnsupportedOperationException("Set must specify an instance of Player.");
    }

    public void prepare(PlayerLocation other) {
        super.prepare(other);
    }

    @Override
    public void cleanup() {
        super.cleanup();
        this.player = null;
    }

    public boolean isIllegal() {
        if (this.hasIllegalCoords()) {
            return true;
        }
        return this.hasIllegalStance();
    }

    public boolean hasIllegalStance() {
        return this.getMCAccess().isIllegalBounds(this.player).decide();
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder(128);
        builder.append("PlayerLocation(");
        builder.append(this.world == null ? "null" : this.world.getName());
        builder.append('/');
        builder.append(Double.toString(this.x));
        builder.append(", ");
        builder.append(Double.toString(this.y));
        builder.append(", ");
        builder.append(Double.toString(this.z));
        builder.append(')');
        return builder.toString();
    }
}

