/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.utilities.collision;

import fr.neatmonster.nocheatplus.checks.moving.util.MovingUtil;
import fr.neatmonster.nocheatplus.utilities.location.TrigUtil;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;

public class CollisionUtil {
    private static final Location useLoc = new Location(null, 0.0, 0.0, 0.0);

    public static double directionCheck(Player player, double targetX, double targetY, double targetZ, double targetWidth, double targetHeight, double precision) {
        Location loc = player.getLocation(useLoc);
        Vector dir = loc.getDirection();
        double res = CollisionUtil.directionCheck(loc.getX(), loc.getY() + MovingUtil.getEyeHeight(player), loc.getZ(), dir.getX(), dir.getY(), dir.getZ(), targetX, targetY, targetZ, targetWidth, targetHeight, precision);
        useLoc.setWorld(null);
        return res;
    }

    public static double directionCheck(Location sourceFoot, double eyeHeight, Vector dir, Block target, double precision) {
        return CollisionUtil.directionCheck(sourceFoot.getX(), sourceFoot.getY() + eyeHeight, sourceFoot.getZ(), dir.getX(), dir.getY(), dir.getZ(), target.getX(), target.getY(), target.getZ(), 1.0, 1.0, precision);
    }

    public static double directionCheck(Location sourceFoot, double eyeHeight, Vector dir, double targetX, double targetY, double targetZ, double targetWidth, double targetHeight, double precision) {
        return CollisionUtil.directionCheck(sourceFoot.getX(), sourceFoot.getY() + eyeHeight, sourceFoot.getZ(), dir.getX(), dir.getY(), dir.getZ(), targetX, targetY, targetZ, targetWidth, targetHeight, precision);
    }

    public static double directionCheck(double sourceX, double sourceY, double sourceZ, double dirX, double dirY, double dirZ, double targetX, double targetY, double targetZ, double targetWidth, double targetHeight, double precision) {
        double dirLength = Math.sqrt(dirX * dirX + dirY * dirY + dirZ * dirZ);
        if (dirLength == 0.0) {
            dirLength = 1.0;
        }
        double dX = targetX - sourceX;
        double dY = targetY - sourceY;
        double dZ = targetZ - sourceZ;
        double targetDist = Math.sqrt(dX * dX + dY * dY + dZ * dZ);
        double xPrediction = targetDist * dirX / dirLength;
        double yPrediction = targetDist * dirY / dirLength;
        double zPrediction = targetDist * dirZ / dirLength;
        double off = 0.0;
        off += Math.max(Math.abs(dX - xPrediction) - (targetWidth / 2.0 + precision), 0.0);
        off += Math.max(Math.abs(dZ - zPrediction) - (targetWidth / 2.0 + precision), 0.0);
        if ((off += Math.max(Math.abs(dY - yPrediction) - (targetHeight / 2.0 + precision), 0.0)) > 1.0) {
            off = Math.sqrt(off);
        }
        return off;
    }

    public static double combinedDirectionCheck(Location sourceFoot, double eyeHeight, Vector dir, double targetX, double targetY, double targetZ, double targetWidth, double targetHeight, double precision, double anglePrecision) {
        return CollisionUtil.combinedDirectionCheck(sourceFoot.getX(), sourceFoot.getY() + eyeHeight, sourceFoot.getZ(), dir.getX(), dir.getY(), dir.getZ(), targetX, targetY, targetZ, targetWidth, targetHeight, precision, anglePrecision);
    }

    public static double combinedDirectionCheck(Location sourceFoot, double eyeHeight, Vector dir, Block target, double precision, double anglePrecision) {
        return CollisionUtil.combinedDirectionCheck(sourceFoot.getX(), sourceFoot.getY() + eyeHeight, sourceFoot.getZ(), dir.getX(), dir.getY(), dir.getZ(), target.getX(), target.getY(), target.getZ(), 1.0, 1.0, precision, anglePrecision);
    }

    public static double combinedDirectionCheck(double sourceX, double sourceY, double sourceZ, double dirX, double dirY, double dirZ, double targetX, double targetY, double targetZ, double targetWidth, double targetHeight, double blockPrecision, double anglePrecision) {
        double dZ;
        double dY;
        double dX;
        double targetDist;
        double dirLength = Math.sqrt(dirX * dirX + dirY * dirY + dirZ * dirZ);
        if (dirLength == 0.0) {
            dirLength = 1.0;
        }
        if ((targetDist = Math.sqrt((dX = targetX - sourceX) * dX + (dY = targetY - sourceY) * dY + (dZ = targetZ - sourceZ) * dZ)) > Math.max(targetHeight, targetWidth) / 2.0 && (double)TrigUtil.angle(sourceX, sourceY, sourceZ, dirX, dirY, dirZ, targetX, targetY, targetZ) * 57.29577951308232 > anglePrecision) {
            return targetDist - Math.max(targetHeight, targetWidth) / 2.0;
        }
        double xPrediction = targetDist * dirX / dirLength;
        double yPrediction = targetDist * dirY / dirLength;
        double zPrediction = targetDist * dirZ / dirLength;
        double off = 0.0;
        off += Math.max(Math.abs(dX - xPrediction) - (targetWidth / 2.0 + blockPrecision), 0.0);
        off += Math.max(Math.abs(dY - yPrediction) - (targetHeight / 2.0 + blockPrecision), 0.0);
        if ((off += Math.max(Math.abs(dZ - zPrediction) - (targetWidth / 2.0 + blockPrecision), 0.0)) > 1.0) {
            off = Math.sqrt(off);
        }
        return off;
    }

    public static boolean intersectsBlock(double min, double max, int block) {
        double db = block;
        return db + 1.0 > min && db < max;
    }

    public static boolean isInsideAABBIncludeEdges(double x, double y, double z, double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        return !(x < minX || x > maxX || z < minZ || z > maxZ || y < minY || y > maxY);
    }

    public static double getMinTimeIncludeEdges(double pos, double dir, double minPos, double maxPos) {
        if (pos >= minPos && pos <= maxPos) {
            return 0.0;
        }
        if (dir == 0.0) {
            return Double.POSITIVE_INFINITY;
        }
        if (dir < 0.0) {
            return pos < minPos ? Double.POSITIVE_INFINITY : Math.abs(pos - maxPos) / Math.abs(dir);
        }
        return pos > maxPos ? Double.POSITIVE_INFINITY : Math.abs(pos - minPos) / dir;
    }

    public static double getMaxTimeIncludeEdges(double pos, double dir, double minPos, double maxPos, double minTime) {
        if (Double.isInfinite(minTime)) {
            return Double.NaN;
        }
        if (dir == 0.0) {
            return pos < minPos || pos > maxPos ? Double.NaN : Double.POSITIVE_INFINITY;
        }
        if (dir < 0.0) {
            return pos < minPos ? Double.NaN : Math.abs(pos - minPos) / Math.abs(dir);
        }
        return pos > maxPos ? Double.NaN : Math.abs(pos - maxPos) / dir;
    }

    public static double getMaxAxisDistAABB(double x, double y, double z, double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        return Math.max(CollisionUtil.axisDistance(x, minX, maxX), Math.max(CollisionUtil.axisDistance(y, minY, maxY), CollisionUtil.axisDistance(z, minZ, maxZ)));
    }

    public static double getManhattanDistAABB(double x, double y, double z, double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        return CollisionUtil.axisDistance(x, minX, maxX) + CollisionUtil.axisDistance(y, minY, maxY) + CollisionUtil.axisDistance(z, minZ, maxZ);
    }

    public static double getSquaredDistAABB(double x, double y, double z, double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        double dX = CollisionUtil.axisDistance(x, minX, maxX);
        double dY = CollisionUtil.axisDistance(y, minY, maxY);
        double dZ = CollisionUtil.axisDistance(z, minZ, maxZ);
        return dX * dX + dY * dY + dZ * dZ;
    }

    public static double axisDistance(double pos, double minPos, double maxPos) {
        return pos < minPos ? Math.abs(pos - minPos) : (pos > maxPos ? Math.abs(pos - maxPos) : 0.0);
    }
}

