/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.utilities;

import fr.neatmonster.nocheatplus.checks.CheckType;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class CheckTypeUtil {
    private static final Map<CheckType, Set<CheckType>> descendantsMap = new HashMap<CheckType, Set<CheckType>>();
    private static final Map<CheckType, Set<CheckType>> directChildrenMap = new HashMap<CheckType, Set<CheckType>>();
    private static final Set<CheckType> needSync = new HashSet<CheckType>();
    private static final Map<CheckType, Set<CheckType>> withDescendantsMap = new HashMap<CheckType, Set<CheckType>>();

    public static final Set<CheckType> getDescendants(CheckType type) {
        return descendantsMap.get((Object)type);
    }

    public static final Set<CheckType> getDirectChildren(CheckType type) {
        return directChildrenMap.get((Object)type);
    }

    public static final Set<CheckType> getWithDescendants(CheckType type) {
        return withDescendantsMap.get((Object)type);
    }

    public static final boolean isAncestor(CheckType supposedAncestor, CheckType supposedDescendant) {
        if (supposedAncestor == supposedDescendant) {
            return false;
        }
        if (supposedAncestor == CheckType.ALL) {
            return true;
        }
        for (CheckType parent = supposedDescendant.getParent(); parent != null; parent = parent.getParent()) {
            if (parent != supposedAncestor) continue;
            return true;
        }
        return false;
    }

    public static final boolean needsSynchronization(CheckType type) {
        return needSync.contains((Object)type);
    }

    static {
        HashMap map = new HashMap();
        for (CheckType type : CheckType.values()) {
            map.put(type, new LinkedHashSet());
        }
        for (CheckType type : CheckType.values()) {
            if (type != CheckType.ALL) {
                ((Set)map.get((Object)CheckType.ALL)).add(type);
            }
            for (CheckType other : CheckType.values()) {
                if (!CheckTypeUtil.isAncestor(other, type)) continue;
                ((Set)map.get((Object)other)).add(type);
            }
        }
        for (CheckType parent : map.keySet()) {
            Set set = (Set)map.get((Object)parent);
            descendantsMap.put(parent, Collections.unmodifiableSet(set));
            LinkedHashSet<CheckType> wpSet = new LinkedHashSet<CheckType>(set);
            wpSet.add(parent);
            withDescendantsMap.put(parent, Collections.unmodifiableSet(wpSet));
        }
        for (CheckType parent : map.keySet()) {
            LinkedHashSet set = new LinkedHashSet((Collection)map.get((Object)parent));
            Iterator it = set.iterator();
            while (it.hasNext()) {
                if (((CheckType)((Object)it.next())).getParent() == parent) continue;
                it.remove();
            }
            directChildrenMap.put(parent, Collections.unmodifiableSet(set));
        }
        for (CheckType checkType : new CheckType[]{CheckType.CHAT, CheckType.NET}) {
            needSync.addAll(CheckTypeUtil.getWithDescendants(checkType));
        }
    }
}

