/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.players;

import fr.neatmonster.nocheatplus.checks.moving.util.MovingUtil;
import fr.neatmonster.nocheatplus.compat.AlmostBoolean;
import fr.neatmonster.nocheatplus.components.data.ICanHandleTimeRunningBackwards;
import fr.neatmonster.nocheatplus.components.data.IData;
import fr.neatmonster.nocheatplus.permissions.PermissionInfo;
import fr.neatmonster.nocheatplus.permissions.PermissionNode;
import fr.neatmonster.nocheatplus.permissions.PermissionPolicy;
import fr.neatmonster.nocheatplus.permissions.PermissionRegistry;
import fr.neatmonster.nocheatplus.permissions.RegisteredPermission;
import fr.neatmonster.nocheatplus.players.DataManager;
import fr.neatmonster.nocheatplus.utilities.TickTask;
import fr.neatmonster.nocheatplus.utilities.ds.corw.DualSet;
import fr.neatmonster.nocheatplus.utilities.ds.count.ActionFrequency;
import fr.neatmonster.nocheatplus.utilities.ds.map.HashMapLOW;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.entity.Player;

public class PlayerData
implements IData,
ICanHandleTimeRunningBackwards {
    private static ActionFrequency taskLoad = new ActionFrequency(6, 7L);
    private static final int ticksMonitored = taskLoad.numberOfBuckets() * (int)taskLoad.bucketDuration();
    private static final long msMonitored = ticksMonitored * 50;
    private static float heavyLoad = 500000.0f / (float)ticksMonitored;
    public static final String TAG_NOTIFY_OFF = "notify_off";
    private static final short frequentTaskLazyDefaultDelay = 10;
    private static final short frequentTaskUnregisterDefaultDelay = 2;
    private Set<String> tags = null;
    final UUID playerId;
    final String playerName;
    final String lcName;
    private final PermissionRegistry permissionRegistry;
    private final HashMapLOW<Integer, PermissionNode> permissions = new HashMapLOW(35);
    private boolean requestUpdateInventory = false;
    private boolean requestPlayerSetBack = false;
    private boolean frequentPlayerTaskShouldBeScheduled = false;
    private final DualSet<RegisteredPermission> updatePermissions = new DualSet();
    private final DualSet<RegisteredPermission> updatePermissionsLazy = new DualSet();
    private short frequentTaskDelayUnregister = 0;
    private short frequentTaskDelayLazy = 0;

    public PlayerData(UUID playerId, String playerName, PermissionRegistry permissionRegistry) {
        this.playerId = playerId;
        this.playerName = playerName;
        this.lcName = playerName.toLowerCase();
        this.permissionRegistry = permissionRegistry;
    }

    protected boolean processTickFrequent(int tick, long timeLast) {
        if (this.frequentTaskDelayUnregister == 0) {
            this.frequentTaskDelayUnregister = (short)2;
        }
        if (this.frequentTaskDelayLazy == 0) {
            this.frequentTaskDelayLazy = (short)10;
        }
        boolean busy = false;
        Player player = DataManager.getPlayer(this.playerId);
        if (this.hasFrequentTasks()) {
            this.frequentTasks(tick, timeLast, player);
            busy = true;
        }
        if ((this.frequentTaskDelayLazy = (short)(this.frequentTaskDelayLazy - 1)) == 0 && !this.lazyTasks(tick, timeLast, player)) {
            busy = true;
        }
        if (busy || this.frequentTaskDelayLazy > 0) {
            this.frequentTaskDelayUnregister = (short)2;
            return false;
        }
        this.frequentTaskDelayUnregister = (short)(this.frequentTaskDelayUnregister - 1);
        if (this.frequentTaskDelayUnregister == 0) {
            if (this.hasLazyTasks() || this.hasFrequentTasks()) {
                this.frequentTaskDelayLazy = (short)10;
                return false;
            }
            this.frequentPlayerTaskShouldBeScheduled = false;
            return true;
        }
        return false;
    }

    private boolean hasFrequentTasks() {
        return !this.updatePermissions.isEmtpyAfterMergePrimaryThread() || this.requestPlayerSetBack || this.requestUpdateInventory;
    }

    private void frequentTasks(int tick, long timeLast, Player player) {
        if (player != null && player.isOnline()) {
            Collection updatable;
            long nanos = System.nanoTime();
            if (this.requestPlayerSetBack) {
                this.requestPlayerSetBack = false;
                MovingUtil.processStoredSetBack(player, "Player set back on tick: ");
            }
            if (this.requestUpdateInventory) {
                this.requestUpdateInventory = false;
                player.updateInventory();
            }
            if ((updatable = this.updatePermissions.getMergePrimaryThreadAndClear()) != null) {
                for (RegisteredPermission registeredPermission : updatable) {
                    this.hasPermission(registeredPermission, player);
                }
            }
            if ((nanos = System.nanoTime() - nanos) > 0L) {
                taskLoad.add(tick, nanos);
            }
        }
    }

    private boolean hasLazyTasks() {
        return !this.updatePermissionsLazy.isEmtpyAfterMergePrimaryThread();
    }

    private boolean lazyTasks(int tick, long timeLast, Player player) {
        if (player == null) {
            return true;
        }
        long nanos = System.nanoTime();
        taskLoad.update(tick);
        boolean isHeavyLoad = taskLoad.score(1.0f) > heavyLoad || TickTask.getLag(msMonitored, true) > 1.1f;
        this.updatePermissionsLazy.mergePrimaryThread();
        Iterator it = this.updatePermissionsLazy.iteratorPrimaryThread();
        while (it.hasNext()) {
            this.hasPermission((RegisteredPermission)it.next(), player);
            it.remove();
            if (!isHeavyLoad) continue;
        }
        boolean hasWrk = it.hasNext();
        nanos = System.nanoTime() - nanos;
        if (nanos > 0L) {
            taskLoad.add(tick, nanos);
        }
        return !hasWrk;
    }

    private void registerFrequentPlayerTask() {
        if (Bukkit.isPrimaryThread()) {
            this.registerFrequentPlayerTaskPrimaryThread();
        } else {
            this.registerFrequentPlayerTaskAsynchronous();
        }
    }

    private void registerFrequentPlayerTaskPrimaryThread() {
        this.frequentPlayerTaskShouldBeScheduled = true;
        DataManager.registerFrequentPlayerTaskPrimaryThread(this.playerId);
    }

    private void registerFrequentPlayerTaskAsynchronous() {
        this.frequentPlayerTaskShouldBeScheduled = true;
        DataManager.registerFrequentPlayerTaskAsynchronous(this.playerId);
    }

    private boolean isFrequentPlayerTaskScheduled() {
        return DataManager.isFrequentPlayerTaskScheduled(this.playerId);
    }

    public boolean hasPermission(RegisteredPermission registeredPermission, Player player) {
        AlmostBoolean fRes;
        PermissionNode node = this.permissions.get(registeredPermission.getId());
        if (node == null) {
            node = this.getOrCreatePermissionNode(registeredPermission);
        }
        PermissionPolicy.FetchingPolicy fetchingPolicy = node.getFetchingPolicy();
        switch (fetchingPolicy) {
            case TRUE: {
                return true;
            }
            case FALSE: {
                return false;
            }
        }
        AlmostBoolean lastState = node.getLastState();
        if (lastState != AlmostBoolean.MAYBE) {
            switch (fetchingPolicy) {
                case ONCE: {
                    return lastState.decide();
                }
                case INTERVAL: {
                    if (System.currentTimeMillis() - node.getLastFetch() >= node.getFetchInterval()) break;
                    return lastState.decide();
                }
            }
        }
        if ((fRes = this.fetchPermission(registeredPermission, player)) == AlmostBoolean.MAYBE) {
            return lastState.decide();
        }
        node.setState(fRes, System.currentTimeMillis());
        return fRes.decide();
    }

    private PermissionNode getOrCreatePermissionNode(RegisteredPermission registeredPermission) {
        PermissionNode node = new PermissionNode(this.permissionRegistry.getPermissionInfo(registeredPermission.getId()));
        PermissionNode oldNode = this.permissions.putIfAbsent(registeredPermission.getId(), node);
        return oldNode == null ? node : oldNode;
    }

    private AlmostBoolean fetchPermission(RegisteredPermission registeredPermission, Player player) {
        if (Bukkit.isPrimaryThread()) {
            if (player == null && (player = DataManager.getPlayer(this.playerId)) == null) {
                return AlmostBoolean.MAYBE;
            }
            return player.hasPermission(registeredPermission.getBukkitPermission()) ? AlmostBoolean.YES : AlmostBoolean.NO;
        }
        this.requestPermissionUpdate(registeredPermission);
        return AlmostBoolean.MAYBE;
    }

    public boolean hasTag(String tag) {
        return this.tags != null && this.tags.contains(tag);
    }

    public void addTag(String tag) {
        if (this.tags == null) {
            this.tags = new HashSet<String>();
        }
        this.tags.add(tag);
    }

    public void removeTag(String tag) {
        if (this.tags != null) {
            this.tags.remove(tag);
            if (this.tags.isEmpty()) {
                this.tags = null;
            }
        }
    }

    public void setTag(String tag, boolean add) {
        if (add) {
            this.addTag(tag);
        } else {
            this.removeTag(tag);
        }
    }

    public boolean getNotifyOff() {
        return this.hasTag(TAG_NOTIFY_OFF);
    }

    public void setNotifyOff(boolean notifyOff) {
        this.setTag(TAG_NOTIFY_OFF, notifyOff);
    }

    public void requestUpdateInventory() {
        this.requestUpdateInventory = true;
        this.registerFrequentPlayerTask();
    }

    public void requestPlayerSetBack() {
        this.requestPlayerSetBack = true;
        this.registerFrequentPlayerTask();
    }

    public boolean isPlayerSetBackScheduled() {
        return this.requestPlayerSetBack && (this.frequentPlayerTaskShouldBeScheduled || this.isFrequentPlayerTaskScheduled());
    }

    @Override
    public void handleTimeRanBackwards() {
        Iterator<Map.Entry<Integer, PermissionNode>> it = this.permissions.iterator();
        long timeNow = System.currentTimeMillis();
        while (it.hasNext()) {
            PermissionNode node = it.next().getValue();
            switch (node.getFetchingPolicy()) {
                case INTERVAL: {
                    node.invalidate();
                    break;
                }
                case ONCE: {
                    node.setState(node.getLastState(), timeNow);
                    break;
                }
            }
        }
    }

    public void requestPermissionUpdate(RegisteredPermission registeredPermission) {
        if (Bukkit.isPrimaryThread()) {
            this.requestPermissionUpdatePrimaryThread(registeredPermission);
        } else {
            this.requestPermissionUpdateAsynchronous(registeredPermission);
        }
    }

    protected void requestPermissionUpdatePrimaryThread(RegisteredPermission registeredPermission) {
        this.updatePermissions.addPrimaryThread(registeredPermission);
        this.registerFrequentPlayerTaskPrimaryThread();
    }

    protected void requestPermissionUpdateAsynchronous(RegisteredPermission registeredPermission) {
        this.updatePermissions.addAsynchronous(registeredPermission);
        this.registerFrequentPlayerTaskAsynchronous();
    }

    public void requestLazyPermissionUpdate(RegisteredPermission ... registeredPermissions) {
        if (registeredPermissions == null || registeredPermissions.length == 0) {
            return;
        }
        if (Bukkit.isPrimaryThread()) {
            this.requestLazyPermissionUpdatePrimaryThread(registeredPermissions);
        } else {
            this.requestLazyPermissionUpdateAsynchronous(registeredPermissions);
        }
    }

    protected void requestLazyPermissionUpdatePrimaryThread(RegisteredPermission ... registeredPermissions) {
        this.updatePermissionsLazy.addAllPrimaryThread(Arrays.asList(registeredPermissions));
        this.registerFrequentPlayerTaskPrimaryThread();
    }

    protected void requestLazyPermissionUpdateAsynchronous(RegisteredPermission ... registeredPermissions) {
        this.updatePermissionsLazy.addAllAsynchronous(Arrays.asList(registeredPermissions));
        this.registerFrequentPlayerTaskAsynchronous();
    }

    void onPlayerLeave(long timeNow) {
        this.invalidateOffline();
    }

    void onPlayerJoin(long timeNow) {
        this.invalidateOffline();
        this.requestLazyPermissionUpdate(this.permissionRegistry.getPreferKeepUpdatedOffline());
    }

    private void invalidateOffline() {
        Iterator<Map.Entry<Integer, PermissionNode>> it = this.permissions.iterator();
        while (it.hasNext()) {
            PermissionNode node = it.next().getValue();
            PermissionInfo info = node.getPermissionInfo();
            if (!info.invalidationOffline() && !info.invalidationWorld()) continue;
            node.invalidate();
        }
    }

    void onPlayerChangedWorld(World oldWorld, World newWorld) {
        Iterator<Map.Entry<Integer, PermissionNode>> it = this.permissions.iterator();
        while (it.hasNext()) {
            PermissionNode node = it.next().getValue();
            PermissionInfo info = node.getPermissionInfo();
            if (!info.invalidationWorld()) continue;
            node.invalidate();
        }
        this.requestLazyPermissionUpdate(this.permissionRegistry.getPreferKeepUpdatedWorld());
    }

    public void adjustSettings(Set<RegisteredPermission> changedPermissions) {
        Iterator<RegisteredPermission> it = changedPermissions.iterator();
        while (it.hasNext()) {
            PermissionNode node = this.permissions.get(it.next().getId());
            if (node == null) continue;
            node.invalidate();
        }
    }

    public void removeData(boolean keepEssentialData) {
        this.permissions.clear();
        this.updatePermissions.clearPrimaryThread();
        this.updatePermissionsLazy.clearPrimaryThread();
    }
}

