/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.permissions;

import fr.neatmonster.nocheatplus.permissions.PermissionPolicy;
import fr.neatmonster.nocheatplus.permissions.RegisteredPermission;
import fr.neatmonster.nocheatplus.utilities.StringUtil;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.bukkit.configuration.ConfigurationSection;

public class PermissionSettings {
    private final Map<String, PermissionPolicy> explicitPolicy;
    private final PermissionRule[] implicitRules;
    private final PermissionPolicy defaultPolicy;

    public static PermissionRule getMatchingRule(String input, PermissionPolicy policy) {
        if ((input = RegisteredPermission.toLowerCaseStringRepresentation(input.trim())).startsWith("*")) {
            if (input.endsWith("*")) {
                return new ContainsRule(input.substring(1, input.length() - 1).trim(), policy);
            }
            return new EndsWithRule(input.substring(1).trim(), policy);
        }
        if (input.endsWith("*")) {
            return new StartsWithRule(input.substring(0, input.length() - 1).trim(), policy);
        }
        if (input.startsWith("regex:")) {
            return new RegexRule(input.split(":", 2)[1].trim(), policy);
        }
        if (StringUtil.startsWithAnyOf(input, "startswith:", "starts:", "start:", "prefix:", "head:")) {
            return new StartsWithRule(input.split(":", 2)[1].trim(), policy);
        }
        if (StringUtil.startsWithAnyOf(input, "endsswith:", "ends:", "end:", "suffix:", "tail:")) {
            return new StartsWithRule(input.split(":", 2)[1].trim(), policy);
        }
        if (StringUtil.startsWithAnyOf(input, "contains:", "contain:", "has:")) {
            return new ContainsRule(input.split(":", 2)[1].trim(), policy);
        }
        return null;
    }

    public static PermissionSettings fromConfig(ConfigurationSection config, String pathDefaultPolicy, String pathRules) {
        PermissionPolicy defaultPolicy = new PermissionPolicy();
        try {
            defaultPolicy.setPolicyFromConfigLine(config.getString(pathDefaultPolicy));
        }
        catch (Exception e) {
            throw new RuntimeException("Bad default policy definition.", e);
        }
        LinkedHashMap<String, PermissionPolicy> explicitPolicy = new LinkedHashMap<String, PermissionPolicy>();
        LinkedList<PermissionRule> implicitRules = new LinkedList<PermissionRule>();
        List defs = config.getStringList(pathRules);
        for (String def : defs) {
            String[] split = def.split(": ", 2);
            if (split.length != 2) {
                throw new IllegalArgumentException("Must the separate matching rule from the policy definition by ' :: '.");
            }
            String ruleDef = RegisteredPermission.toLowerCaseStringRepresentation(split[0].trim());
            String policyDef = split[1].trim();
            try {
                PermissionPolicy policy = new PermissionPolicy().setPolicyFromConfigLine(policyDef);
                PermissionRule rule = PermissionSettings.getMatchingRule(ruleDef, policy);
                if (rule == null) {
                    explicitPolicy.put(ruleDef, policy);
                    continue;
                }
                implicitRules.add(rule);
            }
            catch (Exception e) {
                throw new RuntimeException("Bad rule definition (Match='" + ruleDef + "' Policy='" + policyDef + "')", e);
            }
        }
        return new PermissionSettings(explicitPolicy, implicitRules, defaultPolicy);
    }

    public PermissionSettings(Map<String, PermissionPolicy> explicitPolicy, List<PermissionRule> implicitRules, PermissionPolicy defaultPolicy) {
        if (defaultPolicy == null) {
            throw new IllegalArgumentException("The default policy must not be null.");
        }
        this.explicitPolicy = explicitPolicy == null || explicitPolicy.isEmpty() ? null : new HashMap<String, PermissionPolicy>(explicitPolicy);
        this.implicitRules = implicitRules == null || implicitRules.isEmpty() ? null : implicitRules.toArray(new PermissionRule[implicitRules.size()]);
        this.defaultPolicy = defaultPolicy;
    }

    public PermissionPolicy getPermissionPolicy(RegisteredPermission registeredPermission) {
        String permissionName = registeredPermission.getLowerCaseStringRepresentation();
        PermissionPolicy ref = null;
        if (this.explicitPolicy != null) {
            ref = this.explicitPolicy.get(registeredPermission.getLowerCaseStringRepresentation());
        }
        if (ref == null) {
            if (this.implicitRules != null) {
                for (int i = 0; i < this.implicitRules.length; ++i) {
                    if (!this.implicitRules[i].matches(permissionName)) continue;
                    ref = this.implicitRules[i].getPermissionPolicy();
                }
            }
            if (ref == null) {
                ref = this.defaultPolicy;
            }
        }
        return new PermissionPolicy(ref);
    }

    public static class RegexRule
    extends PermissionRule {
        private final String matches;

        public RegexRule(String matches, PermissionPolicy policy) {
            super(policy);
            this.matches = RegisteredPermission.toLowerCaseStringRepresentation(matches);
        }

        @Override
        public boolean matches(String permissionName) {
            return permissionName.matches(this.matches);
        }
    }

    public static class ContainsRule
    extends PermissionRule {
        private final String contains;

        public ContainsRule(String contains, PermissionPolicy policy) {
            super(policy);
            this.contains = RegisteredPermission.toLowerCaseStringRepresentation(contains);
        }

        @Override
        public boolean matches(String permissionName) {
            return permissionName.indexOf(this.contains) >= 0;
        }
    }

    public static class EndsWithRule
    extends PermissionRule {
        private final String endsWith;

        public EndsWithRule(String endsWith, PermissionPolicy policy) {
            super(policy);
            this.endsWith = RegisteredPermission.toLowerCaseStringRepresentation(endsWith);
        }

        @Override
        public boolean matches(String permissionName) {
            return permissionName.endsWith(this.endsWith);
        }
    }

    public static class StartsWithRule
    extends PermissionRule {
        private final String startsWith;

        public StartsWithRule(String startsWith, PermissionPolicy policy) {
            super(policy);
            this.startsWith = RegisteredPermission.toLowerCaseStringRepresentation(startsWith);
        }

        @Override
        public boolean matches(String permissionName) {
            return permissionName.startsWith(this.startsWith);
        }
    }

    public static abstract class PermissionRule {
        private final PermissionPolicy policy;

        public PermissionRule(PermissionPolicy policy) {
            this.policy = new PermissionPolicy(policy);
        }

        public PermissionPolicy getPermissionPolicy() {
            return this.policy;
        }

        public abstract boolean matches(String var1);
    }
}

