/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.logging.details;

import fr.neatmonster.nocheatplus.utilities.StringUtil;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class FileLogger {
    public final Logger logger = Logger.getAnonymousLogger();
    protected FileHandler fileHandler = null;
    protected boolean inoperable = false;

    public FileLogger(File file) {
        File container;
        this.detachLogger();
        if (!file.exists() && file.getName().indexOf(46) == -1) {
            file.mkdirs();
        }
        if (file.isDirectory()) {
            container = file;
            SimpleDateFormat dateFormat = new SimpleDateFormat("yy-MM-dd");
            String prefix = dateFormat.format(System.currentTimeMillis());
            int n = 1;
            while ((file = new File(container, prefix + "-" + n + ".log")).exists()) {
                ++n;
            }
        } else {
            container = file.getParentFile();
        }
        if (!container.exists()) {
            container.mkdirs();
        }
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                file = null;
            }
        }
        if (file != null) {
            try {
                this.initLogger(file);
                this.logger.log(Level.INFO, "Logger started.");
                this.inoperable = false;
            }
            catch (SecurityException securityException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    protected void initLogger(File file) throws SecurityException, IOException {
        this.logger.setUseParentHandlers(false);
        this.logger.setLevel(Level.ALL);
        this.fileHandler = new FileHandler(file.getCanonicalPath(), true);
        this.fileHandler.setLevel(Level.ALL);
        this.fileHandler.setFormatter(new FileLogFormatter());
        this.logger.addHandler(this.fileHandler);
    }

    public void flush() {
        if (this.fileHandler != null) {
            this.fileHandler.flush();
        }
    }

    public void detachLogger() {
        if (this.fileHandler != null) {
            this.fileHandler.close();
            this.fileHandler = null;
        }
        for (Handler handler : this.logger.getHandlers()) {
            this.logger.removeHandler(handler);
        }
    }

    public boolean isInoperable() {
        return this.inoperable;
    }

    protected static class FileLogFormatter
    extends Formatter {
        private final SimpleDateFormat dateFormat = new SimpleDateFormat("yy-MM-dd HH:mm:ss");

        protected FileLogFormatter() {
        }

        @Override
        public String format(LogRecord record) {
            String throwableMessage;
            Throwable throwable = record.getThrown();
            String message = record.getMessage();
            int roughLength = 64 + message.length();
            if (throwable != null) {
                throwableMessage = StringUtil.throwableToString(throwable);
                roughLength += throwableMessage.length();
            } else {
                throwableMessage = null;
            }
            StringBuilder builder = new StringBuilder(roughLength);
            builder.append(this.dateFormat.format(record.getMillis()));
            builder.append(" [");
            builder.append(record.getLevel().getLocalizedName().toUpperCase());
            builder.append("] ");
            builder.append(message);
            builder.append('\n');
            if (throwableMessage != null) {
                builder.append(throwableMessage);
            }
            return builder.toString();
        }
    }
}

