/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.event.mini;

import fr.neatmonster.nocheatplus.components.registry.feature.ComponentWithName;
import fr.neatmonster.nocheatplus.components.registry.order.RegistrationOrder;
import fr.neatmonster.nocheatplus.event.mini.MiniListener;
import fr.neatmonster.nocheatplus.event.mini.MiniListenerNode;
import fr.neatmonster.nocheatplus.event.mini.MiniListenerRegistry;
import fr.neatmonster.nocheatplus.event.mini.MultiListenerRegistry;
import fr.neatmonster.nocheatplus.utilities.ReflectionUtil;
import java.lang.reflect.Method;
import java.util.Collection;
import org.bukkit.Bukkit;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.bukkit.event.EventException;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.server.PluginDisableEvent;
import org.bukkit.plugin.EventExecutor;
import org.bukkit.plugin.Plugin;

public class EventRegistryBukkit
extends MultiListenerRegistry<Event, EventPriority> {
    private final Plugin plugin;
    private final Listener dummyListener = new Listener(){};

    public EventRegistryBukkit(Plugin plugin) {
        this.plugin = plugin;
        this.nodeFactory = new MiniListenerRegistry.NodeFactory<Event, EventPriority>(){

            @Override
            public <E extends Event> MiniListenerNode<E, EventPriority> newNode(Class<E> eventClass, EventPriority basePriority) {
                if (Cancellable.class.isAssignableFrom(eventClass)) {
                    return new CancellableNodeBukkit(basePriority);
                }
                return new MiniListenerNode(basePriority);
            }
        };
        this.register(new MiniListener<PluginDisableEvent>(){

            @Override
            public void onEvent(PluginDisableEvent event) {
                EventRegistryBukkit.this.unregisterAttached(event.getPlugin());
            }
        }, EventPriority.MONITOR, new RegistrationOrder("nocheatplus.system.registry", null, ".*"), true);
    }

    @Override
    protected <E extends Event> void registerNode(final Class<E> eventClass, final MiniListenerNode<E, EventPriority> node, EventPriority basePriority) {
        Bukkit.getPluginManager().registerEvent(eventClass, this.dummyListener, basePriority, new EventExecutor(){

            public void execute(Listener dummy, Event event) throws EventException {
                if (eventClass.isAssignableFrom(event.getClass())) {
                    node.onEvent(event);
                }
            }
        }, this.plugin, false);
    }

    public void register(Listener listener, Plugin plugin) {
        this.register(listener, null, plugin);
    }

    public void register(Listener listener, RegistrationOrder defaultOrder, Plugin plugin) {
        this.attach(this.internalRegister(listener, defaultOrder), (Object)plugin);
    }

    public void register(Listener listener) {
        this.register(listener, (RegistrationOrder)null);
    }

    public void register(Listener listener, RegistrationOrder defaultOrder) {
        this.internalRegister(listener, defaultOrder);
    }

    public <E extends Event> void register(Class<E> eventClass, MiniListener<E> listener) {
        EventHandler eh;
        Class<?> clazz = listener.getClass();
        try {
            Method method = clazz.getMethod("onEvent", eventClass);
            if (!method.isAnnotationPresent(EventHandler.class)) {
                throw new IllegalArgumentException("Must have @EventHandler annotation: " + clazz.getName());
            }
            eh = method.getAnnotation(EventHandler.class);
            eventClass = method.getParameterTypes()[0];
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(e);
        }
        catch (SecurityException e) {
            throw new IllegalArgumentException(e);
        }
        this.register(eventClass, listener, eh.priority(), null, eh.ignoreCancelled());
    }

    public <E extends Event> void register(MiniListener<E> listener) {
        Class<?> eventClass;
        Class<?> clazz = listener.getClass();
        try {
            Method method = ReflectionUtil.seekMethodIgnoreArgs(clazz, "onEvent", new Class[0]);
            eventClass = method.getParameterTypes()[0];
        }
        catch (NullPointerException e) {
            throw new IllegalArgumentException(e);
        }
        catch (SecurityException e) {
            throw new IllegalArgumentException(e);
        }
        this.register(eventClass, listener);
    }

    private Collection<MiniListener<? extends Event>> internalRegister(Listener listener, RegistrationOrder defaultOrder) {
        if (defaultOrder == null && listener instanceof ComponentWithName) {
            defaultOrder = new RegistrationOrder(((ComponentWithName)listener).getComponentName());
        }
        return super.register(listener, EventPriority.NORMAL, defaultOrder, false);
    }

    @Override
    protected boolean shouldBeEventHandler(Method method) {
        return method.getAnnotation(EventHandler.class) != null;
    }

    @Override
    protected boolean getIgnoreCancelled(Method method, boolean defaultIgnoreCancelled) {
        EventHandler info = method.getAnnotation(EventHandler.class);
        if (info == null) {
            return defaultIgnoreCancelled;
        }
        return info.ignoreCancelled();
    }

    @Override
    protected EventPriority getPriority(Method method, EventPriority defaultPriority) {
        EventHandler info = method.getAnnotation(EventHandler.class);
        if (info == null) {
            return defaultPriority;
        }
        return info.priority();
    }

    protected static class CancellableNodeBukkit<E>
    extends MiniListenerNode<E, EventPriority> {
        public CancellableNodeBukkit(EventPriority basePriority) {
            super(basePriority);
        }

        @Override
        protected boolean isCancelled(E event) {
            return ((Cancellable)event).isCancelled();
        }
    }
}

