/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.components.registry.store;

import fr.neatmonster.nocheatplus.components.registry.exception.AlreadyRegisteredException;
import fr.neatmonster.nocheatplus.components.registry.order.IGetRegistrationOrder;
import fr.neatmonster.nocheatplus.components.registry.order.IRegisterWithOrder;
import fr.neatmonster.nocheatplus.components.registry.order.RegistrationOrder;
import fr.neatmonster.nocheatplus.components.registry.order.SetupOrder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class RegisteredItemStore {
    private final Map<Class<?>, ItemList<?>> itemListMap = new HashMap();
    private final Map<Object, Set<Class<?>>> items = new HashMap();
    private int internalCount = 0;

    public <T, I extends T> void register(Class<T> type, I item) {
        this.register(type, item, null);
    }

    public <T, I extends T> void register(Class<T> type, I item, RegistrationOrder order) {
        if (item == null) {
            throw new NullPointerException("Item must not be null.");
        }
        if (type == null) {
            throw new NullPointerException("Type must not be null.");
        }
        Set<Class<?>> registeredFor = this.items.get(item);
        if (registeredFor != null && registeredFor.contains(type)) {
            throw new AlreadyRegisteredException("Already registered for type: " + type.getName());
        }
        if (order == null && item instanceof IRegisterWithOrder) {
            order = ((IRegisterWithOrder)item).getRegistrationOrder(type);
        }
        if (order == null && item instanceof IGetRegistrationOrder) {
            order = ((IGetRegistrationOrder)item).getRegistrationOrder();
        }
        if (order == null) {
            RegistrationOrder.RegisterWithOrder annoOrder = item.getClass().getAnnotation(RegistrationOrder.RegisterWithOrder.class);
            SetupOrder setupOrder = item.getClass().getAnnotation(SetupOrder.class);
            order = annoOrder != null ? new RegistrationOrder(annoOrder) : (setupOrder != null ? new RegistrationOrder(setupOrder) : RegistrationOrder.DEFAULT_ORDER);
        } else {
            order = new RegistrationOrder(order);
        }
        ItemList<Object> itemList = this.itemListMap.get(type);
        if (itemList == null) {
            itemList = new ItemList();
            this.itemListMap.put(type, itemList);
        }
        itemList.register(order, item, ++this.internalCount);
        if (registeredFor == null) {
            registeredFor = new HashSet();
            this.items.put(item, registeredFor);
        }
        registeredFor.add(type);
    }

    public <T, I extends T> boolean unregister(Class<T> type, I item) {
        ItemList<?> itemList;
        if (item == null) {
            throw new NullPointerException("Item must not be null.");
        }
        if (type == null) {
            throw new NullPointerException("Type must not be null.");
        }
        int count = 0;
        Set<Class<?>> registeredFor = this.items.get(item);
        if (registeredFor != null && registeredFor.remove(type)) {
            ++count;
            if (registeredFor.isEmpty()) {
                this.items.remove(item);
            }
        }
        if ((itemList = this.itemListMap.get(type)) != null && itemList.unregister(item)) {
            ++count;
            if (((ItemList)itemList).itemNodes.isEmpty()) {
                this.itemListMap.remove(type);
            }
        }
        return count > 0;
    }

    public boolean unregister(Object item) {
        if (item == null) {
            throw new NullPointerException("Item must not be null.");
        }
        Set<Class<?>> registeredFor = this.items.remove(item);
        if (registeredFor == null) {
            return false;
        }
        for (Class<?> type : registeredFor) {
            ItemList<?> itemList = this.itemListMap.get(type);
            if (itemList == null || !itemList.unregisterObject(item) || !((ItemList)itemList).itemNodes.isEmpty()) continue;
            this.itemListMap.remove(type);
        }
        return true;
    }

    public boolean unregister(Class<?> type) {
        if (type == null) {
            throw new NullPointerException("Type must not be null.");
        }
        ItemList<?> itemList = this.itemListMap.remove(type);
        if (itemList == null) {
            return false;
        }
        for (ItemNode node : ((ItemList)itemList).itemNodes) {
            Object item = node.item;
            Set<Class<?>> registeredFor = this.items.get(item);
            if (registeredFor == null) continue;
            registeredFor.remove(type);
            if (!registeredFor.isEmpty()) continue;
            this.items.remove(item);
        }
        return true;
    }

    public boolean unregister(Collection<Object> items) {
        boolean had = false;
        for (Object item : items) {
            had |= this.unregister(item);
        }
        return had;
    }

    public <T, I extends T> boolean isRegistered(Class<T> type, I item) {
        if (item == null) {
            throw new NullPointerException("Item must not be null.");
        }
        if (type == null) {
            throw new NullPointerException("Type must not be null.");
        }
        if (this.items.containsKey(item)) {
            ItemList<?> itemList = this.itemListMap.get(type);
            return itemList != null && itemList.isRegisteredObject(item);
        }
        return false;
    }

    public boolean isRegistered(Class<?> type) {
        if (type == null) {
            throw new NullPointerException("Type must not be null.");
        }
        return this.itemListMap.containsKey(type);
    }

    public boolean isRegistered(Object item) {
        if (item == null) {
            throw new NullPointerException("Item must not be null.");
        }
        return this.items.containsKey(item);
    }

    public List<Object> getAllRegisteredItems() {
        return new ArrayList<Object>(this.items.keySet());
    }

    public void sortAll() {
        for (ItemList<?> itemList : this.itemListMap.values()) {
            if (((ItemList)itemList).sortedItemNodes != null) continue;
            itemList.sort();
        }
    }

    public <T> List<T> getSortedItemsCopyList(Class<T> type) {
        ItemList<?> itemList = this.itemListMap.get(type);
        return itemList == null ? new LinkedList() : itemList.getSortedItemsCopyList();
    }

    public <T> T[] getSortedItemsReferenceArray(Class<T> type) {
        ItemList<?> itemList = this.itemListMap.get(type);
        return itemList == null ? null : itemList.getSortedItemsReferenceArray();
    }

    public void clear() {
        this.items.clear();
        this.itemListMap.clear();
    }

    static final class ItemList<T> {
        private final SortItemNode<T> typedSort = new SortItemNode();
        private final List<ItemNode<T>> itemNodes = new LinkedList<ItemNode<T>>();
        private ItemNode<T>[] sortedItemNodes = null;
        private T[] sortedItems = null;

        ItemList() {
        }

        void sort() {
            this.sortedItemNodes = this.typedSort.getSortedArray(this.itemNodes);
            this.sortedItems = new Object[this.sortedItemNodes.length];
            for (int i = 0; i < this.sortedItemNodes.length; ++i) {
                this.sortedItems[i] = this.sortedItemNodes[i].item;
            }
        }

        void invalidateSorted() {
            this.sortedItemNodes = null;
            this.sortedItems = null;
        }

        T[] getSortedItemsReferenceArray() {
            return this.sortedItems;
        }

        List<T> getSortedItemsCopyList() {
            LinkedList out = new LinkedList();
            Collections.addAll(out, this.sortedItems);
            return out;
        }

        void register(RegistrationOrder order, T item, int internalCount) {
            this.itemNodes.add(new ItemNode(order, item, internalCount));
            this.invalidateSorted();
        }

        boolean unregister(T item) {
            Iterator<ItemNode<T>> it = this.itemNodes.iterator();
            while (it.hasNext()) {
                if (!it.next().item.equals(item)) continue;
                this.invalidateSorted();
                it.remove();
                return true;
            }
            return false;
        }

        boolean unregisterObject(Object item) {
            return this.unregister(item);
        }

        boolean isRegisteredObject(Object item) {
            for (ItemNode<T> node : this.itemNodes) {
                if (!item.equals(node.item)) continue;
                return true;
            }
            return false;
        }
    }

    static final class SortItemNode<T>
    extends RegistrationOrder.AbstractRegistrationOrderSort<ItemNode<T>> {
        SortItemNode() {
        }

        @Override
        protected RegistrationOrder fetchRegistrationOrder(ItemNode<T> item) {
            return item.getRegistrationOrder();
        }
    }

    static class ItemNode<T>
    implements IGetRegistrationOrder,
    Comparable<ItemNode<T>> {
        final RegistrationOrder order;
        final T item;
        final int internalCount;

        <I extends T> ItemNode(RegistrationOrder order, I item, int internalCount) {
            this.order = order;
            this.item = item;
            this.internalCount = internalCount;
        }

        @Override
        public RegistrationOrder getRegistrationOrder() {
            return this.order;
        }

        @Override
        public int compareTo(ItemNode<T> o) {
            return Integer.compare(this.internalCount, o.internalCount);
        }
    }
}

