/*
 * Decompiled with CFR 0.152.
 */
package fr.neatmonster.nocheatplus.components.registry;

import fr.neatmonster.nocheatplus.components.registry.GenericInstanceRegistry;
import fr.neatmonster.nocheatplus.components.registry.event.GenericInstanceHandle;
import fr.neatmonster.nocheatplus.components.registry.event.IGenericInstanceHandle;
import fr.neatmonster.nocheatplus.components.registry.event.IGenericInstanceRegistryListener;
import fr.neatmonster.nocheatplus.components.registry.event.IUnregisterGenericInstanceRegistryListener;
import fr.neatmonster.nocheatplus.components.registry.exception.RegistrationLockedException;
import fr.neatmonster.nocheatplus.logging.details.IGetStreamId;
import fr.neatmonster.nocheatplus.logging.details.ILogString;
import fr.neatmonster.nocheatplus.utilities.ds.corw.LinkedHashMapCOW;
import java.util.LinkedList;
import java.util.List;

public class DefaultGenericInstanceRegistry
implements GenericInstanceRegistry,
IUnregisterGenericInstanceRegistryListener {
    private final LinkedHashMapCOW<Class<?>, Registration<?>> registrations = new LinkedHashMapCOW();
    private ILogString logger = null;
    private IGetStreamId selectStream;
    private String logPrefix;

    public void setLogger(ILogString logger, IGetStreamId selectStream, String logPrefix) {
        this.logger = logger;
        this.selectStream = selectStream;
        this.logPrefix = logPrefix;
    }

    private <T> Registration<T> getRegistration(Class<T> registeredFor, boolean create) {
        Registration<Object> registration = this.registrations.get(registeredFor);
        if (registration == null && create) {
            registration = new Registration<Object>(registeredFor, null, this, this);
            this.registrations.put(registeredFor, registration);
        }
        return registration;
    }

    @Override
    public <T> void unregisterGenericInstanceRegistryListener(Class<T> registeredFor, IGenericInstanceRegistryListener<T> listener) {
        Registration<T> registration = this.getRegistration(registeredFor, false);
        if (registration != null) {
            registration.unregisterListener(listener);
        }
    }

    @Override
    public <T> T registerGenericInstance(T instance) {
        return (T)this.registerGenericInstance(instance.getClass(), instance);
    }

    @Override
    public <T, TI extends T> T registerGenericInstance(Class<T> registerFor, TI instance) {
        Registration<TI> registration = this.getRegistration(registerFor, true);
        T previouslyRegistered = registration.registerInstance(instance);
        String msg = previouslyRegistered == null ? "Registered for " : "Registered (override) for ";
        String registerForName = registerFor.getName();
        String instanceName = instance.getClass().getName();
        msg = registerForName.equals(instanceName) ? msg + "itself: " + instanceName : msg + registerForName + ": " + instanceName;
        this.logRegistryEvent(msg);
        return previouslyRegistered;
    }

    @Override
    public <T> T getGenericInstance(Class<T> registeredFor) {
        Registration<T> registration = this.getRegistration(registeredFor, false);
        return registration == null ? null : (T)registration.getInstance();
    }

    @Override
    public <T> T unregisterGenericInstance(Class<T> registeredFor) {
        T registered;
        Registration<T> registration = this.getRegistration(registeredFor, false);
        T t = registered = registration == null ? null : (T)registration.unregisterInstance();
        if (registered != null) {
            this.logRegistryEvent("Unregister, remove mapping for: " + registeredFor.getName());
        } else {
            this.logRegistryEvent("Unregister, no mapping present for: " + registeredFor.getName());
        }
        if (this.registrations.containsKey(registeredFor) && this.getRegistration(registeredFor, false).canBeRemoved()) {
            this.registrations.remove(registeredFor);
        }
        return registered;
    }

    @Override
    public <T> IGenericInstanceHandle<T> getGenericInstanceHandle(Class<T> registeredFor) {
        return this.getRegistration(registeredFor, true).getHandle();
    }

    public void clear() {
        for (Registration<?> registration : this.registrations.values()) {
            registration.clear();
        }
        this.registrations.clear();
        this.logRegistryEvent("Registry cleared.");
    }

    public void denyChangeExistingRegistration(Class<?> registeredFor) {
        Registration<?> registration = this.getRegistration(registeredFor, false);
        if (registration != null) {
            registration.denyOverrideInstance();
            registration.denyRemoveInstance();
        }
    }

    protected void logRegistryEvent(String message) {
        if (this.logger != null) {
            this.logger.info(this.selectStream.getStreamId(), this.logPrefix == null ? message : this.logPrefix + message);
        }
    }

    public static class Registration<T> {
        private static final long DENY_OVERRIDE_INSTANCE = 1L;
        private static final long DENY_REMOVE_INSTANCE = 2L;
        private final GenericInstanceRegistry registry;
        private final IUnregisterGenericInstanceRegistryListener unregister;
        private final Class<T> registeredFor;
        private T instance = null;
        private GenericInstanceHandle.ReferenceCountHandle<T> uniqueHandle = null;
        private long accessFlags = 0L;
        private final List<IGenericInstanceRegistryListener<T>> listeners = new LinkedList<IGenericInstanceRegistryListener<T>>();

        public Registration(Class<T> registeredFor, T instance, GenericInstanceRegistry registry, IUnregisterGenericInstanceRegistryListener unregister) {
            this.registry = registry;
            this.unregister = unregister;
            this.registeredFor = registeredFor;
            this.instance = instance;
        }

        public void denyOverrideInstance() {
            this.accessFlags |= 1L;
        }

        public void denyRemoveInstance() {
            this.accessFlags |= 2L;
        }

        public T unregisterInstance() {
            if ((this.accessFlags & 2L) != 0L) {
                throw new RegistrationLockedException();
            }
            T oldInstance = this.instance;
            this.instance = null;
            if (!this.listeners.isEmpty()) {
                for (IGenericInstanceRegistryListener<T> listener : this.listeners) {
                    listener.onGenericInstanceRemove(this.registeredFor, oldInstance);
                }
            }
            return oldInstance;
        }

        public T registerInstance(T instance) {
            T oldInstance;
            block5: {
                if ((this.accessFlags & 1L) != 0L) {
                    throw new RegistrationLockedException();
                }
                oldInstance = this.instance;
                this.instance = instance;
                if (this.listeners.isEmpty()) break block5;
                if (oldInstance == null) {
                    for (IGenericInstanceRegistryListener<T> listener : this.listeners) {
                        listener.onGenericInstanceOverride(this.registeredFor, instance, oldInstance);
                    }
                } else {
                    for (IGenericInstanceRegistryListener<T> listener : this.listeners) {
                        listener.onGenericInstanceRegister(this.registeredFor, instance);
                    }
                }
            }
            return oldInstance;
        }

        public IGenericInstanceHandle<T> getHandle() {
            if (this.uniqueHandle != null && this.uniqueHandle.isDisabled()) {
                this.unregisterListener(this.uniqueHandle);
            }
            if (this.uniqueHandle == null) {
                this.uniqueHandle = new GenericInstanceHandle.ReferenceCountHandle<T>(this.registeredFor, this.registry, this.unregister);
                this.listeners.add(this.uniqueHandle);
                this.uniqueHandle.getHandle();
            }
            return this.uniqueHandle.getNewHandle();
        }

        public void unregisterListener(IGenericInstanceRegistryListener<T> listener) {
            GenericInstanceHandle.ReferenceCountHandle<T> disable = null;
            if (listener == this.uniqueHandle) {
                disable = this.uniqueHandle;
                this.uniqueHandle = null;
            }
            this.listeners.remove(listener);
            if (disable != null) {
                disable.disableHandle();
            }
        }

        public T getInstance() {
            return this.instance;
        }

        public boolean canBeRemoved() {
            return this.instance == null && this.uniqueHandle == null && this.listeners.isEmpty();
        }

        public void clear() {
            this.instance = null;
            if (this.uniqueHandle != null) {
                this.uniqueHandle.disableHandle();
                this.uniqueHandle = null;
            }
            this.listeners.clear();
        }
    }
}

